/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.query;

import java.util.Collections;
import java.util.List;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.Search;
import org.infinispan.protostream.sampledomain.Address;
import org.infinispan.protostream.sampledomain.User;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.server.test.query.RemoteQueryBaseTest;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@WithRunningServer(value={@RunningServer(name="remote-query")})
public class RemoteQueryTest
extends RemoteQueryBaseTest {
    @InfinispanResource(value="remote-query")
    protected RemoteInfinispanServer server;

    public RemoteQueryTest() {
        super("local", "testcache");
    }

    protected RemoteQueryTest(String cacheContainerName, String cacheName) {
        super(cacheContainerName, cacheName);
    }

    @Override
    protected RemoteInfinispanServer getServer() {
        return this.server;
    }

    @Test
    public void testAttributeQuery() throws Exception {
        this.remoteCache.put((Object)1, (Object)this.createUser1());
        this.remoteCache.put((Object)2, (Object)this.createUser2());
        User fromCache = (User)this.remoteCache.get((Object)1);
        this.assertUser(fromCache);
        QueryFactory qf = Search.getQueryFactory((RemoteCache)this.remoteCache);
        Query query = qf.from(User.class).having("name").eq((Object)"Tom").toBuilder().build();
        List list = query.list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(User.class, ((User)list.get(0)).getClass());
        this.assertUser((User)list.get(0));
    }

    @Test
    public void testEmbeddedAttributeQuery() throws Exception {
        this.remoteCache.put((Object)1, (Object)this.createUser1());
        this.remoteCache.put((Object)2, (Object)this.createUser2());
        QueryFactory qf = Search.getQueryFactory((RemoteCache)this.remoteCache);
        Query query = qf.from(User.class).having("addresses.postCode").eq((Object)"1234").toBuilder().build();
        List list = query.list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(User.class, ((User)list.get(0)).getClass());
        this.assertUser((User)list.get(0));
    }

    @Test
    public void testProjections() throws Exception {
        this.remoteCache.put((Object)1, (Object)this.createUser1());
        this.remoteCache.put((Object)2, (Object)this.createUser2());
        User fromCache = (User)this.remoteCache.get((Object)1);
        this.assertUser(fromCache);
        QueryFactory qf = Search.getQueryFactory((RemoteCache)this.remoteCache);
        Query query = qf.from(User.class).setProjection(new String[]{"name", "surname"}).having("name").eq((Object)"Tom").toBuilder().build();
        List list = query.list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(Object[].class, ((Object[])list.get(0)).getClass());
        Assert.assertEquals((Object)"Tom", (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)"Cat", (Object)((Object[])list.get(0))[1]);
    }

    private User createUser1() {
        User user = new User();
        user.setId(1);
        user.setName("Tom");
        user.setSurname("Cat");
        user.setGender(User.Gender.MALE);
        user.setAccountIds(Collections.singletonList(12));
        Address address = new Address();
        address.setStreet("Dark Alley");
        address.setPostCode("1234");
        user.setAddresses(Collections.singletonList(address));
        return user;
    }

    private User createUser2() {
        User user = new User();
        user.setId(1);
        user.setName("Adrian");
        user.setSurname("Nistor");
        user.setGender(User.Gender.MALE);
        Address address = new Address();
        address.setStreet("Old Street");
        address.setPostCode("XYZ");
        user.setAddresses(Collections.singletonList(address));
        return user;
    }

    private void assertUser(User user) {
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((long)1L, (long)user.getId());
        Assert.assertEquals((Object)"Tom", (Object)user.getName());
        Assert.assertEquals((Object)"Cat", (Object)user.getSurname());
        Assert.assertEquals((Object)User.Gender.MALE, (Object)user.getGender());
        Assert.assertNotNull((Object)user.getAccountIds());
        Assert.assertEquals((long)1L, (long)user.getAccountIds().size());
        Assert.assertEquals((long)12L, (long)((Integer)user.getAccountIds().get(0)).intValue());
        Assert.assertNotNull((Object)user.getAddresses());
        Assert.assertEquals((long)1L, (long)user.getAddresses().size());
        Assert.assertEquals((Object)"Dark Alley", (Object)((Address)user.getAddresses().get(0)).getStreet());
        Assert.assertEquals((Object)"1234", (Object)((Address)user.getAddresses().get(0)).getPostCode());
    }
}

