/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.rollingupgrades;

import javax.management.ObjectName;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServers;
import org.infinispan.arquillian.utils.MBeanServerConnectionProvider;
import org.infinispan.server.test.category.RollingUpgrades;
import org.infinispan.server.test.client.rest.RESTHelper;
import org.infinispan.server.test.util.RemoteInfinispanMBeans;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={RollingUpgrades.class})
public class RestRollingUpgradesTest {
    @InfinispanResource
    RemoteInfinispanServers serverManager;
    static final String DEFAULT_CACHE_NAME = "default";
    static final int PORT_OFFSET = 100;
    @ArquillianResource
    ContainerController controller;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestRollingUpgradesDiffVersions() throws Exception {
        int managementPortServer1 = 9999;
        int managementPortServer2 = 10099;
        this.controller.start("rest-rolling-upgrade-2-old");
        try {
            RemoteInfinispanMBeans s2 = this.createRemotes("rest-rolling-upgrade-2-old", "local", DEFAULT_CACHE_NAME);
            RESTHelper.addServer(s2.server.getRESTEndpoint().getInetAddress().getHostName(), s2.server.getRESTEndpoint().getContextPath());
            RESTHelper.post(RESTHelper.fullPathKey(0, DEFAULT_CACHE_NAME, "key1", 100), "data", "text/html");
            RESTHelper.get(RESTHelper.fullPathKey(0, DEFAULT_CACHE_NAME, "key1", 100), "data");
            for (int i = 0; i < 50; ++i) {
                RESTHelper.post(RESTHelper.fullPathKey(0, DEFAULT_CACHE_NAME, "keyLoad" + i, 100), "valueLoad" + i, "text/html");
            }
            this.controller.start("rest-rolling-upgrade-1");
            RemoteInfinispanMBeans s1 = this.createRemotes("rest-rolling-upgrade-1", "local", DEFAULT_CACHE_NAME);
            RESTHelper.addServer(s1.server.getRESTEndpoint().getInetAddress().getHostName(), s1.server.getRESTEndpoint().getContextPath());
            RESTHelper.get(RESTHelper.fullPathKey(1, DEFAULT_CACHE_NAME, "key1", 0), "data");
            MBeanServerConnectionProvider provider1 = new MBeanServerConnectionProvider(s1.server.getRESTEndpoint().getInetAddress().getHostName(), 9999);
            MBeanServerConnectionProvider provider2 = new MBeanServerConnectionProvider(s2.server.getRESTEndpoint().getInetAddress().getHostName(), 10099);
            ObjectName rollMan = new ObjectName("jboss.infinispan:type=Cache,name=\"default(local)\",manager=\"local\",component=RollingUpgradeManager");
            this.invokeOperation(provider2, rollMan.toString(), "recordKnownGlobalKeyset", new Object[0], new String[0]);
            this.invokeOperation(provider1, rollMan.toString(), "synchronizeData", new Object[]{"rest"}, new String[]{"java.lang.String"});
            this.invokeOperation(provider1, rollMan.toString(), "disconnectSource", new Object[]{"rest"}, new String[]{"java.lang.String"});
            RESTHelper.post(RESTHelper.fullPathKey(0, DEFAULT_CACHE_NAME, "disconnected", 100), "source", "application/text");
            RESTHelper.get(RESTHelper.fullPathKey(1, DEFAULT_CACHE_NAME, "disconnected", 0), 404);
            for (int i = 0; i < 50; ++i) {
                RESTHelper.get(RESTHelper.fullPathKey(1, DEFAULT_CACHE_NAME, "keyLoad" + i, 0), "valueLoad" + i);
            }
        }
        finally {
            if (this.controller.isStarted("rest-rolling-upgrade-1")) {
                this.controller.stop("rest-rolling-upgrade-1");
            }
            if (this.controller.isStarted("rest-rolling-upgrade-2-old")) {
                this.controller.stop("rest-rolling-upgrade-2-old");
            }
        }
    }

    protected RemoteInfinispanMBeans createRemotes(String serverName, String managerName, String cacheName) {
        return RemoteInfinispanMBeans.create(this.serverManager, serverName, cacheName, managerName);
    }

    private Object invokeOperation(MBeanServerConnectionProvider provider, String mbean, String operationName, Object[] params, String[] signature) throws Exception {
        return provider.getConnection().invoke(new ObjectName(mbean), operationName, params, signature);
    }
}

