/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.util;

import java.io.IOException;
import java.io.InputStream;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.infinispan.commons.util.Util;

public class ProtofileRegistrar {
    public static void main(String[] args) {
        if (args.length != 3) {
            System.err.println("There are 3 parameters required:\n1) path to a protofile\n2) server host\n3) server JMX port");
            System.exit(1);
        }
        String PROTOFILE_PATH = args[0];
        String SERVER_HOST = args[1];
        int JMX_PORT = Integer.parseInt(args[2]);
        ProtofileRegistrar registrar = new ProtofileRegistrar();
        try {
            registrar.registerProtofile(PROTOFILE_PATH, SERVER_HOST, JMX_PORT);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void registerProtofile(String protofilePath, String host, int jmxPort) throws Exception {
        JMXConnector jmxConnector = JMXConnectorFactory.connect(new JMXServiceURL("service:jmx:remoting-jmx://" + host + ":" + jmxPort));
        MBeanServerConnection jmxConnection = jmxConnector.getMBeanServerConnection();
        ObjectName objName = new ObjectName("jboss.infinispan:type=RemoteQuery,name=" + ObjectName.quote("local") + ",component=ProtobufMetadataManager");
        byte[] descriptor = this.readClasspathResource(protofilePath);
        jmxConnection.invoke(objName, "registerProtofile", new Object[]{descriptor}, new String[]{byte[].class.getName()});
        System.out.printf("Successfully registered protofile %s at %s/%d\n", protofilePath, host, jmxPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readClasspathResource(String c) throws IOException {
        InputStream is = this.getClass().getResourceAsStream(c);
        try {
            byte[] byArray = Util.readStream((InputStream)is);
            return byArray;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }
}

