/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import javax.management.Attribute;
import javax.management.ObjectName;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.utils.MBeanServerConnectionProvider;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.server.test.client.memcached.MemcachedClient;
import org.infinispan.server.test.util.RemoteInfinispanMBeans;
import org.jboss.arquillian.container.test.api.Config;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.junit.Assert;

public class TestUtil {
    public static final String SERVER_DATA_DIR = System.getProperty("server1.dist") + File.separator + "standalone" + File.separator + "data";
    public static final String SERVER_CONFIG_DIR = System.getProperty("server1.dist") + File.separator + "standalone" + File.separator + "configuration";
    private static final String SERVER_CONFIG_PROPERTY = "serverConfig";

    public static RemoteCacheManager createCacheManager(RemoteInfinispanServer server) {
        return TestUtil.createCacheManager(server, "2.0");
    }

    public static RemoteCacheManager createCacheManager(RemoteInfinispanServer server, String protocolVersion) {
        return new RemoteCacheManager(TestUtil.createConfigBuilder(server.getHotrodEndpoint().getInetAddress().getHostName(), server.getHotrodEndpoint().getPort(), protocolVersion).build());
    }

    public static ConfigurationBuilder createConfigBuilder(String hostName, int port) {
        return TestUtil.createConfigBuilder(hostName, port, "2.0");
    }

    public static ConfigurationBuilder createConfigBuilder(String hostName, int port, String protocolVersion) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host(hostName).port(port).protocolVersion(protocolVersion);
        return builder;
    }

    public static RemoteCacheManager createCacheManager(RemoteInfinispanMBeans serverBeans) {
        return TestUtil.createCacheManager(serverBeans.server);
    }

    public static String getAttribute(MBeanServerConnectionProvider provider, String mbean, String attr) throws Exception {
        return provider.getConnection().getAttribute(new ObjectName(mbean), attr).toString();
    }

    public static void setAttribute(MBeanServerConnectionProvider provider, String mbean, String attrName, Object attrValue) throws Exception {
        provider.getConnection().setAttribute(new ObjectName(mbean), new Attribute(attrName, attrValue));
    }

    public static Object invokeOperation(MBeanServerConnectionProvider provider, String mbean, String operationName, Object[] params, String[] signature) throws Exception {
        return provider.getConnection().invoke(new ObjectName(mbean), operationName, params, signature);
    }

    public static void eventually(Condition ec, long timeout) {
        TestUtil.eventually(ec, timeout, 10);
    }

    public static void eventually(Condition ec, long timeout, int loops) {
        if (loops <= 0) {
            throw new IllegalArgumentException("Number of loops must be positive");
        }
        long sleepDuration = timeout / (long)loops;
        if (sleepDuration == 0L) {
            sleepDuration = 1L;
        }
        try {
            for (int i = 0; i < loops; ++i) {
                if (ec.isSatisfied()) {
                    return;
                }
                Thread.sleep(sleepDuration);
            }
            Assert.assertTrue((boolean)ec.isSatisfied());
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected!", e);
        }
    }

    public static byte[] getRealKeyStored(String key, RemoteCache rc) throws Exception {
        Marshaller m = TestUtil.getMarshallerField((RemoteCacheImpl)rc);
        return m.objectToByteBuffer((Object)key, 64);
    }

    private static Marshaller getMarshallerField(RemoteCacheImpl rci) throws Exception {
        Marshaller fieldValue;
        Field field;
        try {
            field = RemoteCacheImpl.class.getDeclaredField("marshaller");
        }
        catch (NoSuchFieldException e) {
            throw new Exception("Could not access marshaller field", e);
        }
        field.setAccessible(true);
        try {
            fieldValue = (Marshaller)field.get(rci);
        }
        catch (IllegalAccessException e) {
            throw new Exception("Could not access marshaller field", e);
        }
        return fieldValue;
    }

    public static void startContainer(ContainerController controller, String containerName, String config) {
        controller.start(containerName, new Config().add(SERVER_CONFIG_PROPERTY, config).map());
    }

    public static void stopContainers(ContainerController controller, String ... containerNames) {
        for (String name : containerNames) {
            controller.stop(name);
        }
    }

    public static RemoteInfinispanMBeans createMBeans(RemoteInfinispanServer server, String containerName, String cacheName, String managerName) {
        return RemoteInfinispanMBeans.create(server, containerName, cacheName, managerName);
    }

    public static MemcachedClient createMemcachedClient(RemoteInfinispanServer server) {
        MemcachedClient mc;
        try {
            mc = new MemcachedClient(server.getMemcachedEndpoint().getInetAddress().getHostName(), server.getMemcachedEndpoint().getPort());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create Memcached Client");
        }
        return mc;
    }

    public static interface Condition {
        public boolean isSatisfied() throws Exception;
    }
}

