/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.memcached;

import java.util.List;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.server.test.client.memcached.MemcachedClient;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractClusteredMemcachedIT {
    static final String ENCODING = "UTF-8";
    static final String KEY_A = "a";
    static final String KEY_B = "b";
    static final String KEY_C = "c";
    MemcachedClient mc1;
    MemcachedClient mc2;

    protected abstract List<RemoteInfinispanServer> getServers();

    @Before
    public void setUp() throws Exception {
        this.mc1 = new MemcachedClient(ENCODING, this.getServers().get(0).getMemcachedEndpoint().getInetAddress().getHostName(), this.getServers().get(0).getMemcachedEndpoint().getPort(), 10000);
        this.mc2 = new MemcachedClient(ENCODING, this.getServers().get(1).getMemcachedEndpoint().getInetAddress().getHostName(), this.getServers().get(1).getMemcachedEndpoint().getPort(), 10000);
        this.mc1.delete(KEY_A);
        this.mc1.delete(KEY_B);
        this.mc1.delete(KEY_C);
        this.mc2.delete(KEY_A);
        this.mc2.delete(KEY_B);
        this.mc2.delete(KEY_C);
        Assert.assertNull((Object)this.mc1.get(KEY_A));
        Assert.assertNull((Object)this.mc1.get(KEY_B));
        Assert.assertNull((Object)this.mc1.get(KEY_C));
        Assert.assertNull((Object)this.mc2.get(KEY_A));
        Assert.assertNull((Object)this.mc2.get(KEY_B));
        Assert.assertNull((Object)this.mc2.get(KEY_C));
    }

    @After
    public void tearDown() throws Exception {
        this.mc1.delete(KEY_A);
        this.mc1.delete(KEY_B);
        this.mc1.delete(KEY_C);
        this.mc2.delete(KEY_A);
        this.mc2.delete(KEY_B);
        this.mc2.delete(KEY_C);
        this.mc1.close();
        this.mc2.close();
    }

    @Test
    public void testReplicatedSet() throws Exception {
        this.mc1.set(KEY_A, "A");
        Assert.assertEquals((Object)"A", (Object)this.mc2.get(KEY_A));
    }

    @Test
    public void testReplicatedGetMultipleKeys() throws Exception {
        this.mc1.set(KEY_A, "A");
        this.mc1.set(KEY_B, "B");
        this.mc1.set(KEY_C, "C");
        this.mc2.writeln("get a b c");
        this.mc2.flush();
        Assert.assertEquals((Object)"VALUE a 0 1", (Object)this.mc2.readln());
        Assert.assertEquals((Object)"A", (Object)this.mc2.readln());
        Assert.assertEquals((Object)"VALUE b 0 1", (Object)this.mc2.readln());
        Assert.assertEquals((Object)"B", (Object)this.mc2.readln());
        Assert.assertEquals((Object)"VALUE c 0 1", (Object)this.mc2.readln());
        Assert.assertEquals((Object)"C", (Object)this.mc2.readln());
        Assert.assertEquals((Object)"END", (Object)this.mc2.readln());
    }

    @Test
    public void testReplicatedAdd() throws Exception {
        String data = "testAdd";
        this.mc1.writeln("add a 0 0 " + data.getBytes(ENCODING).length);
        this.mc1.writeln(data);
        this.mc1.flush();
        Assert.assertEquals((Object)"STORED", (Object)this.mc1.readln());
        Assert.assertEquals((Object)data, (Object)this.mc2.get(KEY_A));
    }

    @Test
    public void testReplicatedReplace() throws Exception {
        this.mc1.set(KEY_A, "data1");
        Assert.assertEquals((Object)"data1", (Object)this.mc2.get(KEY_A));
        this.mc1.writeln("replace a 0 0 " + "data2".getBytes(ENCODING).length);
        this.mc1.writeln("data2");
        this.mc1.flush();
        Assert.assertEquals((Object)"STORED", (Object)this.mc1.readln());
        Assert.assertEquals((Object)"data2", (Object)this.mc2.get(KEY_A));
    }

    @Test
    public void testReplicatedAppend() throws Exception {
        this.mc1.set(KEY_A, "Hello");
        Assert.assertEquals((Object)"Hello", (Object)this.mc2.get(KEY_A));
        this.mc2.writeln("append a 0 0 " + ", World!".getBytes(ENCODING).length);
        this.mc2.writeln(", World!");
        this.mc2.flush();
        Assert.assertEquals((Object)"STORED", (Object)this.mc2.readln());
        Assert.assertEquals((Object)"Hello, World!", (Object)this.mc1.get(KEY_A));
    }

    @Test
    public void testReplicatedPrepend() throws Exception {
        this.mc1.set(KEY_A, "World!");
        Assert.assertEquals((Object)"World!", (Object)this.mc1.get(KEY_A));
        this.mc2.writeln("prepend a 0 0 " + "Hello, ".getBytes(ENCODING).length);
        this.mc2.writeln("Hello, ");
        this.mc2.flush();
        Assert.assertEquals((Object)"STORED", (Object)this.mc2.readln());
        Assert.assertEquals((Object)"Hello, World!", (Object)this.mc1.get(KEY_A));
    }

    @Test
    public void testReplicatedCas() throws Exception {
        this.mc1.set(KEY_A, "A");
        String casId = this.mc2.getCasId(KEY_A);
        this.mc2.writeln("cas a 0 0 1 " + casId);
        this.mc2.writeln("B");
        this.mc2.flush();
        Assert.assertEquals((Object)"STORED", (Object)this.mc2.readln());
        Assert.assertEquals((Object)"B", (Object)this.mc1.get(KEY_A));
    }

    @Test
    public void testReplicatedCasExists() throws Exception {
        this.mc1.set(KEY_A, "A");
        String casId = this.mc2.getCasId(KEY_A);
        this.mc2.writeln("cas a 0 0 1 1" + casId);
        this.mc2.writeln("B");
        this.mc2.flush();
        Assert.assertEquals((Object)"EXISTS", (Object)this.mc2.readln());
        Assert.assertEquals((Object)"A", (Object)this.mc1.get(KEY_A));
    }

    @Test
    public void testReplicatedCasExists2() throws Exception {
        this.mc1.set(KEY_A, "A");
        String casId1 = this.mc1.getCasId(KEY_A);
        String casId2 = this.mc2.getCasId(KEY_A);
        Assert.assertEquals((Object)casId1, (Object)casId2);
        this.mc2.writeln("cas a 0 0 2 " + casId1);
        this.mc2.writeln("B2");
        this.mc2.flush();
        Assert.assertEquals((Object)"STORED", (Object)this.mc2.readln());
        this.mc1.writeln("cas a 0 0 2 " + casId1);
        this.mc1.writeln("B1");
        this.mc1.flush();
        Assert.assertEquals((Object)"EXISTS", (Object)this.mc1.readln());
    }

    @Test
    public void testReplicatedDelete() throws Exception {
        this.mc1.set(KEY_A, "A");
        Assert.assertEquals((Object)"A", (Object)this.mc2.get(KEY_A));
        Assert.assertEquals((Object)"DELETED", (Object)this.mc1.delete(KEY_A));
        Assert.assertNull((Object)this.mc2.get(KEY_A));
    }

    @Test
    public void testReplicatedIncrement() throws Exception {
        this.mc1.set(KEY_A, "0");
        this.mc2.writeln("incr a 1");
        this.mc2.flush();
        Assert.assertEquals((Object)"1", (Object)this.mc2.readln());
    }

    @Test
    public void testReplicatedDecrement() throws Exception {
        this.mc1.set(KEY_A, "1");
        this.mc2.writeln("decr a 1");
        this.mc2.flush();
        Assert.assertEquals((Object)"0", (Object)this.mc2.readln());
    }

    @Test
    public void testReplicatedFlushAll() throws Exception {
        this.mc1.set(KEY_A, "1");
        this.mc1.set(KEY_B, "2");
        this.mc1.set(KEY_C, "3");
        this.mc2.writeln("flush_all");
        this.mc2.flush();
        Assert.assertEquals((Object)"OK", (Object)this.mc2.readln());
        Assert.assertNull((Object)this.mc1.get(KEY_A));
        Assert.assertNull((Object)this.mc1.get(KEY_B));
        Assert.assertNull((Object)this.mc1.get(KEY_C));
    }
}

