/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.configs;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.ObjectInputStream;
import java.net.Inet6Address;
import java.util.ArrayList;
import javax.management.ObjectName;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RESTEndpoint;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RemoteInfinispanServers;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.arquillian.utils.MBeanServerConnectionProvider;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.server.test.category.Unstable;
import org.infinispan.server.test.client.memcached.MemcachedClient;
import org.infinispan.server.test.client.rest.RESTHelper;
import org.infinispan.server.test.util.ITestUtils;
import org.infinispan.server.test.util.RemoteCacheManagerFactory;
import org.infinispan.server.test.util.RemoteInfinispanMBeans;
import org.jboss.arquillian.container.test.api.Config;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@Category(value={Unstable.class})
@RunWith(value=Arquillian.class)
public class ExampleConfigsIT {
    private static final Logger log = Logger.getLogger(ExampleConfigsIT.class);
    @InfinispanResource
    RemoteInfinispanServers serverManager;
    static final String DEFAULT_CACHE_NAME = "default";
    static final String NAMED_CACHE_NAME = "namedCache";
    static final String MEMCACHED_CACHE_NAME = "memcachedCache";
    @ArquillianResource
    ContainerController controller;
    RemoteCacheManagerFactory rcmFactory;

    @Before
    public void setUp() {
        this.rcmFactory = new RemoteCacheManagerFactory();
    }

    @After
    public void tearDown() {
        if (this.rcmFactory != null) {
            this.rcmFactory.stopManagers();
        }
        this.rcmFactory = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @WithRunningServer(value={@RunningServer(name="clustered-ccl-1")})
    public void testClusterCacheLoaderConfigExample() throws Exception {
        try {
            RemoteInfinispanMBeans s1 = this.createRemotes("clustered-ccl-1", "clustered", DEFAULT_CACHE_NAME);
            RemoteCache<Object, Object> s1Cache = this.createCache(s1);
            s1Cache.put((Object)"key", (Object)"value");
            Assert.assertEquals((long)1L, (long)s1.cache.getNumberOfEntries());
            Assert.assertEquals((long)1L, (long)s1.manager.getClusterSize());
            this.controller.start("clustered-ccl-2");
            RemoteInfinispanMBeans s2 = this.createRemotes("clustered-ccl-2", "clustered", DEFAULT_CACHE_NAME);
            RemoteCache<Object, Object> s2Cache = this.createCache(s2);
            Assert.assertEquals((long)2L, (long)s2.manager.getClusterSize());
            Assert.assertEquals((long)0L, (long)s2.cache.getNumberOfEntries());
            s2Cache.get((Object)"key");
            Assert.assertEquals((long)1L, (long)s2.cache.getNumberOfEntries());
            s2Cache.put((Object)"key2", (Object)"value2");
            Assert.assertEquals((long)2L, (long)s1.cache.getNumberOfEntries());
            Assert.assertEquals((long)2L, (long)s2.cache.getNumberOfEntries());
        }
        finally {
            if (this.controller.isStarted("clustered-ccl-2")) {
                this.controller.stop("clustered-ccl-2");
            }
        }
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="hotrod-rolling-upgrade-2"), @RunningServer(name="hotrod-rolling-upgrade-1")})
    public void testHotRodRollingUpgrades() throws Exception {
        int managementPortServer1 = 9990;
        int managementPortServer2 = 10099;
        RemoteInfinispanMBeans s2 = this.createRemotes("hotrod-rolling-upgrade-2", "local", DEFAULT_CACHE_NAME);
        RemoteCache<Object, Object> c2 = this.createCache(s2);
        c2.put((Object)"key1", (Object)"value1");
        Assert.assertEquals((Object)"value1", (Object)c2.get((Object)"key1"));
        for (int i = 0; i < 50; ++i) {
            c2.put((Object)("keyLoad" + i), (Object)("valueLoad" + i));
        }
        this.controller.start("hotrod-rolling-upgrade-1");
        RemoteInfinispanMBeans s1 = this.createRemotes("hotrod-rolling-upgrade-1", "local", DEFAULT_CACHE_NAME);
        RemoteCache<Object, Object> c1 = this.createCache(s1);
        Assert.assertEquals((String)"Can't access etries stored in source node (target's RemoteCacheStore).", (Object)"value1", (Object)c1.get((Object)"key1"));
        MBeanServerConnectionProvider provider1 = new MBeanServerConnectionProvider(s1.server.getHotrodEndpoint().getInetAddress().getHostName(), 9990);
        MBeanServerConnectionProvider provider2 = new MBeanServerConnectionProvider(s2.server.getHotrodEndpoint().getInetAddress().getHostName(), 10099);
        ObjectName rollMan = new ObjectName("jboss.infinispan:type=Cache,name=\"default(local)\",manager=\"local\",component=RollingUpgradeManager");
        ITestUtils.invokeOperation(provider2, rollMan.toString(), "recordKnownGlobalKeyset", new Object[0], new String[0]);
        ITestUtils.invokeOperation(provider1, rollMan.toString(), "synchronizeData", new Object[]{"hotrod"}, new String[]{"java.lang.String"});
        ITestUtils.invokeOperation(provider1, rollMan.toString(), "disconnectSource", new Object[]{"hotrod"}, new String[]{"java.lang.String"});
        c2.put((Object)"disconnected", (Object)"source");
        Assert.assertEquals((String)"Can't obtain value from cache1 (source node).", (Object)"source", (Object)c2.get((Object)"disconnected"));
        Assert.assertNull((String)"Source node entries should NOT be accessible from target node (after RCS disconnection)", (Object)c1.get((Object)"disconnected"));
        Assert.assertEquals((String)"Entry was not successfully migrated.", (Object)"value1", (Object)c1.get((Object)"key1"));
        for (int i = 0; i < 50; ++i) {
            Assert.assertEquals((String)"Entry was not successfully migrated.", (Object)("valueLoad" + i), (Object)c1.get((Object)("keyLoad" + i)));
        }
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="rest-rolling-upgrade-2"), @RunningServer(name="rest-rolling-upgrade-1")})
    public void testRestRollingUpgrades() throws Exception {
        int managementPortServer1 = 9990;
        int managementPortServer2 = 10099;
        RemoteInfinispanMBeans s2 = this.createRemotes("rest-rolling-upgrade-2", "local", DEFAULT_CACHE_NAME);
        RemoteCache<Object, Object> c2 = this.createCache(s2);
        c2.put((Object)"key1", (Object)"value1");
        Assert.assertEquals((Object)"value1", (Object)c2.get((Object)"key1"));
        for (int i = 0; i < 50; ++i) {
            c2.put((Object)("keyLoad" + i), (Object)("valueLoad" + i));
        }
        this.controller.start("rest-rolling-upgrade-1");
        RemoteInfinispanMBeans s1 = this.createRemotes("rest-rolling-upgrade-1", "local", DEFAULT_CACHE_NAME);
        RemoteCache<Object, Object> c1 = this.createCache(s1);
        Assert.assertEquals((String)"Can't access etries stored in source node (target's RestCacheStore).", (Object)"value1", (Object)c1.get((Object)"key1"));
        MBeanServerConnectionProvider provider1 = new MBeanServerConnectionProvider(s1.server.getRESTEndpoint().getInetAddress().getHostName(), 9990);
        MBeanServerConnectionProvider provider2 = new MBeanServerConnectionProvider(s2.server.getRESTEndpoint().getInetAddress().getHostName(), 10099);
        ObjectName rollMan = new ObjectName("jboss.infinispan:type=Cache,name=\"default(local)\",manager=\"local\",component=RollingUpgradeManager");
        ITestUtils.invokeOperation(provider2, rollMan.toString(), "recordKnownGlobalKeyset", new Object[0], new String[0]);
        ITestUtils.invokeOperation(provider1, rollMan.toString(), "synchronizeData", new Object[]{"rest"}, new String[]{"java.lang.String"});
        ITestUtils.invokeOperation(provider1, rollMan.toString(), "disconnectSource", new Object[]{"rest"}, new String[]{"java.lang.String"});
        c2.put((Object)"disconnected", (Object)"source");
        Assert.assertEquals((String)"Can't obtain value from cache1 (source node).", (Object)"source", (Object)c2.get((Object)"disconnected"));
        Assert.assertNull((String)"Source node entries should NOT be accessible from target node (after RCS disconnection)", (Object)c1.get((Object)"disconnected"));
        Assert.assertEquals((String)"Entry was not successfully migrated.", (Object)"value1", (Object)c1.get((Object)"key1"));
        for (int i = 0; i < 50; ++i) {
            Assert.assertEquals((String)"Entry was not successfully migrated.", (Object)("valueLoad" + i), (Object)c1.get((Object)("keyLoad" + i)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @WithRunningServer(value={@RunningServer(name="standalone-compatibility-mode")})
    public void testCompatibilityModeConfig() throws Exception {
        MemcachedClient memcachedClient = null;
        CloseableHttpClient restClient = null;
        try {
            RemoteInfinispanMBeans s1 = this.createRemotes("standalone-compatibility-mode", "local", DEFAULT_CACHE_NAME);
            RemoteCache<Object, Object> s1Cache = this.createCache(s1);
            restClient = HttpClients.createDefault();
            String restUrl = "http://" + s1.server.getHotrodEndpoint().getInetAddress().getHostName() + ":8080" + s1.server.getRESTEndpoint().getContextPath() + "/" + DEFAULT_CACHE_NAME;
            memcachedClient = new MemcachedClient(s1.server.getMemcachedEndpoint().getInetAddress().getHostName(), s1.server.getMemcachedEndpoint().getPort());
            String key = "1";
            Assert.assertEquals(null, (Object)s1Cache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)key, (Object)"v1".getBytes()));
            Assert.assertArrayEquals((byte[])"v1".getBytes(), (byte[])((byte[])s1Cache.get((Object)key)));
            HttpGet get = new HttpGet(restUrl + "/" + key);
            CloseableHttpResponse getResponse = restClient.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)getResponse.getStatusLine().getStatusCode());
            Assert.assertArrayEquals((byte[])"v1".getBytes(), (byte[])EntityUtils.toByteArray((HttpEntity)getResponse.getEntity()));
            Assert.assertArrayEquals((byte[])"v1".getBytes(), (byte[])this.readWithMemcachedAndDeserialize(key, memcachedClient));
            key = "2";
            HttpPut put = new HttpPut(restUrl + "/" + key);
            put.setEntity((HttpEntity)new ByteArrayEntity("<hey>ho</hey>".getBytes(), ContentType.APPLICATION_OCTET_STREAM));
            CloseableHttpResponse putResponse = restClient.execute((HttpUriRequest)put);
            Assert.assertEquals((long)200L, (long)putResponse.getStatusLine().getStatusCode());
            Assert.assertArrayEquals((byte[])"<hey>ho</hey>".getBytes(), (byte[])((byte[])s1Cache.get((Object)key)));
            Assert.assertArrayEquals((byte[])"<hey>ho</hey>".getBytes(), (byte[])this.readWithMemcachedAndDeserialize(key, memcachedClient));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
            if (memcachedClient != null) {
                memcachedClient.close();
            }
        }
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="standalone-fcs-local")})
    public void testFileCacheStoreConfig() throws Exception {
        this.doPutGetCheckPath(this.createRemotes("standalone-fcs-local", "local", DEFAULT_CACHE_NAME), "dc", -1.0);
        this.doPutGetCheckPath(this.createRemotes("standalone-fcs-local", "local", MEMCACHED_CACHE_NAME), "mc", -1.0);
        this.doPutGetCheckPath(this.createRemotes("standalone-fcs-local", "local", NAMED_CACHE_NAME), "nc", 2.1);
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="clustered-jdbc")})
    public void testJDBCCacheStoreConfig() throws Exception {
        int i;
        RemoteInfinispanMBeans sDefault = this.createRemotes("clustered-jdbc", "clustered", DEFAULT_CACHE_NAME);
        RemoteInfinispanMBeans sNamed = this.createRemotes("clustered-jdbc", "clustered", NAMED_CACHE_NAME);
        RemoteCache<Object, Object> sDefaultCache = this.createCache(sDefault);
        RemoteCache<Object, Object> sNamedCache = this.createCache(sNamed);
        sNamedCache.put((Object)"key", (Object)"value");
        sNamedCache.put((Object)"key2", (Object)"value2");
        Assert.assertEquals((Object)"value", (Object)sNamedCache.get((Object)"key"));
        Assert.assertEquals((Object)"value2", (Object)sNamedCache.get((Object)"key2"));
        for (i = 0; i < 1001; ++i) {
            sDefaultCache.put((Object)("k" + i), (Object)("v" + i));
        }
        for (i = 0; i < 1001; ++i) {
            Assert.assertEquals((Object)("v" + i), (Object)sDefaultCache.get((Object)("k" + i)));
        }
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="standalone-leveldb-cs-local")})
    public void testLevelDBCacheStoreConfig() throws Exception {
        this.doPutGetCheckPath(this.createRemotes("standalone-leveldb-cs-local", "local", DEFAULT_CACHE_NAME), "level-dcdefault", -1.0);
        this.doPutGetCheckPath(this.createRemotes("standalone-leveldb-cs-local", "local", MEMCACHED_CACHE_NAME), "level-mcmemcachedCache", -1.0);
        this.doPutGetCheckPath(this.createRemotes("standalone-leveldb-cs-local", "local", NAMED_CACHE_NAME), "leveldb-ncnamedCache", 2.1);
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="standalone-hotrod-multiple")})
    public void testHotrodMultipleConfig() throws Exception {
        int i;
        RemoteInfinispanMBeans s = this.createRemotes("standalone-hotrod-multiple", "local", DEFAULT_CACHE_NAME);
        RemoteCache<Object, Object> c1 = this.createCache(s, ITestUtils.createConfigBuilder(s.server.getHotrodEndpoint("external").getInetAddress().getHostName(), s.server.getHotrodEndpoint("external").getPort()));
        RemoteCache<Object, Object> c2 = this.createCache(s, ITestUtils.createConfigBuilder(s.server.getHotrodEndpoint("internal").getInetAddress().getHostName(), s.server.getHotrodEndpoint("internal").getPort()));
        Assert.assertEquals((long)0L, (long)s.cache.getNumberOfEntries());
        for (i = 0; i < 10; ++i) {
            c1.put((Object)("k" + i), (Object)("v" + i));
        }
        Assert.assertTrue((s.cache.getNumberOfEntries() <= 10L ? 1 : 0) != 0);
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)("v" + i), (Object)c2.get((Object)("k" + i)));
        }
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="standalone-rcs-local-2"), @RunningServer(name="standalone-rcs-local-1")})
    public void testRemoteCacheStoreConfig() throws Exception {
        RemoteInfinispanMBeans sRemoteStoreDefault = this.createRemotes("standalone-rcs-local-2", "local", DEFAULT_CACHE_NAME);
        RemoteInfinispanMBeans sRemoteStoreMemcached = this.createRemotes("standalone-rcs-local-2", "local", MEMCACHED_CACHE_NAME);
        RemoteInfinispanMBeans sRemoteStoreNamed = this.createRemotes("standalone-rcs-local-2", "local", NAMED_CACHE_NAME);
        RemoteInfinispanMBeans s1Default = this.createRemotes("standalone-rcs-local-1", "local", DEFAULT_CACHE_NAME);
        RemoteInfinispanMBeans s1Memcached = this.createRemotes("standalone-rcs-local-1", "local", MEMCACHED_CACHE_NAME);
        RemoteInfinispanMBeans s1Named = this.createRemotes("standalone-rcs-local-1", "local", NAMED_CACHE_NAME);
        this.doPutGetRemove(s1Default, sRemoteStoreDefault);
        this.doPutGetRemove(s1Memcached, sRemoteStoreMemcached);
        this.doPutGetWithExpiration(s1Named, sRemoteStoreNamed);
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="standalone-hotrod-ssl")})
    public void testSSLHotRodConfig() throws Exception {
        RemoteInfinispanMBeans s = this.createRemotes("standalone-hotrod-ssl", "local", DEFAULT_CACHE_NAME);
        RemoteCache<Object, Object> c = this.createCache(s, this.securityConfig("keystore_client.jks", "truststore_client.jks", s.server));
        this.doPutGet(s, c);
        try {
            this.doPutGet(s, this.createCache(s, this.securityConfig("keystore_server.jks", "truststore_client.jks", s.server)));
            Assert.fail();
        }
        catch (TransportException e) {
            // empty catch block
        }
        try {
            this.doPutGet(s, this.createCache(s, this.securityConfig("keystore_client.jks", "truststore_server.jks", s.server)));
            Assert.fail();
        }
        catch (TransportException transportException) {
            // empty catch block
        }
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="clustered-storage-only-1"), @RunningServer(name="clustered-storage-only-2")})
    public void testStorageOnlyConfig() throws Exception {
        RemoteInfinispanMBeans s1 = this.createRemotes("clustered-storage-only-1", "clustered", DEFAULT_CACHE_NAME);
        RemoteCache<Object, Object> s1Cache = this.createCache(s1);
        Assert.assertEquals((long)0L, (long)s1.cache.getNumberOfEntries());
        Assert.assertEquals((long)2L, (long)s1.manager.getClusterSize());
        s1Cache.put((Object)"k", (Object)"v");
        s1Cache.put((Object)"k2", (Object)"v2");
        Assert.assertEquals((Object)s1Cache.get((Object)"k"), (Object)"v");
        Assert.assertEquals((Object)s1Cache.get((Object)"k2"), (Object)"v2");
        Assert.assertEquals((long)2L, (long)s1.cache.getNumberOfEntries());
        s1Cache.put((Object)"k3", (Object)"v3");
        Assert.assertEquals((long)3L, (long)s1.cache.getNumberOfEntries());
        Assert.assertEquals((Object)"v", (Object)s1Cache.get((Object)"k"));
        Assert.assertEquals((Object)"v2", (Object)s1Cache.get((Object)"k2"));
        Assert.assertEquals((Object)"v3", (Object)s1Cache.get((Object)"k3"));
        try {
            ITestUtils.createCacheManager(this.serverManager.getServer("clustered-storage-only-2"));
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTopologyConfigMachineAttribute() throws Exception {
        try {
            this.startContainerWithTopology("clustered-topology-1", "node0", 0, "s1", "r1", "m1");
            this.startContainerWithTopology("clustered-topology-2", "node1", 100, "s1", "r1", "m1");
            this.startContainerWithTopology("clustered-topology-3", "node2", 200, "s1", "r1", "m2");
            this.verifyTopologyHinting("clustered-topology-1", "clustered-topology-2", "clustered-topology-3", "clustered", DEFAULT_CACHE_NAME);
        }
        catch (Throwable throwable) {
            ITestUtils.stopContainers(this.controller, "clustered-topology-1", "clustered-topology-2", "clustered-topology-3");
            throw throwable;
        }
        ITestUtils.stopContainers(this.controller, "clustered-topology-1", "clustered-topology-2", "clustered-topology-3");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTopologyConfigRackAttribute() throws Exception {
        try {
            this.startContainerWithTopology("clustered-topology-1", "node0", 0, "s1", "r1", "m1");
            this.startContainerWithTopology("clustered-topology-2", "node1", 100, "s1", "r1", "m2");
            this.startContainerWithTopology("clustered-topology-3", "node2", 200, "s1", "r2", "m3");
            this.verifyTopologyHinting("clustered-topology-1", "clustered-topology-2", "clustered-topology-3", "clustered", DEFAULT_CACHE_NAME);
        }
        catch (Throwable throwable) {
            ITestUtils.stopContainers(this.controller, "clustered-topology-1", "clustered-topology-2", "clustered-topology-3");
            throw throwable;
        }
        ITestUtils.stopContainers(this.controller, "clustered-topology-1", "clustered-topology-2", "clustered-topology-3");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTopologyConfigSiteAttribute() throws Exception {
        try {
            this.startContainerWithTopology("clustered-topology-1", "node0", 0, "s1", "r1", "m1");
            this.startContainerWithTopology("clustered-topology-2", "node1", 100, "s1", "r2", "m2");
            this.startContainerWithTopology("clustered-topology-3", "node2", 200, "s2", "r3", "m3");
            this.verifyTopologyHinting("clustered-topology-1", "clustered-topology-2", "clustered-topology-3", "clustered", DEFAULT_CACHE_NAME);
        }
        catch (Throwable throwable) {
            ITestUtils.stopContainers(this.controller, "clustered-topology-1", "clustered-topology-2", "clustered-topology-3");
            throw throwable;
        }
        ITestUtils.stopContainers(this.controller, "clustered-topology-1", "clustered-topology-2", "clustered-topology-3");
    }

    private void verifyTopologyHinting(String container1, String container2, String container3, String manager, String cache) {
        RemoteInfinispanMBeans s1 = this.createRemotes(container1, manager, cache);
        RemoteInfinispanMBeans s2 = this.createRemotes(container2, manager, cache);
        RemoteInfinispanMBeans s3 = this.createRemotes(container3, manager, cache);
        RemoteCache<Object, Object> s1Cache = this.createCache(s1);
        RemoteCache<Object, Object> s2Cache = this.createCache(s2);
        RemoteCache<Object, Object> s3Cache = this.createCache(s3);
        Assert.assertEquals((long)3L, (long)s1.manager.getClusterSize());
        Assert.assertEquals((long)3L, (long)s2.manager.getClusterSize());
        Assert.assertEquals((long)3L, (long)s3.manager.getClusterSize());
        int total_elements = 0;
        s1Cache.clear();
        s2Cache.clear();
        s3Cache.clear();
        long s0Entries = 0L;
        long s1Entries = 0L;
        long s2Entries = 0L;
        ArrayList<String> s1Bulk = new ArrayList<String>();
        ArrayList<String> s2Bulk = new ArrayList<String>();
        while (s0Entries == 0L || s1Entries == 0L || s2Entries == 0L || total_elements < 5) {
            s1Cache.put((Object)("machine" + total_elements), (Object)"machine");
            if (s1Entries + 1L == s2.cache.getNumberOfEntries()) {
                s1Bulk.add("machine" + total_elements);
            }
            if (s2Entries + 1L == s3.cache.getNumberOfEntries()) {
                s2Bulk.add("machine" + total_elements);
            }
            s1Entries = s2.cache.getNumberOfEntries();
            s2Entries = s3.cache.getNumberOfEntries();
            s0Entries = s1.cache.getNumberOfEntries();
            if (++total_elements <= 10) continue;
        }
        Assert.assertTrue((String)("Unexpected number of entries in server1: " + s0Entries), (s0Entries > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)("Unexpected number of entries in server2: " + s1Entries), (s1Entries > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)("Instead of " + total_elements * 2 + " total elements there were " + (s0Entries + s1Entries + s2Entries)), (s0Entries + s1Entries + s2Entries == (long)(total_elements * 2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Server 1 elements are not contained in server 2", (boolean)s2Bulk.containsAll(s1Bulk));
        for (String key : s1Bulk) {
            s2Cache.remove((Object)key);
        }
        s0Entries = s1.cache.getNumberOfEntries();
        s1Entries = s2.cache.getNumberOfEntries();
        s2Entries = s3.cache.getNumberOfEntries();
        Assert.assertEquals((String)("There were " + s1Entries + " left in the 2nd server"), (long)0L, (long)s1Entries);
        Assert.assertEquals((long)s0Entries, (long)s2Entries);
        Assert.assertNotEquals((long)s0Entries, (long)s1Entries);
        Assert.assertEquals((Object)s1Cache.getBulk(), (Object)s3Cache.getBulk());
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="clustered-two-nodes-1"), @RunningServer(name="clustered-two-nodes-2")})
    public void testTwoNodesConfig() throws Exception {
        final RemoteInfinispanMBeans s1 = this.createRemotes("clustered-two-nodes-1", "clustered", DEFAULT_CACHE_NAME);
        RemoteInfinispanMBeans s2 = this.createRemotes("clustered-two-nodes-2", "clustered", DEFAULT_CACHE_NAME);
        RemoteCache<Object, Object> s1Cache = this.createCache(s1);
        RemoteCache<Object, Object> s2Cache = this.createCache(s2);
        this.addServer(s1.server);
        this.addServer(s2.server);
        this.setUpREST(s1.server, s2.server);
        Assert.assertEquals((long)0L, (long)s1.cache.getNumberOfEntries());
        Assert.assertEquals((long)0L, (long)s2.cache.getNumberOfEntries());
        ITestUtils.eventually(new ITestUtils.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return s1.manager.getClusterSize() == 2;
            }
        }, 30000L, 300);
        Assert.assertEquals((long)2L, (long)s1.manager.getClusterSize());
        Assert.assertEquals((long)2L, (long)s2.manager.getClusterSize());
        s1Cache.put((Object)"k", (Object)"v");
        s1Cache.put((Object)"k2", (Object)"v2");
        Assert.assertEquals((Object)s1Cache.get((Object)"k"), (Object)"v");
        Assert.assertEquals((Object)s1Cache.get((Object)"k2"), (Object)"v2");
        Assert.assertEquals((long)2L, (long)s1.cache.getNumberOfEntries());
        s2Cache.put((Object)"k3", (Object)"v3");
        Assert.assertEquals((long)3L, (long)s2.cache.getNumberOfEntries());
        Assert.assertEquals((Object)"v", (Object)s1Cache.get((Object)"k"));
        Assert.assertEquals((Object)"v", (Object)s2Cache.get((Object)"k"));
        Assert.assertEquals((Object)"v2", (Object)s1Cache.get((Object)"k2"));
        Assert.assertEquals((Object)"v2", (Object)s2Cache.get((Object)"k2"));
        Assert.assertEquals((Object)"v3", (Object)s1Cache.get((Object)"k3"));
        Assert.assertEquals((Object)"v3", (Object)s2Cache.get((Object)"k3"));
        this.setUpREST(s1.server, s2.server);
        RESTHelper.put(RESTHelper.fullPathKey(0, "a"), "data", "text/plain");
        RESTHelper.get(RESTHelper.fullPathKey(1, "a"), "data");
        this.setUpREST(s1.server, s2.server);
        RESTHelper.post(RESTHelper.fullPathKey(0, "a"), "data", "text/plain");
        RESTHelper.get(RESTHelper.fullPathKey(1, "a"), "data");
        this.setUpREST(s1.server, s2.server);
        RESTHelper.post(RESTHelper.fullPathKey(0, "a"), "data", "text/plain");
        RESTHelper.get(RESTHelper.fullPathKey(1, "a"), "data");
        RESTHelper.delete(RESTHelper.fullPathKey(0, "a"));
        RESTHelper.head(RESTHelper.fullPathKey(1, "a"), 404);
        this.setUpREST(s1.server, s2.server);
        RESTHelper.post(RESTHelper.fullPathKey(0, "a"), "data", "text/plain");
        RESTHelper.post(RESTHelper.fullPathKey(0, "b"), "data", "text/plain");
        RESTHelper.head(RESTHelper.fullPathKey(0, "a"));
        RESTHelper.head(RESTHelper.fullPathKey(0, "b"));
        RESTHelper.delete(RESTHelper.fullPathKey(0, null));
        RESTHelper.head(RESTHelper.fullPathKey(1, "a"), 404);
        RESTHelper.head(RESTHelper.fullPathKey(1, "b"), 404);
        this.setUpREST(s1.server, s2.server);
        RESTHelper.post(RESTHelper.fullPathKey(0, "a"), "data", "application/text", 200, "Content-Type", "application/text", "timeToLiveSeconds", "2");
        RESTHelper.head(RESTHelper.fullPathKey(1, "a"));
        ITestUtils.sleepForSecs(2.1);
        RESTHelper.head(RESTHelper.fullPathKey(1, "a"), 404);
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="clustered-xsite-1"), @RunningServer(name="clustered-xsite-2"), @RunningServer(name="clustered-xsite-3")})
    public void testXsiteConfig() throws Exception {
        RemoteInfinispanMBeans s1 = this.createRemotes("clustered-xsite-1", "clustered", DEFAULT_CACHE_NAME);
        RemoteInfinispanMBeans s2 = this.createRemotes("clustered-xsite-2", "clustered", DEFAULT_CACHE_NAME);
        RemoteInfinispanMBeans s3 = this.createRemotes("clustered-xsite-3", "clustered", DEFAULT_CACHE_NAME);
        RemoteCache<Object, Object> s1Cache = this.createCache(s1);
        RemoteCache<Object, Object> s2Cache = this.createCache(s2);
        RemoteCache<Object, Object> s3Cache = this.createCache(s3);
        Assert.assertEquals((long)0L, (long)s1.cache.getNumberOfEntries());
        Assert.assertEquals((long)0L, (long)s2.cache.getNumberOfEntries());
        Assert.assertEquals((long)2L, (long)s1.manager.getClusterSize());
        Assert.assertEquals((long)2L, (long)s2.manager.getClusterSize());
        Assert.assertEquals((long)1L, (long)s3.manager.getClusterSize());
        s1Cache.put((Object)"k1", (Object)"v1");
        s1Cache.put((Object)"k2", (Object)"v2");
        Assert.assertEquals((long)2L, (long)s1.cache.getNumberOfEntries());
        Assert.assertEquals((long)2L, (long)s2.cache.getNumberOfEntries());
        Assert.assertEquals((long)2L, (long)s3.cache.getNumberOfEntries());
        Assert.assertEquals((Object)s1Cache.get((Object)"k1"), (Object)"v1");
        Assert.assertEquals((Object)s2Cache.get((Object)"k1"), (Object)"v1");
        Assert.assertEquals((Object)s3Cache.get((Object)"k1"), (Object)"v1");
        Assert.assertEquals((Object)s1Cache.get((Object)"k2"), (Object)"v2");
        Assert.assertEquals((Object)s2Cache.get((Object)"k2"), (Object)"v2");
        Assert.assertEquals((Object)s3Cache.get((Object)"k2"), (Object)"v2");
    }

    private void setUpREST(RemoteInfinispanServer server1, RemoteInfinispanServer server2) throws Exception {
        RESTHelper.delete(RESTHelper.fullPathKey("a"));
        RESTHelper.delete(RESTHelper.fullPathKey("b"));
        RESTHelper.delete(RESTHelper.fullPathKey("c"));
        RESTHelper.delete(RESTHelper.fullPathKey(NAMED_CACHE_NAME, "a"));
        RESTHelper.head(RESTHelper.fullPathKey("a"), 404);
        RESTHelper.head(RESTHelper.fullPathKey("b"), 404);
        RESTHelper.head(RESTHelper.fullPathKey("c"), 404);
        RESTHelper.head(RESTHelper.fullPathKey(NAMED_CACHE_NAME, "a"), 404);
    }

    private void addServer(RemoteInfinispanServer server) {
        RESTEndpoint endpoint = server.getRESTEndpoint();
        String inetHostName = endpoint.getInetAddress().getHostName();
        String realHostName = endpoint.getInetAddress() instanceof Inet6Address ? "[" + inetHostName + "]" : inetHostName;
        RESTHelper.addServer(realHostName, endpoint.getContextPath());
    }

    private ConfigurationBuilder securityConfig(String keystoreName, String truststoreName, RemoteInfinispanServer server) {
        ConfigurationBuilder builder = ITestUtils.createConfigBuilder(server.getHotrodEndpoint().getInetAddress().getHostName(), server.getHotrodEndpoint().getPort());
        builder.ssl().enable().keyStoreFileName(ITestUtils.SERVER_CONFIG_DIR + File.separator + keystoreName).keyStorePassword("secret".toCharArray()).trustStoreFileName(ITestUtils.SERVER_CONFIG_DIR + File.separator + truststoreName).trustStorePassword("secret".toCharArray());
        return builder;
    }

    private void doPutGetRemove(final RemoteInfinispanMBeans sMain, final RemoteInfinispanMBeans sRemoteStore) {
        int i;
        Assert.assertEquals((long)0L, (long)sMain.cache.getNumberOfEntries());
        Assert.assertEquals((long)0L, (long)sRemoteStore.cache.getNumberOfEntries());
        RemoteCache<Object, Object> sMainCache = this.createCache(sMain);
        RemoteCache<Object, Object> sRemoteStoreCache = this.createCache(sRemoteStore);
        for (i = 0; i < 1100; ++i) {
            sMainCache.put((Object)("key" + i), (Object)("value" + i));
        }
        Assert.assertTrue((sMain.cache.getNumberOfEntries() <= 1000L ? 1 : 0) != 0);
        ITestUtils.eventually(new ITestUtils.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                log.debug((Object)("Num entries: Main cache: " + sMain.cache.getNumberOfEntries() + " Remote store: " + sRemoteStore.cache.getNumberOfEntries() + " Total: " + (sMain.cache.getNumberOfEntries() + sRemoteStore.cache.getNumberOfEntries())));
                return sMain.cache.getNumberOfEntries() + sRemoteStore.cache.getNumberOfEntries() == 1100L;
            }
        }, 10000L);
        for (i = 0; i < 1100; ++i) {
            Assert.assertNotNull((Object)sMainCache.get((Object)("key" + i)));
            sMainCache.remove((Object)("key" + i));
            Assert.assertNull((Object)sMainCache.get((Object)("key" + i)));
        }
        Assert.assertEquals((long)0L, (long)sMain.cache.getNumberOfEntries());
        Assert.assertEquals((long)0L, (long)sRemoteStore.cache.getNumberOfEntries());
        sMainCache.clear();
        sRemoteStoreCache.clear();
    }

    private void doPutGetWithExpiration(RemoteInfinispanMBeans s1, RemoteInfinispanMBeans s2) throws Exception {
        Assert.assertEquals((long)0L, (long)s2.cache.getNumberOfEntries());
        RemoteCache<Object, Object> s1Cache = this.createCache(s1);
        this.doPutGet(s1, s1Cache);
        Assert.assertEquals((long)10L, (long)s2.cache.getNumberOfEntries());
        ITestUtils.sleepForSecs(2.1);
        for (int i = 0; i < 10; ++i) {
            Assert.assertNull((Object)s1Cache.get((Object)("key" + i)));
        }
    }

    private void doPutGet(RemoteInfinispanMBeans s, RemoteCache<Object, Object> c) {
        int i;
        Assert.assertEquals((long)0L, (long)s.cache.getNumberOfEntries());
        for (i = 0; i < 10; ++i) {
            c.put((Object)("k" + i), (Object)("v" + i));
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)("v" + i), (Object)c.get((Object)("k" + i)));
        }
        Assert.assertEquals((long)10L, (long)s.cache.getNumberOfEntries());
    }

    private void doPutGetCheckPath(RemoteInfinispanMBeans s, String filePath, double sleepTime) throws Exception {
        RemoteCache<Object, Object> sCache = this.createCache(s);
        this.doPutGet(s, sCache);
        if (sleepTime >= 0.0) {
            ITestUtils.sleepForSecs(sleepTime);
            for (int i = 0; i < 10; ++i) {
                Assert.assertNull((Object)sCache.get((Object)("k" + i)));
            }
        }
        File f = new File(ITestUtils.SERVER_DATA_DIR, filePath);
        Assert.assertTrue((boolean)f.isDirectory());
    }

    private byte[] readWithMemcachedAndDeserialize(String key, MemcachedClient memcachedClient) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(memcachedClient.getBytes(key));
        ObjectInputStream ois = new ObjectInputStream(bais);
        return (byte[])ois.readObject();
    }

    protected RemoteCache<Object, Object> createCache(RemoteInfinispanMBeans cacheBeans, ConfigurationBuilder configBuilder) {
        return this.rcmFactory.createCache(configBuilder, cacheBeans.cacheName);
    }

    protected RemoteCache<Object, Object> createCache(RemoteInfinispanMBeans cacheBeans) {
        return this.rcmFactory.createCache(cacheBeans);
    }

    protected RemoteCacheManager createCacheManager(RemoteInfinispanMBeans cacheBeans) {
        return this.rcmFactory.createManager(cacheBeans);
    }

    protected RemoteInfinispanMBeans createRemotes(String serverName, String managerName, String cacheName) {
        return RemoteInfinispanMBeans.create(this.serverManager, serverName, cacheName, managerName);
    }

    private void startContainerWithTopology(String containerName, String nodeName, int portOffset, String site, String rack, String machine) {
        this.controller.start(containerName, new Config().add("javaVmArguments", System.getProperty("server.jvm.args") + " -Djboss.node.name=" + nodeName + " -Djboss.socket.binding.port-offset=" + portOffset + " -Djboss.jgroups.topology.site=" + site + " -Djboss.jgroups.topology.rack=" + rack + " -Djboss.jgroups.topology.machine=" + machine).map());
    }
}

