/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.cs.jdbc;

import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.server.test.client.memcached.MemcachedClient;
import org.infinispan.server.test.util.ITestUtils;
import org.infinispan.server.test.util.RemoteCacheManagerFactory;
import org.infinispan.server.test.util.RemoteInfinispanMBeans;
import org.infinispan.server.test.util.jdbc.DBServer;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public abstract class AbstractJdbcStoreMultinodeIT {
    protected final String CONTAINER1 = "jdbc-cachestore-1";
    protected final String CONTAINER2 = "jdbc-cachestore-2";
    private final String ID_COLUMN_NAME = "id";
    private final String DATA_COLUMN_NAME = "datum";
    protected static DBServer dbServer1 = DBServer.create();
    protected static DBServer dbServer2 = DBServer.create();
    private static RemoteCacheManagerFactory rcmFactory;
    protected RemoteCache cache;
    protected RemoteInfinispanMBeans mbeans1;
    protected RemoteInfinispanMBeans mbeans2;
    protected MemcachedClient mc1;
    protected MemcachedClient mc2;
    @ArquillianResource
    protected ContainerController controller;
    @InfinispanResource(value="jdbc-cachestore-1")
    protected RemoteInfinispanServer server1;
    @InfinispanResource(value="jdbc-cachestore-2")
    protected RemoteInfinispanServer server2;

    @BeforeClass
    public static void startup() {
        rcmFactory = new RemoteCacheManagerFactory();
    }

    @AfterClass
    public static void cleanup() {
        try {
            if (AbstractJdbcStoreMultinodeIT.dbServer1.bucketTable != null && AbstractJdbcStoreMultinodeIT.dbServer1.bucketTable.getConnectionUrl().contains("db2")) {
                AbstractJdbcStoreMultinodeIT.dbServer1.bucketTable.dropTable();
                AbstractJdbcStoreMultinodeIT.dbServer2.bucketTable.dropTable();
            }
            if (AbstractJdbcStoreMultinodeIT.dbServer1.stringTable != null && AbstractJdbcStoreMultinodeIT.dbServer1.stringTable.getConnectionUrl().contains("db2")) {
                AbstractJdbcStoreMultinodeIT.dbServer1.stringTable.dropTable();
                AbstractJdbcStoreMultinodeIT.dbServer2.stringTable.dropTable();
            }
        }
        catch (Exception e) {
            System.out.println("Couldn't drop the tables: ");
            e.printStackTrace();
        }
        if (rcmFactory != null) {
            rcmFactory.stopManagers();
        }
        rcmFactory = null;
    }

    @Before
    public void setUp() throws Exception {
        String driver = System.getProperty("driver.class");
        this.dBServers();
        if (AbstractJdbcStoreMultinodeIT.dbServer1.bucketTableName != null) {
            AbstractJdbcStoreMultinodeIT.dbServer1.bucketTable = new DBServer.TableManipulation(driver, dbServer1, AbstractJdbcStoreMultinodeIT.dbServer1.bucketTableName, "id", "datum");
        }
        if (AbstractJdbcStoreMultinodeIT.dbServer1.stringTableName != null) {
            AbstractJdbcStoreMultinodeIT.dbServer1.stringTable = new DBServer.TableManipulation(driver, dbServer1, AbstractJdbcStoreMultinodeIT.dbServer1.stringTableName, "id", "datum");
        }
        if (AbstractJdbcStoreMultinodeIT.dbServer2.bucketTableName != null) {
            AbstractJdbcStoreMultinodeIT.dbServer2.bucketTable = new DBServer.TableManipulation(driver, dbServer2, AbstractJdbcStoreMultinodeIT.dbServer2.bucketTableName, "id", "datum");
        }
        if (AbstractJdbcStoreMultinodeIT.dbServer2.stringTableName != null) {
            AbstractJdbcStoreMultinodeIT.dbServer2.stringTable = new DBServer.TableManipulation(driver, dbServer2, AbstractJdbcStoreMultinodeIT.dbServer2.stringTableName, "id", "datum");
        }
        this.mbeans1 = ITestUtils.createMBeans(this.server1, "jdbc-cachestore-1", this.cacheName(), this.managerName());
        this.mbeans2 = ITestUtils.createMBeans(this.server2, "jdbc-cachestore-2", this.cacheName(), this.managerName());
    }

    protected RemoteCache<Object, Object> createCache(RemoteInfinispanMBeans mbeans) {
        return rcmFactory.createCache(mbeans);
    }

    protected abstract void dBServers();

    protected abstract String managerName();

    protected abstract String cacheName();
}

