/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.cs.jdbc.binary;

import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.server.test.category.CacheStore;
import org.infinispan.server.test.cs.jdbc.AbstractJdbcStoreSinglenodeIT;
import org.infinispan.server.test.util.ITestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={CacheStore.class})
public class BinaryStorePassivationEnabledSinglenodeIT
extends AbstractJdbcStoreSinglenodeIT {
    private final String CONFIG_BINARY_WITH_PASSIVATION = "testsuite/jdbc-binary-with-passivation.xml";
    private final String TABLE_NAME_PREFIX = "BINARY_WITH_PASSIVATION";
    private final String CACHE_NAME = "default";
    private final String MANAGER_NAME = "local";

    @Test
    @WithRunningServer(value={@RunningServer(name="jdbc-cachestore-1", config="testsuite/jdbc-binary-with-passivation.xml")})
    public void testPassivateAfterEviction() throws Exception {
        String key1 = "key1";
        String key2 = "myBestPersonalKeyWhichHasNeverBeenBetter";
        String key3 = "key3";
        this.cache = this.createCache(this.mbeans);
        this.assertCleanCacheAndStoreHotrod();
        this.cache.put((Object)key1, (Object)"v1");
        this.cache.put((Object)key2, (Object)"v2");
        Assert.assertTrue((!BinaryStorePassivationEnabledSinglenodeIT.dbServer.bucketTable.exists() || BinaryStorePassivationEnabledSinglenodeIT.dbServer.bucketTable.getAllRows().isEmpty() ? 1 : 0) != 0);
        this.cache.put((Object)key3, (Object)"v3");
        Assert.assertTrue((2L >= this.server.getCacheManager("local").getCache("default").getNumberOfEntries() ? 1 : 0) != 0);
        byte[] k1Stored = ITestUtils.getRealKeyStored(key1, this.cache);
        BinaryStorePassivationEnabledSinglenodeIT.dbServer.bucketTable.waitForTableCreation();
        Assert.assertTrue((!BinaryStorePassivationEnabledSinglenodeIT.dbServer.bucketTable.getAllRows().isEmpty() ? 1 : 0) != 0);
        Assert.assertNotNull((Object)BinaryStorePassivationEnabledSinglenodeIT.dbServer.bucketTable.getBucketByKey(k1Stored));
        Assert.assertEquals((Object)"v1", (Object)this.cache.get((Object)key1));
        Assert.assertTrue((2L >= this.server.getCacheManager("local").getCache("default").getNumberOfEntries() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"v2", (Object)this.cache.get((Object)key2));
        Assert.assertEquals((Object)"v3", (Object)this.cache.get((Object)key3));
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="jdbc-cachestore-1", config="testsuite/jdbc-binary-with-passivation.xml")})
    public void testSoftRestartWithoutPreload() throws Exception {
        String key1 = "key1";
        String key2 = "anotherExtraUniqueKey";
        String key3 = "key3";
        this.cache = this.createCache(this.mbeans);
        this.assertCleanCacheAndStoreHotrod();
        this.cache.put((Object)key1, (Object)"v1");
        this.cache.put((Object)key2, (Object)"v2");
        Assert.assertTrue((!BinaryStorePassivationEnabledSinglenodeIT.dbServer.bucketTable.exists() || BinaryStorePassivationEnabledSinglenodeIT.dbServer.bucketTable.getAllRows().isEmpty() ? 1 : 0) != 0);
        this.cache.put((Object)key3, (Object)"v3");
        Assert.assertTrue((2L >= this.server.getCacheManager("local").getCache("default").getNumberOfEntries() ? 1 : 0) != 0);
        byte[] k1Stored = ITestUtils.getRealKeyStored(key1, this.cache);
        Assert.assertTrue((!BinaryStorePassivationEnabledSinglenodeIT.dbServer.bucketTable.getAllRows().isEmpty() ? 1 : 0) != 0);
        Assert.assertNotNull((Object)BinaryStorePassivationEnabledSinglenodeIT.dbServer.bucketTable.getBucketByKey(k1Stored));
        this.controller.stop("jdbc-cachestore-1");
        this.controller.start("jdbc-cachestore-1");
        this.cache = this.createCache(this.mbeans);
        Assert.assertEquals((long)0L, (long)this.server.getCacheManager("local").getCache("default").getNumberOfEntries());
        Assert.assertTrue((BinaryStorePassivationEnabledSinglenodeIT.dbServer.bucketTable.getAllRows().size() >= 2 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)BinaryStorePassivationEnabledSinglenodeIT.dbServer.bucketTable.getBucketByKey(k1Stored));
        Assert.assertEquals((Object)"v1", (Object)this.cache.get((Object)key1));
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="jdbc-cachestore-1", config="testsuite/jdbc-binary-with-passivation.xml")})
    public void testFailoverWithoutPreload() throws Exception {
        String key1 = "key1";
        String key2 = "anotherExtraUniqueKey";
        String key3 = "key3";
        this.cache = this.createCache(this.mbeans);
        this.assertCleanCacheAndStoreHotrod();
        this.cache.put((Object)key1, (Object)"v1");
        this.cache.put((Object)key2, (Object)"v2");
        Assert.assertTrue((!BinaryStorePassivationEnabledSinglenodeIT.dbServer.bucketTable.exists() || BinaryStorePassivationEnabledSinglenodeIT.dbServer.bucketTable.getAllRows().isEmpty() ? 1 : 0) != 0);
        this.cache.put((Object)key3, (Object)"v3");
        Assert.assertTrue((2L >= this.server.getCacheManager("local").getCache("default").getNumberOfEntries() ? 1 : 0) != 0);
        byte[] k1Stored = ITestUtils.getRealKeyStored(key1, this.cache);
        Assert.assertTrue((!BinaryStorePassivationEnabledSinglenodeIT.dbServer.bucketTable.getAllRows().isEmpty() ? 1 : 0) != 0);
        Assert.assertNotNull((Object)BinaryStorePassivationEnabledSinglenodeIT.dbServer.bucketTable.getBucketByKey(k1Stored));
        this.controller.kill("jdbc-cachestore-1");
        this.controller.start("jdbc-cachestore-1");
        this.cache = this.createCache(this.mbeans);
        Assert.assertEquals((long)0L, (long)this.server.getCacheManager("local").getCache("default").getNumberOfEntries());
        Assert.assertTrue((!BinaryStorePassivationEnabledSinglenodeIT.dbServer.bucketTable.getAllRows().isEmpty() ? 1 : 0) != 0);
        Assert.assertNotNull((Object)BinaryStorePassivationEnabledSinglenodeIT.dbServer.bucketTable.getBucketByKey(k1Stored));
        Assert.assertEquals((Object)"v1", (Object)this.cache.get((Object)key1));
    }

    protected void assertCleanCacheAndStoreHotrod() throws Exception {
        this.cache.clear();
        if (BinaryStorePassivationEnabledSinglenodeIT.dbServer.bucketTable.exists() && !BinaryStorePassivationEnabledSinglenodeIT.dbServer.bucketTable.getAllRows().isEmpty()) {
            BinaryStorePassivationEnabledSinglenodeIT.dbServer.bucketTable.deleteAllRows();
            ITestUtils.eventually(new ITestUtils.Condition(){

                @Override
                public boolean isSatisfied() throws Exception {
                    return dbServer.bucketTable.getAllRows().isEmpty();
                }
            }, 10000L);
        }
    }

    @Override
    public String bucketTableName() {
        return "BINARY_WITH_PASSIVATION_default";
    }

    @Override
    protected String stringTableName() {
        return null;
    }

    @Override
    protected String managerName() {
        return "local";
    }

    @Override
    protected String cacheName() {
        return "default";
    }
}

