/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.cs.jdbc.mixed;

import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.server.test.category.CacheStore;
import org.infinispan.server.test.cs.jdbc.AbstractJdbcStoreSinglenodeIT;
import org.infinispan.server.test.util.ITestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={CacheStore.class})
public class MixedStorePassivationDisabledSinglenodeIT
extends AbstractJdbcStoreSinglenodeIT {
    private final String CONFIG_MIXED_NO_PASSIVATION = "testsuite/jdbc-mixed-no-passivation.xml";
    private final String STRING_TABLE_NAME_PREFIX = "MIXED_NO_PASSIVATION_STR";
    private final String BUCKET_TABLE_NAME_PREFIX = "MIXED_NO_PASSIVATION_BKT";
    private final String CACHE_NAME = "memcachedCache";
    private final String MANAGER_NAME = "local";

    @Test
    @WithRunningServer(value={@RunningServer(name="jdbc-cachestore-1", config="testsuite/jdbc-mixed-no-passivation.xml")})
    public void testFailoverWithPassivationDisabled() throws Exception {
        this.mc = ITestUtils.createMemcachedClient(this.server);
        this.assertCleanCacheAndStore();
        this.mc.set("k1", "v1");
        this.mc.set("k2", "v2");
        MixedStorePassivationDisabledSinglenodeIT.dbServer.stringTable.waitForTableCreation();
        System.out.println("Available tables: " + MixedStorePassivationDisabledSinglenodeIT.dbServer.stringTable.getTableNames());
        Assert.assertEquals((long)2L, (long)MixedStorePassivationDisabledSinglenodeIT.dbServer.stringTable.getAllRows().size());
        Assert.assertTrue((!MixedStorePassivationDisabledSinglenodeIT.dbServer.bucketTable.exists() || MixedStorePassivationDisabledSinglenodeIT.dbServer.bucketTable.getAllRows().isEmpty() ? 1 : 0) != 0);
        this.controller.stop("jdbc-cachestore-1");
        this.controller.start("jdbc-cachestore-1");
        this.mc = ITestUtils.createMemcachedClient(this.server);
        Assert.assertEquals((Object)"v1", (Object)this.mc.get("k1"));
        Assert.assertEquals((Object)"v2", (Object)this.mc.get("k2"));
        this.mc.delete("k2");
        Assert.assertNull((Object)MixedStorePassivationDisabledSinglenodeIT.dbServer.stringTable.getValueByKey("k2"));
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="jdbc-cachestore-1", config="testsuite/jdbc-mixed-no-passivation.xml")})
    public void testPreloadWithoutPurge() throws Exception {
        this.mc = ITestUtils.createMemcachedClient(this.server);
        this.assertCleanCacheAndStore();
        this.mc.set("k1", "v1");
        this.mc.set("k2", "v2");
        MixedStorePassivationDisabledSinglenodeIT.dbServer.stringTable.waitForTableCreation();
        System.out.println("Available tables: " + MixedStorePassivationDisabledSinglenodeIT.dbServer.stringTable.getTableNames());
        Assert.assertEquals((long)2L, (long)MixedStorePassivationDisabledSinglenodeIT.dbServer.stringTable.getAllRows().size());
        Assert.assertTrue((!MixedStorePassivationDisabledSinglenodeIT.dbServer.bucketTable.exists() || MixedStorePassivationDisabledSinglenodeIT.dbServer.bucketTable.getAllRows().isEmpty() ? 1 : 0) != 0);
        this.controller.stop("jdbc-cachestore-1");
        this.controller.start("jdbc-cachestore-1");
        ITestUtils.eventually(new ITestUtils.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return 2L == MixedStorePassivationDisabledSinglenodeIT.this.server.getCacheManager("local").getCache("memcachedCache").getNumberOfEntries();
            }
        }, 10000L);
        Assert.assertEquals((long)2L, (long)MixedStorePassivationDisabledSinglenodeIT.dbServer.stringTable.getAllRows().size());
    }

    private void assertCleanCacheAndStore() throws Exception {
        this.mc.delete("k1");
        this.mc.delete("k2");
        if (MixedStorePassivationDisabledSinglenodeIT.dbServer.stringTable.exists() && !MixedStorePassivationDisabledSinglenodeIT.dbServer.stringTable.getAllRows().isEmpty()) {
            MixedStorePassivationDisabledSinglenodeIT.dbServer.stringTable.deleteAllRows();
            ITestUtils.eventually(new ITestUtils.Condition(){

                @Override
                public boolean isSatisfied() throws Exception {
                    return dbServer.stringTable.getAllRows().isEmpty();
                }
            }, 10000L);
        }
    }

    @Override
    protected String bucketTableName() {
        return "MIXED_NO_PASSIVATION_BKT_memcachedCache";
    }

    @Override
    protected String stringTableName() {
        return "MIXED_NO_PASSIVATION_STR_memcachedCache";
    }

    @Override
    protected String managerName() {
        return "local";
    }

    @Override
    protected String cacheName() {
        return "memcachedCache";
    }
}

