/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.cs.jdbc.mixed;

import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.server.test.category.CacheStore;
import org.infinispan.server.test.cs.jdbc.AbstractJdbcStoreSinglenodeIT;
import org.infinispan.server.test.util.ITestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={CacheStore.class})
public class MixedStorePassivationEnabledSinglenodeIT
extends AbstractJdbcStoreSinglenodeIT {
    private final String CONFIG_MIXED_WITH_PASSIVATION = "testsuite/jdbc-mixed-with-passivation.xml";
    private final String STRING_TABLE_NAME_PREFIX = "MIXED_WITH_PASSIVATION_STR";
    private final String BUCKET_TABLE_NAME_PREFIX = "MIXED_WITH_PASSIVATION_BKT";
    private final String CACHE_NAME = "memcachedCache";
    private final String MANAGER_NAME = "local";

    @Test
    @WithRunningServer(value={@RunningServer(name="jdbc-cachestore-1", config="testsuite/jdbc-mixed-with-passivation.xml")})
    public void testPassivateAfterEviction() throws Exception {
        this.mc = ITestUtils.createMemcachedClient(this.server);
        this.assertCleanCacheAndStore();
        this.mc.set("k1", "v1");
        this.mc.set("k2", "v2");
        System.out.println("Available tables: " + MixedStorePassivationEnabledSinglenodeIT.dbServer.stringTable.getTableNames());
        Assert.assertTrue((!MixedStorePassivationEnabledSinglenodeIT.dbServer.stringTable.exists() || MixedStorePassivationEnabledSinglenodeIT.dbServer.stringTable.getAllRows().isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((!MixedStorePassivationEnabledSinglenodeIT.dbServer.bucketTable.exists() || MixedStorePassivationEnabledSinglenodeIT.dbServer.bucketTable.getAllRows().isEmpty() ? 1 : 0) != 0);
        this.mc.set("k3", "v3");
        Assert.assertEquals((long)2L, (long)this.server.getCacheManager("local").getCache("memcachedCache").getNumberOfEntries());
        Assert.assertEquals((long)1L, (long)MixedStorePassivationEnabledSinglenodeIT.dbServer.stringTable.getAllRows().size());
        Assert.assertTrue((!MixedStorePassivationEnabledSinglenodeIT.dbServer.bucketTable.exists() || MixedStorePassivationEnabledSinglenodeIT.dbServer.bucketTable.getAllRows().isEmpty() ? 1 : 0) != 0);
        this.mc.get("k1");
        Assert.assertEquals((long)2L, (long)this.server.getCacheManager("local").getCache("memcachedCache").getNumberOfEntries());
        Assert.assertNotNull((Object)MixedStorePassivationEnabledSinglenodeIT.dbServer.stringTable.getValueByKey("k2"));
        Assert.assertEquals((long)1L, (long)MixedStorePassivationEnabledSinglenodeIT.dbServer.stringTable.getAllRows().size());
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="jdbc-cachestore-1", config="testsuite/jdbc-mixed-with-passivation.xml")})
    public void testFailoverWithoutPreload() throws Exception {
        this.mc = ITestUtils.createMemcachedClient(this.server);
        this.assertCleanCacheAndStore();
        this.mc.set("k1", "v1");
        this.mc.set("k2", "v2");
        System.out.println("Available tables: " + MixedStorePassivationEnabledSinglenodeIT.dbServer.stringTable.getTableNames());
        Assert.assertTrue((!MixedStorePassivationEnabledSinglenodeIT.dbServer.stringTable.exists() || MixedStorePassivationEnabledSinglenodeIT.dbServer.stringTable.getAllRows().isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((!MixedStorePassivationEnabledSinglenodeIT.dbServer.bucketTable.exists() || MixedStorePassivationEnabledSinglenodeIT.dbServer.bucketTable.getAllRows().isEmpty() ? 1 : 0) != 0);
        this.mc.set("k3", "v3");
        MixedStorePassivationEnabledSinglenodeIT.dbServer.stringTable.waitForTableCreation();
        Assert.assertTrue((0 < MixedStorePassivationEnabledSinglenodeIT.dbServer.stringTable.getAllRows().size() ? 1 : 0) != 0);
        Assert.assertTrue((!MixedStorePassivationEnabledSinglenodeIT.dbServer.bucketTable.exists() || MixedStorePassivationEnabledSinglenodeIT.dbServer.bucketTable.getAllRows().isEmpty() ? 1 : 0) != 0);
        this.controller.stop("jdbc-cachestore-1");
        this.controller.start("jdbc-cachestore-1");
        this.mc = ITestUtils.createMemcachedClient(this.server);
        Assert.assertEquals((long)0L, (long)this.server.getCacheManager("local").getCache("memcachedCache").getNumberOfEntries());
        Assert.assertEquals((long)3L, (long)MixedStorePassivationEnabledSinglenodeIT.dbServer.stringTable.getAllRows().size());
        Assert.assertTrue((boolean)MixedStorePassivationEnabledSinglenodeIT.dbServer.bucketTable.getAllRows().isEmpty());
        Assert.assertEquals((Object)"v1", (Object)this.mc.get("k1"));
    }

    private void assertCleanCacheAndStore() throws Exception {
        this.mc.delete("k1");
        this.mc.delete("k2");
        this.mc.delete("k3");
        if (MixedStorePassivationEnabledSinglenodeIT.dbServer.stringTable.exists() && !MixedStorePassivationEnabledSinglenodeIT.dbServer.stringTable.getAllRows().isEmpty()) {
            MixedStorePassivationEnabledSinglenodeIT.dbServer.stringTable.deleteAllRows();
            ITestUtils.eventually(new ITestUtils.Condition(){

                @Override
                public boolean isSatisfied() throws Exception {
                    return dbServer.stringTable.getAllRows().isEmpty();
                }
            }, 10000L);
        }
    }

    @Override
    protected String bucketTableName() {
        return "MIXED_WITH_PASSIVATION_BKT_memcachedCache";
    }

    @Override
    protected String stringTableName() {
        return "MIXED_WITH_PASSIVATION_STR_memcachedCache";
    }

    @Override
    protected String managerName() {
        return "local";
    }

    @Override
    protected String cacheName() {
        return "memcachedCache";
    }
}

