/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.jmx.management;

import java.io.IOException;
import java.util.List;
import javax.management.ObjectName;
import org.infinispan.Version;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.arquillian.utils.MBeanServerConnectionProvider;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.server.test.client.memcached.MemcachedClient;
import org.infinispan.server.test.util.ITestUtils;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@WithRunningServer(value={@RunningServer(name="jmx-management-1"), @RunningServer(name="jmx-management-2")})
public class JmxManagementIT {
    final String distCachePrefix = "jboss.infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=";
    final String memcachedCachePrefix = "jboss.infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=";
    final String distCacheMBean = "jboss.infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=Cache";
    final String distributionManagerMBean = "jboss.infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=DistributionManager";
    final String distributionStateTransferManagerMBean = "jboss.infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=StateTransferManager";
    final String lockManagerMBean = "jboss.infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=LockManager";
    final String rpcManagerMBean = "jboss.infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=RpcManager";
    final String distCacheStatisticsMBean = "jboss.infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=Statistics";
    final String memcachedCacheStatisticsMBean = "jboss.infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics";
    final String newExtraCacheMBean = "jboss.infinispan:type=Cache,name=\"extracache(local)\",manager=\"clustered\",component=Cache";
    final String managerPrefix = "jboss.infinispan:type=CacheManager,name=\"clustered\",component=";
    final String cacheManagerMBean = "jboss.infinispan:type=CacheManager,name=\"clustered\",component=CacheManager";
    final String hotRodServerMBean = "jboss.infinispan:type=Server,name=HotRod,component=Transport";
    final String memCachedServerMBean = "jboss.infinispan:type=Server,name=Memcached,component=Transport";
    final String protocolMBeanPrefix = "jgroups:type=protocol,cluster=\"default\",protocol=";
    @InfinispanResource(value="jmx-management-1")
    RemoteInfinispanServer server1;
    @InfinispanResource(value="jmx-management-2")
    RemoteInfinispanServer server2;
    MBeanServerConnectionProvider provider;
    MBeanServerConnectionProvider provider2;
    RemoteCacheManager manager;
    RemoteCache distCache;
    MemcachedClient mc;

    @Before
    public void setUp() throws IOException {
        this.provider = new MBeanServerConnectionProvider(this.server1.getHotrodEndpoint().getInetAddress().getHostName(), 9990);
        this.provider2 = new MBeanServerConnectionProvider(this.server2.getHotrodEndpoint().getInetAddress().getHostName(), 10090);
        if (this.manager == null) {
            Configuration conf = new ConfigurationBuilder().addServer().host(this.server1.getHotrodEndpoint().getInetAddress().getHostName()).port(this.server1.getHotrodEndpoint().getPort()).build();
            this.manager = new RemoteCacheManager(conf);
        }
        this.distCache = this.manager.getCache();
        this.mc = new MemcachedClient("UTF-8", this.server1.getMemcachedEndpoint().getInetAddress().getHostName(), this.server1.getMemcachedEndpoint().getPort(), 10000);
        this.assertDefaultCacheEmpty();
    }

    private void assertDefaultCacheEmpty() {
        while (this.server1.getCacheManager("clustered").getDefaultCache().getNumberOfEntries() != 0L || this.server2.getCacheManager("clustered").getDefaultCache().getNumberOfEntries() != 0L) {
            try {
                this.distCache.clear();
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Test
    public void testHotRodConnectionCount() throws Exception {
        int initialLocal = Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Server,name=HotRod,component=Transport", "numberOfLocalConnections"));
        int initialGlobal = Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Server,name=HotRod,component=Transport", "numberOfGlobalConnections"));
        Assert.assertEquals((String)"Number of global connections obtained from node1 and node2 is not the same", (long)initialGlobal, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider2, "jboss.infinispan:type=Server,name=HotRod,component=Transport", "numberOfGlobalConnections")));
        Configuration conf = new ConfigurationBuilder().addServer().host(this.server1.getHotrodEndpoint().getInetAddress().getHostName()).port(this.server1.getHotrodEndpoint().getPort()).build();
        RemoteCacheManager manager2 = new RemoteCacheManager(conf);
        manager2.getCache().put((Object)"key", (Object)"value");
        Assert.assertEquals((long)(initialLocal + 1), (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Server,name=HotRod,component=Transport", "numberOfLocalConnections")));
        Assert.assertEquals((long)(initialGlobal + 2), (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Server,name=HotRod,component=Transport", "numberOfGlobalConnections")));
        Assert.assertEquals((long)(initialGlobal + 2), (long)Integer.parseInt(ITestUtils.getAttribute(this.provider2, "jboss.infinispan:type=Server,name=HotRod,component=Transport", "numberOfGlobalConnections")));
    }

    @Test
    public void testMemCachedConnectionCount() throws Exception {
        int initialLocal = Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Server,name=Memcached,component=Transport", "numberOfLocalConnections"));
        int initialGlobal = Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Server,name=Memcached,component=Transport", "numberOfGlobalConnections"));
        Assert.assertEquals((String)"Number of global connections obtained from node1 and node2 is not the same", (long)initialGlobal, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider2, "jboss.infinispan:type=Server,name=Memcached,component=Transport", "numberOfGlobalConnections")));
        MemcachedClient mc2 = new MemcachedClient("UTF-8", this.server1.getMemcachedEndpoint().getInetAddress().getHostName(), this.server1.getMemcachedEndpoint().getPort(), 10000);
        mc2.set("key", "value");
        Assert.assertEquals((long)(initialLocal + 1), (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Server,name=Memcached,component=Transport", "numberOfLocalConnections")));
        Assert.assertEquals((long)(initialGlobal + 1), (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Server,name=Memcached,component=Transport", "numberOfGlobalConnections")));
        Assert.assertEquals((long)(initialGlobal + 1), (long)Integer.parseInt(ITestUtils.getAttribute(this.provider2, "jboss.infinispan:type=Server,name=Memcached,component=Transport", "numberOfGlobalConnections")));
    }

    @Test
    public void testHotRodServerAttributes() throws Exception {
        this.distCache.put((Object)"key1", (Object)new byte[]{1, 2, 3, 4, 5});
        Assert.assertNotEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Server,name=HotRod,component=Transport", "TotalBytesRead")));
        Assert.assertNotEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Server,name=HotRod,component=Transport", "TotalBytesWritten")));
        Assert.assertEquals((long)11222L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Server,name=HotRod,component=Transport", "Port")));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)Boolean.parseBoolean(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Server,name=HotRod,component=Transport", "tcpNoDelay")));
        Assert.assertEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Server,name=HotRod,component=Transport", "ReceiveBufferSize")));
        Assert.assertEquals((long)-1L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Server,name=HotRod,component=Transport", "IdleTimeout")));
        Assert.assertEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Server,name=HotRod,component=Transport", "SendBufferSize")));
        Assert.assertNotEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Server,name=HotRod,component=Transport", "NumberWorkerThreads")));
        Assert.assertNotEquals((long)0L, (long)ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Server,name=HotRod,component=Transport", "HostName").length());
    }

    @Test
    public void testMemcachedServerAttributes() throws Exception {
        this.mc.set("key1", "value1");
        Assert.assertNotEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Server,name=Memcached,component=Transport", "TotalBytesRead")));
        Assert.assertNotEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Server,name=Memcached,component=Transport", "TotalBytesWritten")));
        Assert.assertEquals((long)11211L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Server,name=Memcached,component=Transport", "Port")));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)Boolean.parseBoolean(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Server,name=Memcached,component=Transport", "tcpNoDelay")));
        Assert.assertEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Server,name=Memcached,component=Transport", "ReceiveBufferSize")));
        Assert.assertEquals((long)-1L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Server,name=Memcached,component=Transport", "IdleTimeout")));
        Assert.assertEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Server,name=Memcached,component=Transport", "SendBufferSize")));
        Assert.assertNotEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Server,name=Memcached,component=Transport", "NumberWorkerThreads")));
        Assert.assertNotEquals((long)0L, (long)ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Server,name=Memcached,component=Transport", "HostName").length());
    }

    @Test
    public void testCacheManagerAttributes() throws Exception {
        Assert.assertEquals((long)4L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=CacheManager,name=\"clustered\",component=CacheManager", "CreatedCacheCount")));
        Assert.assertEquals((long)4L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=CacheManager,name=\"clustered\",component=CacheManager", "DefinedCacheCount")));
        Assert.assertEquals((Object)"clustered", (Object)ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=CacheManager,name=\"clustered\",component=CacheManager", "Name"));
        Assert.assertEquals((long)2L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=CacheManager,name=\"clustered\",component=CacheManager", "ClusterSize")));
        Assert.assertEquals((Object)"RUNNING", (Object)ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=CacheManager,name=\"clustered\",component=CacheManager", "CacheManagerStatus"));
        Assert.assertNotEquals((long)0L, (long)ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=CacheManager,name=\"clustered\",component=CacheManager", "ClusterMembers").length());
        Assert.assertNotEquals((long)0L, (long)ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=CacheManager,name=\"clustered\",component=CacheManager", "NodeAddress").length());
        Assert.assertEquals((long)4L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=CacheManager,name=\"clustered\",component=CacheManager", "RunningCacheCount")));
        Assert.assertNotEquals((long)0L, (long)ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=CacheManager,name=\"clustered\",component=CacheManager", "PhysicalAddresses").length());
        Assert.assertEquals((Object)Version.VERSION, (Object)ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=CacheManager,name=\"clustered\",component=CacheManager", "Version"));
        String names = ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=CacheManager,name=\"clustered\",component=CacheManager", "DefinedCacheNames");
        Assert.assertTrue((names.contains("default") && names.contains("memcachedCache") && names.contains("hotRodTopologyCache") ? 1 : 0) != 0);
    }

    @Ignore(value="Not supported - https://bugzilla.redhat.com/show_bug.cgi?id=785105")
    @Test
    public void testCacheManagerOperations() throws Exception {
        Assert.assertTrue((!this.provider.getConnection().isRegistered(new ObjectName("jboss.infinispan:type=Cache,name=\"extracache(local)\",manager=\"clustered\",component=Cache")) ? 1 : 0) != 0);
        ITestUtils.invokeOperation(this.provider, "jboss.infinispan:type=CacheManager,name=\"clustered\",component=CacheManager", "startCache", new Object[]{"extracache"}, new String[]{"java.lang.String"});
        Assert.assertTrue((boolean)this.provider.getConnection().isRegistered(new ObjectName("jboss.infinispan:type=Cache,name=\"extracache(local)\",manager=\"clustered\",component=Cache")));
    }

    @Test
    public void testDefaultCacheAttributes() throws Exception {
        Assert.assertTrue((boolean)ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=Cache", "CacheName").contains("default"));
        Assert.assertEquals((Object)"RUNNING", (Object)ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=Cache", "CacheStatus"));
    }

    @Test
    public void testDefaultCacheOperations() throws Exception {
        Assert.assertEquals((Object)"RUNNING", (Object)ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=Cache", "CacheStatus"));
        ITestUtils.invokeOperation(this.provider, "jboss.infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=Cache", "stop", null, null);
        Assert.assertEquals((Object)"TERMINATED", (Object)ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=Cache", "CacheStatus"));
        ITestUtils.invokeOperation(this.provider, "jboss.infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=Cache", "start", null, null);
        Assert.assertEquals((Object)"RUNNING", (Object)ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=Cache", "CacheStatus"));
    }

    @Test
    public void testDistributionStateTransferManagerAttributes() throws Exception {
        Assert.assertEquals((Object)Boolean.FALSE, (Object)Boolean.parseBoolean(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=StateTransferManager", "StateTransferInProgress")));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)Boolean.parseBoolean(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=StateTransferManager", "JoinComplete")));
    }

    @Test
    public void testDistributionManagerOperations() throws Exception {
        this.distCache.put((Object)"key2", (Object)"value1");
        Assert.assertEquals((Object)Boolean.FALSE, (Object)Boolean.parseBoolean(ITestUtils.invokeOperation(this.provider, "jboss.infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=DistributionManager", "isAffectedByRehash", new Object[]{"key2"}, new String[]{"java.lang.Object"}).toString()));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)Boolean.parseBoolean(ITestUtils.invokeOperation(this.provider, "jboss.infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=DistributionManager", "isLocatedLocally", new Object[]{"key2"}, new String[]{"java.lang.String"}).toString()));
        Object keyLocation = ITestUtils.invokeOperation(this.provider, "jboss.infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=DistributionManager", "locateKey", new Object[]{"key1"}, new String[]{"java.lang.String"});
        Assert.assertTrue((boolean)(keyLocation instanceof List));
    }

    @Test
    public void testLockManagerAttributes() throws Exception {
        Assert.assertEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=LockManager", "NumberOfLocksHeld")));
        Assert.assertEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=LockManager", "NumberOfLocksAvailable")));
        Assert.assertEquals((long)1000L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=LockManager", "ConcurrencyLevel")));
    }

    @Test
    public void testCacheStatisticsAttributes() throws Exception {
        this.mc.set("key1", "value1");
        this.mc.get("key1");
        Assert.assertNotEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "NumberOfEntries")));
        this.mc.delete("key1");
        Assert.assertEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "Evictions")));
        Assert.assertEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "RemoveMisses")));
        Assert.assertNotEquals((Object)0.0, (Object)Double.parseDouble(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "ReadWriteRatio")));
        Assert.assertNotEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "Hits")));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)Boolean.parseBoolean(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "StatisticsEnabled")));
        ITestUtils.sleepForSecs(2.0);
        Assert.assertNotEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "TimeSinceReset")));
        Assert.assertNotEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "ElapsedTime")));
        Assert.assertEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "Misses")));
        Assert.assertNotEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "RemoveHits")));
        Assert.assertNotEquals(null, (Object)ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "AverageWriteTime"));
        Assert.assertNotEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "Stores")));
        Assert.assertTrue((1.0 == Double.parseDouble(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "HitRatio")) ? 1 : 0) != 0);
        Assert.assertNotEquals(null, (Object)ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "AverageReadTime"));
    }

    @Test
    public void testCacheStatisticsOperations() throws Exception {
        ITestUtils.invokeOperation(this.provider, "jboss.infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "resetStatistics", null, null);
        this.mc.set("key1", "value1");
        Assert.assertEquals((long)1L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "Stores")));
        ITestUtils.invokeOperation(this.provider, "jboss.infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "resetStatistics", null, null);
        Assert.assertEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "Stores")));
    }

    @Test
    public void testRpcManagerAttributes() throws Exception {
        this.distCache.put((Object)"key1", (Object)"value1");
        this.distCache.put((Object)"key2", (Object)"value2");
        this.distCache.put((Object)"key3", (Object)"value3");
        Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=RpcManager", "AverageReplicationTime"));
        Assert.assertTrue((1.0 == Double.parseDouble(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=RpcManager", "SuccessRatioFloatingPoint")) ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=RpcManager", "ReplicationFailures")));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)Boolean.parseBoolean(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=RpcManager", "StatisticsEnabled")));
        Assert.assertNotEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=RpcManager", "ReplicationCount")));
        Assert.assertEquals((Object)"100%", (Object)ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=RpcManager", "SuccessRatio"));
    }

    @Test
    public void testRpcManagerOperations() throws Exception {
        Assert.assertNotEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=RpcManager", "ReplicationCount")));
        ITestUtils.invokeOperation(this.provider, "jboss.infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=RpcManager", "resetStatistics", null, null);
        Assert.assertEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=RpcManager", "ReplicationCount")));
    }

    @Test
    public void testJGroupsChannelMBeanAvailable() throws Exception {
        Assert.assertTrue((boolean)this.provider.getConnection().isRegistered(new ObjectName("jgroups:type=channel,cluster=\"clustered\"")));
    }
}

