/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.jmx.suppress.statetransfer;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RemoteInfinispanServers;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.arquillian.utils.MBeanServerConnectionProvider;
import org.infinispan.server.test.util.ITestUtils;
import org.infinispan.server.test.util.RemoteInfinispanMBeans;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractStateTransferSuppressIT {
    protected static final String CONTAINER1 = "suppress-state-transfer-1";
    protected static final String CONTAINER2 = "suppress-state-transfer-2";
    protected static final String CONTAINER3 = "suppress-state-transfer-3";
    private static final int NUMBER_ENTRIES = 1000;
    final String DIST_CACHE_PREFIX = "jboss.infinispan:type=Cache,name=\"" + this.getCacheName() + "(dist_sync)\",manager=\"" + this.getCacheManagerName() + "\",component=";
    final String RPC_MANAGER_MBEAN = this.DIST_CACHE_PREFIX + "RpcManager";
    final String REBALANCE_ENABLED_ATTR_NAME = "RebalancingEnabled";
    final String COMMITTED_VIEW_AS_STRING_ATTR_NAME = "CommittedViewAsString";
    final String PENDING_VIEW_AS_STRING_ATTR_NAME = "PendingViewAsString";
    private final String OWNERS_2_MEMBERS_NODE0_NODE1 = "DefaultConsistentHash{numSegments=60, numOwners=2, members=[node0/" + this.getCacheManagerName() + ", node1/" + this.getCacheManagerName() + "]}";
    private final String OWNERS_2_MEMBERS_NODE1_NODE2 = "DefaultConsistentHash{numSegments=60, numOwners=2, members=[node1/" + this.getCacheManagerName() + ", node2/" + this.getCacheManagerName() + "]}";
    private final String OWNERS_2_MEMBERS_NODE0_NODE1_NODE2 = "DefaultConsistentHash{numSegments=60, numOwners=2, members=[node0/" + this.getCacheManagerName() + ", node1/" + this.getCacheManagerName() + ", node2/" + this.getCacheManagerName() + "]}";
    private final String LOCAL_TOPOLOGY_MANAGER = "jboss.infinispan:type=CacheManager,name=\"" + this.getCacheManagerName() + "\",component=LocalTopologyManager";
    @InfinispanResource
    RemoteInfinispanServers serverManager;
    @ArquillianResource
    ContainerController controller;
    protected final List<MBeanServerConnectionProvider> providers = new ArrayList<MBeanServerConnectionProvider>();
    private final List<RemoteInfinispanMBeans> mbeans = new ArrayList<RemoteInfinispanMBeans>();

    @Before
    public void setUp() throws Exception {
        this.mbeans.clear();
        this.mbeans.add(RemoteInfinispanMBeans.create(this.serverManager, CONTAINER1, this.getCacheName(), this.getCacheManagerName()));
        this.mbeans.add(RemoteInfinispanMBeans.create(this.serverManager, CONTAINER2, this.getCacheName(), this.getCacheManagerName()));
        this.mbeans.add(RemoteInfinispanMBeans.create(this.serverManager, CONTAINER3, this.getCacheName(), this.getCacheManagerName()));
        this.providers.clear();
        this.prepare();
    }

    @After
    public void tearDown() throws Exception {
        this.destroy();
    }

    protected RemoteInfinispanMBeans mbean(int index) {
        return this.mbeans.get(index);
    }

    protected RemoteInfinispanServer server(int index) {
        return this.mbean((int)index).server;
    }

    protected MBeanServerConnectionProvider provider(int index) {
        return this.providers.get(index);
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="suppress-state-transfer-1"), @RunningServer(name="suppress-state-transfer-2")})
    public void testRebalanceSwitch() throws Exception {
        this.checkRebalanceStatus(true, this.provider(0), this.provider(1));
        this.checkRpcManagerStatistics(new String[]{"null"}, this.OWNERS_2_MEMBERS_NODE0_NODE1, this.provider(0), this.provider(1));
        ITestUtils.setAttribute(this.provider(0), this.LOCAL_TOPOLOGY_MANAGER, "RebalancingEnabled", false);
        this.checkRebalanceStatus(false, this.provider(0), this.provider(1));
        this.putDataIntoCache(1000);
        this.checkRpcManagerStatistics(new String[]{"null"}, this.OWNERS_2_MEMBERS_NODE0_NODE1, this.provider(0), this.provider(1));
        ITestUtils.setAttribute(this.provider(1), this.LOCAL_TOPOLOGY_MANAGER, "RebalancingEnabled", true);
        this.checkRebalanceStatus(true, this.provider(0), this.provider(1));
        this.checkRpcManagerStatistics(new String[]{"null"}, this.OWNERS_2_MEMBERS_NODE0_NODE1, this.provider(0), this.provider(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @WithRunningServer(value={@RunningServer(name="suppress-state-transfer-1"), @RunningServer(name="suppress-state-transfer-2")})
    public void testRebalanceDisabledWithNewNode() throws Exception {
        try {
            this.verifyRebalanceWith3rdNode();
        }
        finally {
            this.controller.stop(CONTAINER3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @WithRunningServer(value={@RunningServer(name="suppress-state-transfer-1"), @RunningServer(name="suppress-state-transfer-2")})
    public void testRebalanceWithFirstNodeStop() throws Exception {
        try {
            this.verifyRebalanceWith3rdNode();
            ITestUtils.setAttribute(this.provider(0), this.LOCAL_TOPOLOGY_MANAGER, "RebalancingEnabled", false);
            this.controller.stop(CONTAINER1);
            this.checkRpcManagerStatistics(new String[]{"null", this.OWNERS_2_MEMBERS_NODE1_NODE2}, this.OWNERS_2_MEMBERS_NODE1_NODE2, this.provider(1), this.provider(2));
            this.checkRebalanceStatus(false, this.provider(1), this.provider(2));
            Assert.assertTrue((this.server(1).getCacheManager(this.getCacheManagerName()).getCache(this.getCacheName()).getNumberOfEntries() < 1000L ? 1 : 0) != 0);
            Assert.assertTrue((this.server(2).getCacheManager(this.getCacheManagerName()).getCache(this.getCacheName()).getNumberOfEntries() < 1000L ? 1 : 0) != 0);
            ITestUtils.setAttribute(this.provider(1), this.LOCAL_TOPOLOGY_MANAGER, "RebalancingEnabled", true);
            this.checkRebalanceStatus(true, this.provider(1), this.provider(2));
            this.checkRpcManagerStatistics(new String[]{"null", this.OWNERS_2_MEMBERS_NODE1_NODE2}, this.OWNERS_2_MEMBERS_NODE1_NODE2, this.provider(1), this.provider(2));
            Assert.assertTrue((this.server(1).getCacheManager(this.getCacheManagerName()).getCache(this.getCacheName()).getNumberOfEntries() == 1000L ? 1 : 0) != 0);
            Assert.assertTrue((this.server(2).getCacheManager(this.getCacheManagerName()).getCache(this.getCacheName()).getNumberOfEntries() == 1000L ? 1 : 0) != 0);
        }
        finally {
            this.controller.stop(CONTAINER3);
        }
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="suppress-state-transfer-1"), @RunningServer(name="suppress-state-transfer-2")})
    public void testRebalanceWithJoinedNodeStop() throws Exception {
        this.verifyRebalanceWith3rdNode();
        ITestUtils.setAttribute(this.provider(0), this.LOCAL_TOPOLOGY_MANAGER, "RebalancingEnabled", false);
        this.controller.stop(CONTAINER3);
        this.checkRpcManagerStatistics(new String[]{"null", this.OWNERS_2_MEMBERS_NODE0_NODE1}, this.OWNERS_2_MEMBERS_NODE0_NODE1, this.provider(0), this.provider(1));
        this.checkRebalanceStatus(false, this.provider(0), this.provider(1));
        Assert.assertTrue((this.server(0).getCacheManager(this.getCacheManagerName()).getCache(this.getCacheName()).getNumberOfEntries() < 1000L ? 1 : 0) != 0);
        Assert.assertTrue((this.server(1).getCacheManager(this.getCacheManagerName()).getCache(this.getCacheName()).getNumberOfEntries() < 1000L ? 1 : 0) != 0);
        ITestUtils.setAttribute(this.provider(1), this.LOCAL_TOPOLOGY_MANAGER, "RebalancingEnabled", true);
        this.checkRebalanceStatus(true, this.provider(0), this.provider(1));
        this.checkRpcManagerStatistics(new String[]{"null", this.OWNERS_2_MEMBERS_NODE0_NODE1}, this.OWNERS_2_MEMBERS_NODE0_NODE1, this.provider(0), this.provider(1));
        Assert.assertTrue((this.server(0).getCacheManager(this.getCacheManagerName()).getCache(this.getCacheName()).getNumberOfEntries() == 1000L ? 1 : 0) != 0);
        Assert.assertTrue((this.server(1).getCacheManager(this.getCacheManagerName()).getCache(this.getCacheName()).getNumberOfEntries() == 1000L ? 1 : 0) != 0);
    }

    private void verifyRebalanceWith3rdNode() throws Exception {
        ITestUtils.setAttribute(this.provider(0), this.LOCAL_TOPOLOGY_MANAGER, "RebalancingEnabled", false);
        this.putDataIntoCache(1000);
        this.checkRebalanceStatus(false, this.provider(0), this.provider(1));
        this.checkRpcManagerStatistics(new String[]{"null"}, this.OWNERS_2_MEMBERS_NODE0_NODE1, this.provider(0), this.provider(1));
        this.controller.start(CONTAINER3);
        this.createNewProvider(2);
        this.checkRebalanceStatus(false, this.provider(2));
        this.checkRpcManagerStatistics(new String[]{"null"}, this.OWNERS_2_MEMBERS_NODE0_NODE1, this.provider(0), this.provider(1), this.provider(2));
        Assert.assertTrue((String)"The cache on server(2) should be empty.", (this.server(2).getCacheManager(this.getCacheManagerName()).getCache(this.getCacheName()).getNumberOfEntries() == 0L ? 1 : 0) != 0);
        ITestUtils.setAttribute(this.provider(0), this.LOCAL_TOPOLOGY_MANAGER, "RebalancingEnabled", true);
        this.checkRebalanceStatus(true, this.provider(0), this.provider(1), this.provider(2));
        this.checkRpcManagerStatistics(new String[]{"null", this.OWNERS_2_MEMBERS_NODE0_NODE1_NODE2}, null, this.provider(0), this.provider(1), this.provider(2));
        this.checkRpcManagerStatistics(new String[]{"null"}, this.OWNERS_2_MEMBERS_NODE0_NODE1_NODE2, this.provider(0), this.provider(1), this.provider(2));
        Assert.assertTrue((this.server(0).getCacheManager(this.getCacheManagerName()).getCache(this.getCacheName()).getNumberOfEntries() < 1000L ? 1 : 0) != 0);
        Assert.assertTrue((this.server(1).getCacheManager(this.getCacheManagerName()).getCache(this.getCacheName()).getNumberOfEntries() < 1000L ? 1 : 0) != 0);
        Assert.assertTrue((this.server(2).getCacheManager(this.getCacheManagerName()).getCache(this.getCacheName()).getNumberOfEntries() < 1000L ? 1 : 0) != 0);
    }

    private void checkRebalanceStatus(final boolean expectedStatus, MBeanServerConnectionProvider ... providers) throws Exception {
        for (final MBeanServerConnectionProvider provider : providers) {
            ITestUtils.eventually(new ITestUtils.Condition(){

                @Override
                public boolean isSatisfied() throws Exception {
                    return expectedStatus == Boolean.parseBoolean(ITestUtils.getAttribute(provider, AbstractStateTransferSuppressIT.this.LOCAL_TOPOLOGY_MANAGER, "RebalancingEnabled"));
                }
            }, 10000L);
        }
    }

    private void checkRpcManagerStatistics(String[] expectedPendingViews, final String expectedCommitedView, MBeanServerConnectionProvider ... providers) throws Exception {
        for (final MBeanServerConnectionProvider provider : providers) {
            if (expectedCommitedView != null) {
                ITestUtils.eventually(new ITestUtils.Condition(){

                    @Override
                    public boolean isSatisfied() throws Exception {
                        String committedViewAsString = String.valueOf(ITestUtils.getAttribute(provider, AbstractStateTransferSuppressIT.this.RPC_MANAGER_MBEAN, "CommittedViewAsString"));
                        return expectedCommitedView.equals(committedViewAsString);
                    }
                }, 10000L);
            }
            String pendingViewAsString = String.valueOf(ITestUtils.getAttribute(provider, this.RPC_MANAGER_MBEAN, "PendingViewAsString"));
            boolean passed = false;
            for (String expectedPendingView : expectedPendingViews) {
                if (!expectedPendingView.equals(pendingViewAsString)) continue;
                passed = true;
                break;
            }
            Assert.assertTrue((String)("The pending view doesn't match to any of expected ones, but is " + pendingViewAsString + "."), (boolean)passed);
        }
    }

    protected abstract void prepare();

    protected abstract void destroy();

    protected abstract void putDataIntoCache(int var1);

    protected abstract String getCacheName();

    protected abstract String getCacheManagerName();

    protected abstract void createNewProvider(int var1);
}

