/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.security.jgroups.encrypt;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServers;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.arquillian.utils.MBeanServerConnectionProvider;
import org.infinispan.server.test.client.memcached.MemcachedClient;
import org.infinispan.server.test.util.ITestUtils;
import org.infinispan.server.test.util.RemoteInfinispanMBeans;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class EncryptProtocolIT {
    @InfinispanResource
    RemoteInfinispanServers servers;
    @ArquillianResource
    ContainerController controller;
    final String COORDINATOR_NODE = "clustered-encrypt-1";
    final String JOINING_NODE = "clustered-encrypt-2";
    final String ENCRYPT_MBEAN = "jgroups:type=protocol,cluster=\"clustered\",protocol=ENCRYPT";
    final String ENCRYPT_PROPERTY_KEY = "key_store_name";
    final String ENCRYPT_PROPERTY_VALUE_SUFFIX = "server_jceks.keystore";
    final String ENCRYPT_PASSWORD_KEY = "store_password";

    @BeforeClass
    public static void before() {
        if (System.getProperty("java.vendor").toLowerCase().contains("ibm") && (System.getProperty("java.version").contains("1.7") || System.getProperty("java.version").contains("1.6"))) {
            EncryptProtocolIT.replaceKeyStoreInConfig(System.getProperty("server1.dist"));
            EncryptProtocolIT.replaceKeyStoreInConfig(System.getProperty("server2.dist"));
        }
    }

    private static void replaceKeyStoreInConfig(String serverDir) {
        try {
            File configFile = new File(serverDir + "/standalone/configuration/testsuite/clustered-with-encrypt.xml");
            String configContent = FileUtils.readFileToString((File)configFile, (String)"UTF-8");
            configContent = configContent.replaceAll("server_jceks.keystore", "ibm7_server_jceks.keystore");
            FileUtils.writeStringToFile((File)configFile, (String)configContent, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException("Replacing the keystore in configuration failed ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @WithRunningServer(value={@RunningServer(name="clustered-encrypt-1")})
    public void testEncryptProtocolRegistered() throws Exception {
        try {
            this.controller.start("clustered-encrypt-2");
            RemoteInfinispanMBeans coordinator = RemoteInfinispanMBeans.create(this.servers, "clustered-encrypt-1", "memcachedCache", "clustered");
            RemoteInfinispanMBeans friend = RemoteInfinispanMBeans.create(this.servers, "clustered-encrypt-2", "memcachedCache", "clustered");
            MBeanServerConnectionProvider providerCoordinator = new MBeanServerConnectionProvider(coordinator.server.getHotrodEndpoint().getInetAddress().getHostName(), 9990);
            MBeanServerConnectionProvider providerFriend = new MBeanServerConnectionProvider(friend.server.getHotrodEndpoint().getInetAddress().getHostName(), 10090);
            MemcachedClient mcCoordinator = new MemcachedClient(coordinator.server.getMemcachedEndpoint().getInetAddress().getHostName(), coordinator.server.getMemcachedEndpoint().getPort());
            MemcachedClient mcFriend = new MemcachedClient(friend.server.getMemcachedEndpoint().getInetAddress().getHostName(), friend.server.getMemcachedEndpoint().getPort());
            Assert.assertEquals((long)2L, (long)coordinator.manager.getClusterSize());
            Assert.assertEquals((long)2L, (long)friend.manager.getClusterSize());
            Assert.assertTrue((boolean)ITestUtils.getAttribute(providerCoordinator, "jgroups:type=protocol,cluster=\"clustered\",protocol=ENCRYPT", "key_store_name").endsWith("server_jceks.keystore"));
            Assert.assertTrue((boolean)ITestUtils.getAttribute(providerFriend, "jgroups:type=protocol,cluster=\"clustered\",protocol=ENCRYPT", "key_store_name").endsWith("server_jceks.keystore"));
            Assert.assertNull((Object)ITestUtils.getAttribute(providerCoordinator, "jgroups:type=protocol,cluster=\"clustered\",protocol=ENCRYPT", "store_password"));
            mcFriend.set("key1", "value1");
            Assert.assertEquals((String)"Could not read replicated pair key1/value1", (Object)"value1", (Object)mcCoordinator.get("key1"));
        }
        finally {
            this.controller.stop("clustered-encrypt-2");
        }
    }
}

