/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.security.rest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.security.JBossJSSESecurityDomain;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Ignore
public class RESTCertSecurityIT {
    private static final String CONTAINER = "rest-security-cert";
    private static final String KEY_A = "a";
    private static final String KEY_B = "b";
    private static final String KEY_C = "c";
    private static final String KEY_D = "d";
    private static final String testAlias = "test";
    private static final String test2Alias = "test2";
    @InfinispanResource(value="rest-security-cert")
    RemoteInfinispanServer server;

    @Test
    @WithRunningServer(value={@RunningServer(name="rest-security-cert", config="testsuite/rest-sec-cert-wr.xml")})
    public void testSecuredWriteOperations() throws Exception {
        this.put(RESTCertSecurityIT.securedClient(testAlias), this.keyAddress(KEY_A), 200);
        this.put(RESTCertSecurityIT.securedClient(test2Alias), this.keyAddress(KEY_B), 403);
        this.put(RESTCertSecurityIT.securedClient(testAlias), this.keyAddressUnsecured(KEY_B), 401);
        this.post(RESTCertSecurityIT.securedClient(testAlias), this.keyAddress(KEY_C), 200);
        this.post(RESTCertSecurityIT.securedClient(test2Alias), this.keyAddress(KEY_D), 403);
        HttpResponse resp = this.get(RESTCertSecurityIT.securedClient(test2Alias), this.keyAddressUnsecured(KEY_A), 200);
        String content = new BufferedReader(new InputStreamReader(resp.getEntity().getContent())).readLine();
        Assert.assertEquals((Object)"data", (Object)content);
        this.head(RESTCertSecurityIT.securedClient(test2Alias), this.keyAddressUnsecured(KEY_A), 200);
        this.delete(RESTCertSecurityIT.securedClient(test2Alias), this.keyAddress(KEY_A), 403);
        this.delete(RESTCertSecurityIT.securedClient(testAlias), this.keyAddress(KEY_A), 200);
        this.delete(RESTCertSecurityIT.securedClient(testAlias), this.keyAddress(KEY_C), 200);
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="rest-security-cert", config="testsuite/rest-sec-cert-rw.xml")})
    public void testSecuredReadWriteOperations() throws Exception {
        this.put(RESTCertSecurityIT.securedClient(testAlias), this.keyAddress(KEY_A), 200);
        this.put(RESTCertSecurityIT.securedClient(test2Alias), this.keyAddress(KEY_B), 403);
        this.put(RESTCertSecurityIT.securedClient(testAlias), this.keyAddressUnsecured(KEY_B), 401);
        this.post(RESTCertSecurityIT.securedClient(testAlias), this.keyAddress(KEY_C), 200);
        this.post(RESTCertSecurityIT.securedClient(test2Alias), this.keyAddress(KEY_D), 403);
        HttpResponse resp = this.get(RESTCertSecurityIT.securedClient(testAlias), this.keyAddress(KEY_A), 200);
        String content = new BufferedReader(new InputStreamReader(resp.getEntity().getContent())).readLine();
        Assert.assertEquals((Object)"data", (Object)content);
        this.get(RESTCertSecurityIT.securedClient(test2Alias), this.keyAddress(KEY_A), 403);
        this.get(RESTCertSecurityIT.securedClient(testAlias), this.keyAddressUnsecured(KEY_A), 401);
        this.head(RESTCertSecurityIT.securedClient(test2Alias), this.keyAddress(KEY_A), 403);
        this.head(RESTCertSecurityIT.securedClient(testAlias), this.keyAddressUnsecured(KEY_A), 401);
        this.head(RESTCertSecurityIT.securedClient(testAlias), this.keyAddress(KEY_A), 200);
        this.delete(RESTCertSecurityIT.securedClient(test2Alias), this.keyAddress(KEY_A), 403);
        this.delete(RESTCertSecurityIT.securedClient(testAlias), this.keyAddress(KEY_A), 200);
        this.delete(RESTCertSecurityIT.securedClient(testAlias), this.keyAddress(KEY_C), 200);
    }

    private String keyAddress(String key) {
        return "https://" + this.server.getRESTEndpoint().getInetAddress().getHostName() + ":8443" + this.server.getRESTEndpoint().getContextPath() + "/default/" + key;
    }

    private String keyAddressUnsecured(String key) {
        return "http://" + this.server.getRESTEndpoint().getInetAddress().getHostName() + ":8080" + this.server.getRESTEndpoint().getContextPath() + "/default/" + key;
    }

    private HttpResponse put(CloseableHttpClient httpClient, String uri, int expectedCode) throws Exception {
        HttpPut put = new HttpPut(uri);
        put.setEntity((HttpEntity)new StringEntity("data", "UTF-8"));
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)put);
        Assert.assertEquals((long)expectedCode, (long)response.getStatusLine().getStatusCode());
        return response;
    }

    private HttpResponse post(CloseableHttpClient httpClient, String uri, int expectedCode) throws Exception {
        HttpPost post = new HttpPost(uri);
        post.setEntity((HttpEntity)new StringEntity("data", "UTF-8"));
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
        Assert.assertEquals((long)expectedCode, (long)response.getStatusLine().getStatusCode());
        return response;
    }

    private HttpResponse get(CloseableHttpClient httpClient, String uri, int expectedCode) throws Exception {
        HttpGet get = new HttpGet(uri);
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);
        Assert.assertEquals((long)expectedCode, (long)response.getStatusLine().getStatusCode());
        return response;
    }

    private HttpResponse delete(CloseableHttpClient httpClient, String uri, int expectedCode) throws Exception {
        HttpDelete delete = new HttpDelete(uri);
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)delete);
        Assert.assertEquals((long)expectedCode, (long)response.getStatusLine().getStatusCode());
        return response;
    }

    private HttpResponse head(CloseableHttpClient httpClient, String uri, int expectedCode) throws Exception {
        HttpHead head = new HttpHead(uri);
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)head);
        Assert.assertEquals((long)expectedCode, (long)response.getStatusLine().getStatusCode());
        return response;
    }

    public static CloseableHttpClient securedClient(String alias) {
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            JBossJSSESecurityDomain jsseSecurityDomain = new JBossJSSESecurityDomain("client_cert_auth");
            jsseSecurityDomain.setKeyStorePassword("changeit");
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            URL keystore = tccl.getResource("client.keystore");
            jsseSecurityDomain.setKeyStoreURL(keystore.getPath());
            jsseSecurityDomain.setClientAlias(alias);
            jsseSecurityDomain.reloadKeyAndTrustStore();
            KeyManager[] keyManagers = jsseSecurityDomain.getKeyManagers();
            TrustManager[] trustManagers = jsseSecurityDomain.getTrustManagers();
            ctx.init(keyManagers, trustManagers, null);
            X509HostnameVerifier verifier = new X509HostnameVerifier(){

                public void verify(String s, SSLSocket sslSocket) throws IOException {
                }

                public void verify(String s, X509Certificate x509Certificate) throws SSLException {
                }

                public void verify(String s, String[] strings, String[] strings1) throws SSLException {
                }

                public boolean verify(String string, SSLSession ssls) {
                    return true;
                }
            };
            SSLConnectionSocketFactory sslssf = new SSLConnectionSocketFactory(ctx, verifier);
            PlainConnectionSocketFactory plainsf = new PlainConnectionSocketFactory();
            Registry sr = RegistryBuilder.create().register("http", (Object)plainsf).register("https", (Object)sslssf).build();
            PoolingHttpClientConnectionManager pcm = new PoolingHttpClientConnectionManager(sr);
            CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)pcm).build();
            return httpClient;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

