/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.transport;

import java.util.Scanner;
import javax.management.ObjectName;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.utils.MBeanServerConnectionProvider;
import org.infinispan.server.test.util.ITestUtils;
import org.jboss.arquillian.container.test.api.Config;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class TransportStackConfigurationIT {
    private final String CONTAINER1 = "transport-stack-1";
    private final String CONTAINER2 = "transport-stack-2";
    @InfinispanResource(value="transport-stack-1")
    RemoteInfinispanServer server1;
    @ArquillianResource
    ContainerController controller;
    private MBeanServerConnectionProvider provider;
    String udpProtocolMBean = "jgroups:type=protocol,cluster=\"clustered\",protocol=UDP";
    String tcpProtocolMBean = "jgroups:type=protocol,cluster=\"clustered\",protocol=TCP";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUDPStackAttributes() throws Exception {
        try {
            this.startContainerWithStack("transport-stack-1", "node0", 0, "udp");
            this.startContainerWithStack("transport-stack-2", "node1", 100, "udp");
            this.provider = new MBeanServerConnectionProvider(this.server1.getHotrodEndpoint().getInetAddress().getHostName(), 9990);
            this.assertMBeanAttributes(this.provider, this.udpProtocolMBean);
        }
        catch (Throwable throwable) {
            this.stopContainers("transport-stack-1", "transport-stack-2");
            throw throwable;
        }
        this.stopContainers("transport-stack-1", "transport-stack-2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTCPStackAttributes() throws Exception {
        try {
            this.startContainerWithStack("transport-stack-1", "node0", 0, "tcp");
            this.startContainerWithStack("transport-stack-2", "node1", 100, "tcp");
            this.provider = new MBeanServerConnectionProvider(this.server1.getHotrodEndpoint().getInetAddress().getHostName(), 9990);
            this.assertMBeanAttributes(this.provider, this.tcpProtocolMBean);
        }
        catch (Throwable throwable) {
            this.stopContainers("transport-stack-1", "transport-stack-2");
            throw throwable;
        }
        this.stopContainers("transport-stack-1", "transport-stack-2");
    }

    private void assertMBeanAttributes(MBeanServerConnectionProvider provider, String protocolMBean) throws Exception {
        Assert.assertEquals((Object)true, (Object)Boolean.parseBoolean(ITestUtils.getAttribute(provider, protocolMBean, "discard_incompatible_packets")));
        Assert.assertEquals((Object)true, (Object)Boolean.parseBoolean(ITestUtils.getAttribute(provider, protocolMBean, "enable_bundling")));
        Assert.assertEquals((Object)true, (Object)Boolean.parseBoolean(ITestUtils.getAttribute(provider, protocolMBean, "thread_pool.enabled")));
        Assert.assertEquals((Object)true, (Object)Boolean.parseBoolean(ITestUtils.getAttribute(provider, protocolMBean, "thread_pool.queue_enabled")));
        Assert.assertEquals((Object)"discard", (Object)ITestUtils.getAttribute(provider, protocolMBean, "thread_pool.rejection_policy"));
        Assert.assertEquals((Object)true, (Object)Boolean.parseBoolean(ITestUtils.getAttribute(provider, protocolMBean, "oob_thread_pool.enabled")));
        Assert.assertEquals((Object)true, (Object)Boolean.parseBoolean(ITestUtils.getAttribute(provider, protocolMBean, "oob_thread_pool.queue_enabled")));
        Assert.assertEquals((Object)"discard", (Object)ITestUtils.getAttribute(provider, protocolMBean, "oob_thread_pool.rejection_policy"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecutorAttribute() throws Exception {
        try {
            this.startContainerWithStack("transport-stack-1", "node0", 0, "tcp");
            this.startContainerWithStack("transport-stack-2", "node1", 100, "tcp");
            this.provider = new MBeanServerConnectionProvider(this.server1.getHotrodEndpoint().getInetAddress().getHostName(), 9990);
            String dumpServicesBean = "jboss.msc:type=container,name=jboss-as";
            String dumpServicesOp = "dumpServicesToString";
            String services = this.provider.getConnection().invoke(new ObjectName("jboss.msc:type=container,name=jboss-as"), "dumpServicesToString", null, null).toString();
            Assert.assertTrue((boolean)this.isTestInfinispanTransportSpecified(services));
        }
        catch (Throwable throwable) {
            this.stopContainers("transport-stack-1", "transport-stack-2");
            throw throwable;
        }
        this.stopContainers("transport-stack-1", "transport-stack-2");
    }

    private boolean isTestInfinispanTransportSpecified(String services) {
        Scanner s = new Scanner(services).useDelimiter("\n");
        try {
            String line;
            while (!(line = s.nextLine()).contains("Service \"jboss.infinispan.clustered.config\"") || !line.substring(line.indexOf("dependencies:")).contains("jboss.thread.executor.infinispan-transport")) {
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void startContainerWithStack(String containerName, String nodeName, int portOffset, String stack) {
        this.controller.start(containerName, new Config().add("javaVmArguments", System.getProperty("server.jvm.args") + " -Djboss.node.name=" + nodeName + " -Djboss.socket.binding.port-offset=" + portOffset + " -Djboss.default.jgroups.stack=" + stack).map());
    }

    private void stopContainers(String ... containerNames) {
        for (String name : containerNames) {
            this.controller.stop(name);
        }
    }
}

