/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.hotrod;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryModified;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.event.ClientCacheEntryCustomEvent;
import org.infinispan.server.test.client.hotrod.CustomEvent;
import org.junit.Assert;

public abstract class CustomEventLogListener {
    BlockingQueue<CustomEvent> customEvents = new ArrayBlockingQueue<CustomEvent>(128);

    CustomEvent pollEvent() {
        try {
            CustomEvent event = this.customEvents.poll(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)event);
            return event;
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void expectNoEvents() {
        Assert.assertEquals((long)0L, (long)this.customEvents.size());
    }

    public void expectSingleCustomEvent(Integer key, String value) {
        CustomEvent event = this.pollEvent();
        Assert.assertEquals((Object)key, (Object)event.key);
        Assert.assertEquals((Object)value, (Object)event.value);
    }

    @ClientCacheEntryCreated
    @ClientCacheEntryModified
    @ClientCacheEntryRemoved
    public void handleCustomEvent(ClientCacheEntryCustomEvent<CustomEvent> e) {
        this.customEvents.add((CustomEvent)e.getEventData());
    }
}

