/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.hotrod;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryModified;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.annotation.ClientCacheFailover;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryCreatedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryModifiedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryRemovedEvent;
import org.infinispan.client.hotrod.event.ClientCacheFailoverEvent;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.junit.Assert;

@ClientListener
public class EventLogListener {
    public BlockingQueue<ClientCacheEntryCreatedEvent> createdEvents = new ArrayBlockingQueue<ClientCacheEntryCreatedEvent>(128);
    public BlockingQueue<ClientCacheEntryModifiedEvent> modifiedEvents = new ArrayBlockingQueue<ClientCacheEntryModifiedEvent>(128);
    public BlockingQueue<ClientCacheEntryRemovedEvent> removedEvents = new ArrayBlockingQueue<ClientCacheEntryRemovedEvent>(128);
    public BlockingQueue<ClientCacheFailoverEvent> failoverEvents = new ArrayBlockingQueue<ClientCacheFailoverEvent>(128);

    public <E extends ClientEvent> E pollEvent(ClientEvent.Type type) {
        try {
            ClientEvent event = (ClientEvent)this.queue(type).poll(10L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)event);
            return (E)event;
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public <E extends ClientEvent> BlockingQueue<E> queue(ClientEvent.Type type) {
        switch (type) {
            case CLIENT_CACHE_ENTRY_CREATED: {
                return this.createdEvents;
            }
            case CLIENT_CACHE_ENTRY_MODIFIED: {
                return this.modifiedEvents;
            }
            case CLIENT_CACHE_ENTRY_REMOVED: {
                return this.removedEvents;
            }
            case CLIENT_CACHE_FAILOVER: {
                return this.failoverEvents;
            }
        }
        throw new IllegalArgumentException("Unknown event type: " + type);
    }

    @ClientCacheEntryCreated
    public void handleCreatedEvent(ClientCacheEntryCreatedEvent e) {
        this.createdEvents.add(e);
    }

    @ClientCacheEntryModified
    public void handleModifiedEvent(ClientCacheEntryModifiedEvent e) {
        this.modifiedEvents.add(e);
    }

    @ClientCacheEntryRemoved
    public void handleRemovedEvent(ClientCacheEntryRemovedEvent e) {
        this.removedEvents.add(e);
    }

    @ClientCacheFailover
    public void handleFailover(ClientCacheFailoverEvent e) {
        this.failoverEvents.add(e);
    }
}

