/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.hotrod.security;

import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.SaslQop;
import org.infinispan.client.hotrod.configuration.SaslStrength;
import org.infinispan.server.test.category.Security;
import org.infinispan.server.test.client.hotrod.security.HotRodSaslAuthTestBase;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.After;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={Security.class})
public class HotRodDigestMd5AuthWithQopIT
extends HotRodSaslAuthTestBase {
    private static final String ARQ_CONTAINER_ID = "hotrodAuthQop";
    @ArquillianResource
    public ContainerController controller;

    @Override
    protected ConfigurationBuilder getDefaultConfigBuilder() {
        ConfigurationBuilder builder = super.getDefaultConfigBuilder();
        builder.security().authentication().saslQop(new SaslQop[]{SaslQop.AUTH_CONF}).saslStrength(new SaslStrength[]{SaslStrength.HIGH, SaslStrength.MEDIUM, SaslStrength.LOW});
        return builder;
    }

    @Override
    public String getTestedMech() {
        return "DIGEST-MD5";
    }

    @Before
    public void startIspnServer() {
        this.controller.start(ARQ_CONTAINER_ID);
    }

    @After
    public void stopIspnServer() {
        this.controller.stop(ARQ_CONTAINER_ID);
    }

    @Override
    public String getHRServerHostname() {
        return "localhost";
    }

    @Override
    public int getHRServerPort() {
        return 11222;
    }

    @Override
    public void initAsAdmin() {
        this.initialize("admin", "strongPassword");
    }

    @Override
    public void initAsReader() {
        this.initialize("reader", "password");
    }

    @Override
    public void initAsWriter() {
        this.initialize("writer", "somePassword");
    }

    @Override
    public void initAsSupervisor() {
        this.initialize("supervisor", "lessStrongPassword");
    }
}

