/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.hotrod.security;

import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.server.test.category.Security;
import org.infinispan.server.test.client.hotrod.security.HotRodSaslAuthTestBase;
import org.infinispan.test.integration.security.utils.ApacheDsLdap;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={Security.class})
@WithRunningServer(value={@RunningServer(name="hotrodAuthLdap")})
public class HotRodPlainAuthLdapIT
extends HotRodSaslAuthTestBase {
    private static ApacheDsLdap ldap;
    @InfinispanResource(value="hotrodAuthLdap")
    private RemoteInfinispanServer server;

    @BeforeClass
    public static void kerberosSetup() throws Exception {
        ldap = new ApacheDsLdap("localhost");
        ldap.start();
    }

    @AfterClass
    public static void ldapTearDown() throws Exception {
        ldap.stop();
    }

    @Override
    public String getTestedMech() {
        return "PLAIN";
    }

    @Override
    public String getHRServerHostname() {
        return this.server.getHotrodEndpoint().getInetAddress().getHostName();
    }

    @Override
    public int getHRServerPort() {
        return this.server.getHotrodEndpoint().getPort();
    }

    @Override
    public void initAsAdmin() {
        this.initialize("admin", "strongPassword");
    }

    @Override
    public void initAsReader() {
        this.initialize("reader", "password");
    }

    @Override
    public void initAsWriter() {
        this.initialize("writer", "somePassword");
    }

    @Override
    public void initAsSupervisor() {
        this.initialize("supervisor", "lessStrongPassword");
    }
}

