/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.hotrod.security;

import java.io.IOException;
import java.security.PrivilegedActionException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.sasl.RealmCallback;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public abstract class HotRodSaslAuthTestBase {
    protected static final String TEST_REALM = "ApplicationRealm";
    protected static final String TEST_SERVER_NAME = "node0";
    protected static final String TEST_CACHE_NAME = "testcache";
    protected static final String TEST_KEY = "testKey";
    protected static final String TEST_VALUE = "testValue";
    protected static final String ADMIN_LOGIN = "admin";
    protected static final String ADMIN_PASSWD = "strongPassword";
    protected static final String READER_LOGIN = "reader";
    protected static final String READER_PASSWD = "password";
    protected static final String WRITER_LOGIN = "writer";
    protected static final String WRITER_PASSWD = "somePassword";
    protected static final String SUPERVISOR_LOGIN = "supervisor";
    protected static final String SUPERVISOR_PASSWD = "lessStrongPassword";
    protected RemoteCache<String, String> remoteCache;
    protected static RemoteCacheManager remoteCacheManager = null;

    public abstract String getTestedMech();

    public abstract String getHRServerHostname();

    public abstract int getHRServerPort();

    public abstract void initAsAdmin() throws PrivilegedActionException, LoginException;

    public abstract void initAsReader() throws PrivilegedActionException, LoginException;

    public abstract void initAsWriter() throws PrivilegedActionException, LoginException;

    public abstract void initAsSupervisor() throws PrivilegedActionException, LoginException;

    @After
    public void release() {
        if (remoteCacheManager != null) {
            remoteCacheManager.stop();
        }
    }

    protected void initialize(Subject subj) throws PrivilegedActionException {
        Configuration config = this.getRemoteCacheManagerConfig(subj);
        remoteCacheManager = new RemoteCacheManager(config, true);
        this.remoteCache = remoteCacheManager.getCache(TEST_CACHE_NAME);
    }

    protected void initialize(String login, String password) {
        Configuration config = this.getRemoteCacheManagerConfig(login, password);
        remoteCacheManager = new RemoteCacheManager(config, true);
        this.remoteCache = remoteCacheManager.getCache(TEST_CACHE_NAME);
    }

    protected Configuration getRemoteCacheManagerConfig(String login, String password) {
        ConfigurationBuilder config = this.getDefaultConfigBuilder();
        config.security().authentication().callbackHandler((CallbackHandler)new LoginHandler(login, password, TEST_REALM));
        return config.build();
    }

    protected Configuration getRemoteCacheManagerConfig(Subject subj) {
        ConfigurationBuilder config = this.getDefaultConfigBuilder();
        config.security().authentication().clientSubject(subj).callbackHandler((CallbackHandler)new LoginHandler("", ""));
        return config.build();
    }

    protected ConfigurationBuilder getDefaultConfigBuilder() {
        ConfigurationBuilder config = new ConfigurationBuilder();
        config.addServer().host(this.getHRServerHostname()).port(this.getHRServerPort());
        config.security().authentication().serverName(TEST_SERVER_NAME).saslMechanism(this.getTestedMech()).enable();
        return config;
    }

    @Test
    public void testAdmin() throws PrivilegedActionException, LoginException {
        this.initAsAdmin();
        this.testWriteRead();
    }

    @Test
    public void testReaderRead() throws PrivilegedActionException, LoginException {
        this.initAsReader();
        this.testReadNonExitent();
    }

    @Test(expected=HotRodClientException.class)
    public void testReaderWrite() throws PrivilegedActionException, LoginException {
        this.initAsReader();
        this.testWrite();
    }

    @Test
    public void testWriterWrite() throws PrivilegedActionException, LoginException {
        this.initAsWriter();
        this.testWrite();
    }

    @Test(expected=HotRodClientException.class)
    public void testWriterWriteRead() throws PrivilegedActionException, LoginException {
        this.initAsWriter();
        this.testWriteRead();
    }

    @Test
    public void testSupervisorWriteRead() throws PrivilegedActionException, LoginException {
        this.initAsSupervisor();
        this.testWriteRead();
    }

    protected void testReadNonExitent() {
        Assert.assertEquals(null, (Object)this.remoteCache.get((Object)"nonExistentKey"));
    }

    protected void testRead() {
        Assert.assertTrue((boolean)this.remoteCache.containsKey((Object)TEST_KEY));
        Assert.assertEquals((Object)TEST_VALUE, (Object)this.remoteCache.get((Object)TEST_KEY));
    }

    protected void testWrite() {
        Assert.assertNull((Object)this.remoteCache.put((Object)TEST_KEY, (Object)TEST_VALUE));
    }

    protected void testWriteRead() {
        this.testWrite();
        this.testRead();
    }

    public static class LoginHandler
    implements CallbackHandler {
        private final String login;
        private final String password;
        private final String realm;

        public LoginHandler(String login, String password) {
            this.login = login;
            this.password = password;
            this.realm = null;
        }

        public LoginHandler(String login, String password, String realm) {
            this.login = login;
            this.password = password;
            this.realm = realm;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    ((NameCallback)callback).setName(this.login);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    ((PasswordCallback)callback).setPassword(this.password.toCharArray());
                    continue;
                }
                if (callback instanceof RealmCallback) {
                    ((RealmCallback)callback).setText(this.realm);
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
        }
    }
}

