/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.rest;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Arrays;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.infinispan.server.test.client.rest.RESTHelper;
import org.infinispan.server.test.util.ITestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractRESTClientIT {
    private static final String DEFAULT_NAMED_CACHE = "namedCache";

    protected abstract void addRestServer();

    @Before
    public void setUp() throws Exception {
        this.addRestServer();
        RESTHelper.delete(RESTHelper.fullPathKey("a"));
        RESTHelper.delete(RESTHelper.fullPathKey("b"));
        RESTHelper.delete(RESTHelper.fullPathKey("c"));
        RESTHelper.delete(RESTHelper.fullPathKey(DEFAULT_NAMED_CACHE, "a"));
        RESTHelper.head(RESTHelper.fullPathKey("a"), 404);
        RESTHelper.head(RESTHelper.fullPathKey("b"), 404);
        RESTHelper.head(RESTHelper.fullPathKey("c"), 404);
        RESTHelper.head(RESTHelper.fullPathKey(DEFAULT_NAMED_CACHE, "a"), 404);
    }

    @After
    public void tearDown() throws Exception {
        RESTHelper.delete(RESTHelper.fullPathKey("a"));
        RESTHelper.delete(RESTHelper.fullPathKey("b"));
        RESTHelper.delete(RESTHelper.fullPathKey("c"));
        RESTHelper.delete(RESTHelper.fullPathKey(DEFAULT_NAMED_CACHE, "a"));
    }

    @Test
    public void testBasicOperation() throws Exception {
        URI fullPathKey = RESTHelper.fullPathKey("a");
        String initialXML = "<hey>ho</hey>";
        HttpResponse insert = RESTHelper.put(fullPathKey, initialXML, "application/octet-stream");
        Assert.assertEquals((long)0L, (long)insert.getEntity().getContentLength());
        HttpResponse get = RESTHelper.get(fullPathKey, initialXML);
        Assert.assertEquals((Object)"application/octet-stream", (Object)get.getHeaders("Content-Type")[0].getValue());
        RESTHelper.delete(fullPathKey);
        RESTHelper.get(fullPathKey, 404);
        RESTHelper.put(fullPathKey, initialXML, "application/octet-stream");
        RESTHelper.get(fullPathKey, initialXML);
        RESTHelper.delete(RESTHelper.fullPathKey(null));
        RESTHelper.get(fullPathKey, 404);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        oo.writeObject(new TestSerializable("CONTENT"));
        oo.flush();
        byte[] byteData = bout.toByteArray();
        RESTHelper.put(fullPathKey, byteData, "application/octet-stream");
        HttpResponse resp = RESTHelper.getWithoutClose(fullPathKey);
        int respLength = new Long(resp.getEntity().getContentLength()).intValue();
        byte[] bytesBack = new byte[respLength];
        resp.getEntity().getContent().read(bytesBack, 0, respLength);
        EntityUtils.consume((HttpEntity)resp.getEntity());
        Assert.assertEquals((long)byteData.length, (long)bytesBack.length);
        ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytesBack));
        TestSerializable ts = (TestSerializable)oin.readObject();
        Assert.assertEquals((Object)"CONTENT", (Object)ts.getContent());
    }

    @Test
    public void testEmptyGet() throws Exception {
        RESTHelper.get(RESTHelper.fullPathKey("nodata"), 404);
    }

    @Test
    public void testGet() throws Exception {
        URI fullPathKey = RESTHelper.fullPathKey("a");
        RESTHelper.post(fullPathKey, "data", "application/text");
        HttpResponse resp = RESTHelper.get(fullPathKey, "data");
        Assert.assertNotNull((Object)resp.getHeaders("ETag")[0].getValue());
        Assert.assertNotNull((Object)resp.getHeaders("Last-Modified")[0].getValue());
        Assert.assertEquals((Object)"application/text", (Object)resp.getHeaders("Content-Type")[0].getValue());
    }

    @Test
    public void testGetNamedCache() throws Exception {
        URI fullPathKey = RESTHelper.fullPathKey(DEFAULT_NAMED_CACHE, "a");
        RESTHelper.post(fullPathKey, "data", "application/text");
        HttpResponse resp = RESTHelper.get(fullPathKey, "data");
        Assert.assertNotNull((Object)resp.getHeaders("ETag")[0].getValue());
        Assert.assertNotNull((Object)resp.getHeaders("Last-Modified")[0].getValue());
        Assert.assertEquals((Object)"application/text", (Object)resp.getHeaders("Content-Type")[0].getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHead() throws Exception {
        URI fullPathKey = RESTHelper.fullPathKey("a");
        RESTHelper.post(fullPathKey, "data", "application/text");
        HttpResponse resp = null;
        try {
            resp = RESTHelper.headWithoutClose(fullPathKey);
            Assert.assertNotNull((Object)resp.getHeaders("ETag")[0].getValue());
            Assert.assertNotNull((Object)resp.getHeaders("Last-Modified")[0].getValue());
            Assert.assertEquals((Object)"application/text", (Object)resp.getHeaders("Content-Type")[0].getValue());
            Assert.assertNull((Object)resp.getEntity());
        }
        finally {
            EntityUtils.consume((HttpEntity)resp.getEntity());
        }
    }

    @Test
    public void testPostDuplicate() throws Exception {
        URI fullPathKey = RESTHelper.fullPathKey("a");
        RESTHelper.post(fullPathKey, "data", "application/text");
        RESTHelper.post(fullPathKey, "data", "application/text", 409);
        RESTHelper.put(fullPathKey, "data", "application/text");
    }

    @Test
    public void testPutDataWithTimeToLive() throws Exception {
        URI fullPathKey = RESTHelper.fullPathKey("a");
        RESTHelper.post(fullPathKey, "data", "application/text", 200, "Content-Type", "application/text", "timeToLiveSeconds", "2");
        RESTHelper.get(fullPathKey, "data");
        ITestUtils.sleepForSecs(2.1);
        RESTHelper.head(fullPathKey, 404);
    }

    @Test
    public void testPutDataWithMaxIdleTime() throws Exception {
        URI fullPathKey = RESTHelper.fullPathKey("a");
        RESTHelper.post(fullPathKey, "data", "application/text", 200, "Content-Type", "application/text", "maxIdleTimeSeconds", "2");
        RESTHelper.get(fullPathKey, "data");
        for (int i = 1; i < 3; ++i) {
            ITestUtils.sleepForSecs(1.0);
            RESTHelper.head(fullPathKey);
        }
        ITestUtils.sleepForSecs(2.1);
        RESTHelper.head(fullPathKey, 404);
    }

    @Test
    public void testPutDataTTLMaxIdleCombo1() throws Exception {
        URI fullPathKey = RESTHelper.fullPathKey("a");
        RESTHelper.post(fullPathKey, "data", "application/text", 200, "Content-Type", "application/text", "timeToLiveSeconds", "10", "maxIdleTimeSeconds", "2");
        RESTHelper.get(fullPathKey, "data");
        for (int i = 1; i < 3; ++i) {
            ITestUtils.sleepForSecs(1.0);
            RESTHelper.head(fullPathKey);
        }
        ITestUtils.sleepForSecs(2.1);
        RESTHelper.head(fullPathKey, 404);
    }

    @Test
    public void testPutDataTTLMaxIdleCombo2() throws Exception {
        URI fullPathKey = RESTHelper.fullPathKey("a");
        RESTHelper.post(fullPathKey, "data", "application/text", 200, "Content-Type", "application/text", "timeToLiveSeconds", "2", "maxIdleTimeSeconds", "10");
        RESTHelper.get(fullPathKey, "data");
        ITestUtils.sleepForSecs(2.1);
        RESTHelper.head(fullPathKey, 404);
    }

    @Test
    public void testRemoveEntry() throws Exception {
        URI fullPathKey = RESTHelper.fullPathKey("a");
        RESTHelper.post(fullPathKey, "data", "application/text");
        RESTHelper.head(fullPathKey);
        RESTHelper.delete(fullPathKey);
        RESTHelper.head(fullPathKey, 404);
    }

    @Test
    public void testWipeCacheBucket() throws Exception {
        RESTHelper.post(RESTHelper.fullPathKey("a"), "data", "application/text");
        RESTHelper.post(RESTHelper.fullPathKey("b"), "data", "application/text");
        RESTHelper.head(RESTHelper.fullPathKey("a"));
        RESTHelper.head(RESTHelper.fullPathKey("b"));
        RESTHelper.delete(RESTHelper.fullPathKey(null));
        RESTHelper.head(RESTHelper.fullPathKey("a"), 404);
        RESTHelper.head(RESTHelper.fullPathKey("b"), 404);
    }

    @Test
    public void testPutUnknownClass() throws Exception {
        URI fullPathKey = RESTHelper.fullPathKey("x");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        oo.writeObject(new TestSerializable("CONTENT"));
        oo.flush();
        byte[] byteData = bout.toByteArray();
        RESTHelper.put(fullPathKey, byteData, "application/x-java-serialized-object");
        HttpResponse resp = RESTHelper.get(fullPathKey, null, 200, false, "Accept", "application/x-java-serialized-object");
        int respLength = new Long(resp.getEntity().getContentLength()).intValue();
        byte[] bytesBack = new byte[respLength];
        resp.getEntity().getContent().read(bytesBack, 0, respLength);
        EntityUtils.consume((HttpEntity)resp.getEntity());
        Assert.assertEquals((long)byteData.length, (long)bytesBack.length);
        ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytesBack));
        TestSerializable ts = (TestSerializable)oin.readObject();
        Assert.assertEquals((Object)"CONTENT", (Object)ts.getContent());
    }

    @Test
    public void testPutKnownClass() throws Exception {
        URI fullPathKey = RESTHelper.fullPathKey("y");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        Integer i1 = 42;
        oo.writeObject(i1);
        oo.flush();
        byte[] byteData = bout.toByteArray();
        RESTHelper.put(fullPathKey, byteData, "application/x-java-serialized-object");
        HttpResponse resp = RESTHelper.get(fullPathKey, null, 200, false, "Accept", "application/x-java-serialized-object");
        int respLength = new Long(resp.getEntity().getContentLength()).intValue();
        byte[] bytesBack = new byte[respLength];
        resp.getEntity().getContent().read(bytesBack, 0, respLength);
        EntityUtils.consume((HttpEntity)resp.getEntity());
        Assert.assertEquals((long)byteData.length, (long)bytesBack.length);
        ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytesBack));
        Integer i2 = (Integer)oin.readObject();
        Assert.assertEquals((Object)i1, (Object)i2);
    }

    @Test
    public void testETagChanges() throws Exception {
        URI fullPathKey = RESTHelper.fullPathKey("a");
        RESTHelper.put(fullPathKey, "data1", "application/text");
        String eTagFirst = RESTHelper.get(fullPathKey).getHeaders("ETag")[0].getValue();
        Assert.assertEquals((Object)eTagFirst, (Object)RESTHelper.get(fullPathKey).getHeaders("ETag")[0].getValue());
        RESTHelper.put(fullPathKey, "data2", "application/text");
        Assert.assertFalse((boolean)eTagFirst.equals(RESTHelper.get(fullPathKey).getHeaders("ETag")[0].getValue()));
    }

    @Test
    public void testXJavaSerializedObjectPutAndDelete() throws Exception {
        URI fullPathKey1 = RESTHelper.fullPathKey("j");
        RESTHelper.put(fullPathKey1, "data1", "application/text");
        RESTHelper.head(fullPathKey1, 200);
        RESTHelper.delete(fullPathKey1);
        RESTHelper.head(fullPathKey1, 404);
        URI fullPathKey2 = RESTHelper.fullPathKey("k");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        Integer i1 = 42;
        oo.writeObject(i1);
        oo.flush();
        byte[] byteData = bout.toByteArray();
        RESTHelper.put(fullPathKey2, byteData, "application/x-java-serialized-object");
        RESTHelper.head(fullPathKey2, 200);
        RESTHelper.delete(fullPathKey2);
        RESTHelper.head(fullPathKey2, 404);
    }

    @Test
    public void testIfModifiedSince() throws Exception {
        URI fullPathKey = RESTHelper.fullPathKey("a");
        RESTHelper.put(fullPathKey, "data", "application/text");
        HttpResponse resp = RESTHelper.get(fullPathKey);
        String dateLast = resp.getHeaders("Last-Modified")[0].getValue();
        String dateMinus = RESTHelper.addDay(dateLast, -1);
        String datePlus = RESTHelper.addDay(dateLast, 1);
        RESTHelper.get(fullPathKey, "data", 200, true, "If-Modified-Since", dateMinus);
        RESTHelper.get(fullPathKey, null, 304, true, "If-Modified-Since", dateLast);
        RESTHelper.get(fullPathKey, null, 304, true, "If-Modified-Since", datePlus);
    }

    @Test
    public void testIfUnmodifiedSince() throws Exception {
        URI fullPathKey = RESTHelper.fullPathKey("a");
        RESTHelper.put(fullPathKey, "data", "application/text");
        HttpResponse resp = RESTHelper.get(fullPathKey);
        String dateLast = resp.getHeaders("Last-Modified")[0].getValue();
        String dateMinus = RESTHelper.addDay(dateLast, -1);
        String datePlus = RESTHelper.addDay(dateLast, 1);
        RESTHelper.get(fullPathKey, "data", 200, true, "If-Unmodified-Since", dateLast);
        RESTHelper.get(fullPathKey, "data", 200, true, "If-Unmodified-Since", datePlus);
        RESTHelper.get(fullPathKey, null, 412, true, "If-Unmodified-Since", dateMinus);
    }

    @Test
    public void testIfNoneMatch() throws Exception {
        URI fullPathKey = RESTHelper.fullPathKey("a");
        RESTHelper.put(fullPathKey, "data", "application/text");
        HttpResponse resp = RESTHelper.get(fullPathKey);
        String eTag = resp.getHeaders("ETag")[0].getValue();
        RESTHelper.get(fullPathKey, null, 304, true, "If-None-Match", eTag);
        RESTHelper.get(fullPathKey, "data", 200, true, "If-None-Match", eTag + "garbage");
    }

    @Test
    public void testIfMatch() throws Exception {
        URI fullPathKey = RESTHelper.fullPathKey("a");
        RESTHelper.put(fullPathKey, "data", "application/text");
        HttpResponse resp = RESTHelper.get(fullPathKey);
        String eTag = resp.getHeaders("ETag")[0].getValue();
        RESTHelper.get(fullPathKey, "data", 200, true, "If-Match", eTag);
        RESTHelper.get(fullPathKey, null, 412, true, "If-Match", eTag + "garbage");
        RESTHelper.head(fullPathKey, 200, new String[][]{{"If-Match", eTag}});
        RESTHelper.head(fullPathKey, 412, new String[][]{{"If-Match", eTag + "garbage"}});
    }

    @Test
    public void testNonExistentCache() throws Exception {
        RESTHelper.head(RESTHelper.fullPathKey("nonexistentcache", "nodata"), 404);
        RESTHelper.get(RESTHelper.fullPathKey("nonexistentcache", "nodata"), 404);
    }

    @Test
    public void testByteArrayStorage() throws Exception {
        String KEY_Z = "z";
        byte[] data = "data".getBytes("UTF-8");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        oo.writeObject(data);
        oo.flush();
        byte[] serializedData = bout.toByteArray();
        RESTHelper.put(RESTHelper.fullPathKey(0, "z"), serializedData, "application/x-java-serialized-object");
        HttpResponse resp = RESTHelper.get(RESTHelper.fullPathKey(0, "z"), null, 200, false, "Accept", "application/x-java-serialized-object");
        int respLength = new Long(resp.getEntity().getContentLength()).intValue();
        byte[] serializedDataBack = new byte[respLength];
        resp.getEntity().getContent().read(serializedDataBack, 0, respLength);
        EntityUtils.consume((HttpEntity)resp.getEntity());
        Assert.assertTrue((boolean)Arrays.equals(serializedData, serializedDataBack));
        ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(serializedDataBack));
        byte[] dataBack = (byte[])oin.readObject();
        Assert.assertTrue((boolean)Arrays.equals(data, dataBack));
    }

    @Test
    public void testStoreBigObject() throws Exception {
        byte data;
        int SIZE = 3000000;
        byte[] bytes = new byte[SIZE];
        for (int i = 0; i < SIZE; ++i) {
            bytes[i] = (byte)(i % 10);
        }
        RESTHelper.put(RESTHelper.fullPathKey("object"), bytes, "application/octet-stream");
        HttpResponse resp = RESTHelper.getWithoutClose(RESTHelper.fullPathKey("object"));
        InputStream responseStream = resp.getEntity().getContent();
        byte[] response = new byte[SIZE];
        int j = 0;
        while ((data = (byte)responseStream.read()) != -1) {
            response[j] = data;
            ++j;
        }
        boolean correct = true;
        for (int i = 0; i < SIZE; ++i) {
            if (bytes[i] == response[i]) continue;
            correct = false;
        }
        EntityUtils.consume((HttpEntity)resp.getEntity());
        Assert.assertTrue((boolean)correct);
    }

    @Test
    public void testKeyIncludingSlashURLEncoded() throws Exception {
        String encodedSlashKey = URLEncoder.encode("x/y", "UTF-8");
        RESTHelper.post(RESTHelper.fullPathKey(encodedSlashKey), "data", "application/text");
        HttpResponse get = RESTHelper.get(RESTHelper.fullPathKey(encodedSlashKey), "data");
        Assert.assertNotNull((Object)get.getHeaders("ETag")[0].getValue());
        Assert.assertNotNull((Object)get.getHeaders("Last-Modified")[0].getValue());
        Assert.assertEquals((Object)"application/text", (Object)get.getHeaders("Content-Type")[0].getValue());
    }

    public static class TestSerializable
    implements Serializable {
        private String content;

        public TestSerializable(String content) {
            this.content = content;
        }

        public String getContent() {
            return this.content;
        }
    }
}

