/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.cs.file;

import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.server.test.category.CacheStore;
import org.infinispan.server.test.util.RemoteCacheManagerFactory;
import org.infinispan.server.test.util.RemoteInfinispanMBeans;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={CacheStore.class})
public class FileCacheStoreIT {
    final String CONTAINER = "standalone-filecs";
    @InfinispanResource(value="standalone-filecs")
    RemoteInfinispanServer server;
    @ArquillianResource
    ContainerController controller;

    @Test
    public void testSurviveRestart() throws Exception {
        RemoteCacheManagerFactory rcmFactory = new RemoteCacheManagerFactory();
        RemoteInfinispanMBeans s = RemoteInfinispanMBeans.create(this.server, "standalone-filecs", "default", "local");
        this.controller.start("standalone-filecs");
        RemoteCache<Object, Object> rc = rcmFactory.createCache(s);
        rc.clear();
        Assert.assertNull((Object)rc.get((Object)"k1"));
        rc.put((Object)"k1", (Object)"v1");
        rc.put((Object)"k2", (Object)"v2");
        rc.put((Object)"k3", (Object)"v3");
        Assert.assertEquals((Object)"v1", (Object)rc.get((Object)"k1"));
        Assert.assertEquals((Object)"v2", (Object)rc.get((Object)"k2"));
        Assert.assertEquals((Object)"v3", (Object)rc.get((Object)"k3"));
        this.controller.kill("standalone-filecs");
        this.controller.start("standalone-filecs");
        Assert.assertEquals((Object)"v2", (Object)rc.get((Object)"k2"));
        Assert.assertEquals((Object)"v3", (Object)rc.get((Object)"k3"));
        Assert.assertNull((Object)rc.get((Object)"k1"));
        this.controller.stop("standalone-filecs");
        rcmFactory.stopManagers();
    }
}

