/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.cs.jdbc;

import java.io.IOException;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.util.Base64;
import org.infinispan.server.test.client.memcached.MemcachedClient;
import org.infinispan.server.test.util.ITestUtils;
import org.infinispan.server.test.util.RemoteCacheManagerFactory;
import org.infinispan.server.test.util.RemoteInfinispanMBeans;
import org.infinispan.server.test.util.jdbc.DBServer;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class SingleNodeJdbcStoreIT {
    public final String CONTAINER = "jdbc";
    @ArquillianResource
    protected ContainerController controller;
    @InfinispanResource(value="jdbc")
    protected RemoteInfinispanServer server;
    public final String ID_COLUMN_NAME = "id";
    public final String DATA_COLUMN_NAME = "datum";
    public static RemoteCacheManagerFactory rcmFactory;
    static DBServer stringDB;
    static DBServer stringWPDB;
    static DBServer binaryDB;
    static DBServer binaryWPDB;
    static DBServer mixedDB;
    static DBServer mixedWPDB;
    static DBServer stringAsyncDB;
    static RemoteInfinispanMBeans stringMBeans;
    static RemoteInfinispanMBeans stringWPMBeans;
    static RemoteInfinispanMBeans binaryMBeans;
    static RemoteInfinispanMBeans binaryWPMBeans;
    static RemoteInfinispanMBeans mixedMBeans;
    static RemoteInfinispanMBeans mixedWPMBeans;
    static RemoteCache stringCache;
    static RemoteCache stringWPCache;
    static RemoteCache binaryCache;
    static RemoteCache binaryWPCache;
    static RemoteCache mixedCache;
    static RemoteCache mixedWPCache;

    @BeforeClass
    public static void startup() {
        rcmFactory = new RemoteCacheManagerFactory();
    }

    @AfterClass
    public static void cleanup() {
        DBServer[] dbservers;
        for (DBServer dbServer : dbservers = new DBServer[]{stringDB, stringWPDB, binaryDB, binaryWPDB, mixedDB, mixedWPDB, stringAsyncDB}) {
            try {
                if (!dbServer.bucketTable.getConnectionUrl().contains("db2")) continue;
                if (dbServer.bucketTable != null) {
                    dbServer.bucketTable.dropTable();
                }
                if (dbServer.stringTable == null) continue;
                dbServer.stringTable.dropTable();
            }
            catch (Exception e) {
                System.out.println("Couldn't drop the tables: ");
                e.printStackTrace();
            }
        }
        if (rcmFactory != null) {
            rcmFactory.stopManagers();
        }
        rcmFactory = null;
    }

    @Before
    public void setUp() throws Exception {
        if (stringDB == null) {
            stringMBeans = ITestUtils.createMBeans(this.server, "jdbc", "stringWithPassivation", "local");
            stringCache = this.createCache(stringMBeans);
            stringDB = new DBServer(null, "STRING_WITH_PASSIVATION_" + SingleNodeJdbcStoreIT.stringMBeans.cacheName, "id", "datum");
            stringWPMBeans = ITestUtils.createMBeans(this.server, "jdbc", "stringNoPassivation", "local");
            stringWPCache = this.createCache(stringWPMBeans);
            stringWPDB = new DBServer(null, "STRING_NO_PASSIVATION_" + SingleNodeJdbcStoreIT.stringWPMBeans.cacheName, "id", "datum");
            binaryMBeans = ITestUtils.createMBeans(this.server, "jdbc", "binaryWithPassivation", "local");
            binaryCache = this.createCache(binaryMBeans);
            binaryDB = new DBServer("BINARY_WITH_PASSIVATION_" + SingleNodeJdbcStoreIT.binaryMBeans.cacheName, null, "id", "datum");
            binaryWPMBeans = ITestUtils.createMBeans(this.server, "jdbc", "binaryNoPassivation", "local");
            binaryWPCache = this.createCache(binaryWPMBeans);
            binaryWPDB = new DBServer("BINARY_NO_PASSIVATION_" + SingleNodeJdbcStoreIT.binaryWPMBeans.cacheName, null, "id", "datum");
            mixedMBeans = ITestUtils.createMBeans(this.server, "jdbc", "mixedWithPassivation", "local");
            mixedCache = this.createCache(mixedMBeans);
            mixedDB = new DBServer("MIXED_WITH_PASSIVATION_BKT_" + SingleNodeJdbcStoreIT.mixedMBeans.cacheName, "MIXED_WITH_PASSIVATION_STR_" + SingleNodeJdbcStoreIT.mixedMBeans.cacheName, "id", "datum");
            mixedWPMBeans = ITestUtils.createMBeans(this.server, "jdbc", "mixedNoPassivation", "local");
            mixedWPCache = this.createCache(mixedWPMBeans);
            mixedWPDB = new DBServer("MIXED_NO_PASSIVATION_BKT_" + SingleNodeJdbcStoreIT.mixedWPMBeans.cacheName, "MIXED_NO_PASSIVATION_STR_" + SingleNodeJdbcStoreIT.mixedWPMBeans.cacheName, "id", "datum");
            stringAsyncDB = new DBServer(null, "STRING_ASYNC_memcachedCache", "id", "datum");
        }
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="jdbc")})
    public void testNormalShutdown() throws Exception {
        this.testRestartStringStoreBefore();
        this.testRestartBinaryStoreBefore();
        this.testRestartMixedStoreBefore();
        this.testRestartStringStoreWPBefore();
        this.testRestartBinaryStoreWPBefore();
        this.testRestartMixedStoreWPBefore();
        this.controller.stop("jdbc");
        this.controller.start("jdbc");
        this.testRestartStringStoreAfter(false);
        this.testRestartBinaryStoreAfter(false);
        this.testRestartMixedStoreAfter(false);
        this.testRestartStringStoreWPAfter();
        this.testRestartBinaryStoreWPAfter();
        this.testRestartMixedStoreWPAfter();
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="jdbc")})
    public void testForcedShutdown() throws Exception {
        this.testRestartStringStoreBefore();
        this.testRestartBinaryStoreBefore();
        this.testRestartMixedStoreBefore();
        this.testRestartStringStoreWPBefore();
        this.testRestartBinaryStoreWPBefore();
        this.testRestartMixedStoreWPBefore();
        this.controller.kill("jdbc");
        this.controller.start("jdbc");
        this.testRestartStringStoreAfter(true);
        this.testRestartBinaryStoreAfter(true);
        this.testRestartMixedStoreAfter(true);
        this.testRestartStringStoreWPAfter();
        this.testRestartBinaryStoreWPAfter();
        this.testRestartMixedStoreWPAfter();
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="jdbc")})
    public void testAsyncStringStore() throws Exception {
        int i;
        MemcachedClient mc = ITestUtils.createMemcachedClient(this.server);
        int numEntries = 1000;
        for (i = 0; i != numEntries; ++i) {
            mc.set("key" + i, "value" + i);
        }
        ITestUtils.eventually(new ITestUtils.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return SingleNodeJdbcStoreIT.stringAsyncDB.stringTable.exists();
            }
        }, 10000L);
        for (i = 0; i != numEntries; ++i) {
            Assert.assertNotNull((String)("key" + i + " was not found in DB in " + 15000L + " ms"), (Object)SingleNodeJdbcStoreIT.stringAsyncDB.stringTable.getValueByKeyAwait("key" + i));
        }
        for (i = 0; i != numEntries; ++i) {
            mc.delete("key" + i);
        }
        ITestUtils.eventually(new ITestUtils.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return SingleNodeJdbcStoreIT.stringAsyncDB.stringTable.getAllRows().isEmpty();
            }
        }, 10000L);
    }

    public void testRestartStringStoreBefore() throws Exception {
        this.assertCleanCacheAndStoreHotrod(stringCache, SingleNodeJdbcStoreIT.stringDB.stringTable);
        stringCache.put((Object)"k1", (Object)"v1");
        stringCache.put((Object)"k2", (Object)"v2");
        Assert.assertTrue((!SingleNodeJdbcStoreIT.stringDB.stringTable.exists() || SingleNodeJdbcStoreIT.stringDB.stringTable.getValueByKey(this.getStoredKey(stringCache, "k1")) == null ? 1 : 0) != 0);
        Assert.assertTrue((!SingleNodeJdbcStoreIT.stringDB.stringTable.exists() || SingleNodeJdbcStoreIT.stringDB.stringTable.getValueByKey(this.getStoredKey(stringCache, "k2")) == null ? 1 : 0) != 0);
        stringCache.put((Object)"k3", (Object)"v3");
        Assert.assertTrue((2L >= this.server.getCacheManager(SingleNodeJdbcStoreIT.stringMBeans.managerName).getCache(SingleNodeJdbcStoreIT.stringMBeans.cacheName).getNumberOfEntries() ? 1 : 0) != 0);
        Assert.assertNotNull((Object)SingleNodeJdbcStoreIT.stringDB.stringTable.getValueByKey(this.getStoredKey(stringCache, "k1")));
    }

    public void testRestartStringStoreAfter(boolean killed) throws Exception {
        Assert.assertEquals((long)0L, (long)this.server.getCacheManager(SingleNodeJdbcStoreIT.stringMBeans.managerName).getCache(SingleNodeJdbcStoreIT.stringMBeans.cacheName).getNumberOfEntries());
        Assert.assertNotNull((Object)SingleNodeJdbcStoreIT.stringDB.stringTable.getValueByKey(this.getStoredKey(stringCache, "k1")));
        if (killed) {
            Assert.assertEquals((long)1L, (long)SingleNodeJdbcStoreIT.stringDB.stringTable.getAllRows().size());
            Assert.assertEquals((Object)"v1", (Object)stringCache.get((Object)"k1"));
            Assert.assertNull((Object)SingleNodeJdbcStoreIT.stringDB.stringTable.getValueByKey(this.getStoredKey(stringCache, "k1")));
            Assert.assertNull((Object)stringCache.get((Object)"k2"));
            Assert.assertNull((Object)stringCache.get((Object)"k3"));
        } else {
            Assert.assertEquals((long)3L, (long)SingleNodeJdbcStoreIT.stringDB.stringTable.getAllRows().size());
            Assert.assertEquals((Object)"v1", (Object)stringCache.get((Object)"k1"));
            Assert.assertEquals((Object)"v2", (Object)stringCache.get((Object)"k2"));
            Assert.assertEquals((Object)"v3", (Object)stringCache.get((Object)"k3"));
            Assert.assertNull((Object)SingleNodeJdbcStoreIT.stringDB.stringTable.getValueByKey(this.getStoredKey(stringCache, "k3")));
        }
    }

    public void testRestartBinaryStoreBefore() throws Exception {
        String key1 = "key1";
        String key2 = "anotherExtraUniqueKey";
        String key3 = "key3";
        this.assertCleanCacheAndStoreHotrod(binaryCache, SingleNodeJdbcStoreIT.binaryDB.bucketTable);
        binaryCache.put((Object)key1, (Object)"v1");
        binaryCache.put((Object)key2, (Object)"v2");
        Assert.assertTrue((!SingleNodeJdbcStoreIT.binaryDB.bucketTable.exists() || SingleNodeJdbcStoreIT.binaryDB.bucketTable.getAllRows().isEmpty() ? 1 : 0) != 0);
        binaryCache.put((Object)key3, (Object)"v3");
        Assert.assertTrue((2L >= this.server.getCacheManager(SingleNodeJdbcStoreIT.binaryMBeans.managerName).getCache(SingleNodeJdbcStoreIT.binaryMBeans.cacheName).getNumberOfEntries() ? 1 : 0) != 0);
        byte[] k1Stored = ITestUtils.getRealKeyStored(key1, binaryCache);
        Assert.assertTrue((!SingleNodeJdbcStoreIT.binaryDB.bucketTable.getAllRows().isEmpty() ? 1 : 0) != 0);
        Assert.assertNotNull((Object)SingleNodeJdbcStoreIT.binaryDB.bucketTable.getBucketByKey(k1Stored));
    }

    public void testRestartBinaryStoreAfter(boolean killed) throws Exception {
        String key1 = "key1";
        String key2 = "anotherExtraUniqueKey";
        String key3 = "key3";
        byte[] k1Stored = ITestUtils.getRealKeyStored(key1, binaryCache);
        byte[] k3Stored = ITestUtils.getRealKeyStored(key3, binaryCache);
        Assert.assertEquals((long)0L, (long)this.server.getCacheManager(SingleNodeJdbcStoreIT.binaryMBeans.managerName).getCache(SingleNodeJdbcStoreIT.binaryMBeans.cacheName).getNumberOfEntries());
        Assert.assertNotNull((Object)SingleNodeJdbcStoreIT.binaryDB.bucketTable.getBucketByKey(k1Stored));
        if (killed) {
            Assert.assertEquals((long)1L, (long)SingleNodeJdbcStoreIT.binaryDB.bucketTable.getAllRows().size());
            Assert.assertEquals((Object)"v1", (Object)binaryCache.get((Object)key1));
            Assert.assertNull((Object)binaryCache.get((Object)key2));
            Assert.assertNull((Object)binaryCache.get((Object)key3));
        } else {
            Assert.assertTrue((SingleNodeJdbcStoreIT.binaryDB.bucketTable.getAllRows().size() >= 2 ? 1 : 0) != 0);
            Assert.assertEquals((Object)"v1", (Object)binaryCache.get((Object)key1));
            Assert.assertEquals((Object)"v2", (Object)binaryCache.get((Object)key2));
            Assert.assertEquals((Object)"v3", (Object)binaryCache.get((Object)key3));
        }
    }

    public void testRestartMixedStoreBefore() throws Exception {
        this.assertCleanCacheAndStoreHotrod(mixedCache, SingleNodeJdbcStoreIT.mixedDB.stringTable);
        this.assertCleanCacheAndStoreHotrod(mixedCache, SingleNodeJdbcStoreIT.mixedDB.bucketTable);
        mixedCache.put((Object)"k1", (Object)"v1");
        mixedCache.put((Object)"k2", (Object)"v2");
        Assert.assertTrue((!SingleNodeJdbcStoreIT.mixedDB.stringTable.exists() || SingleNodeJdbcStoreIT.mixedDB.stringTable.getAllRows().isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((!SingleNodeJdbcStoreIT.mixedDB.bucketTable.exists() || SingleNodeJdbcStoreIT.mixedDB.bucketTable.getAllRows().isEmpty() ? 1 : 0) != 0);
        mixedCache.put((Object)"k3", (Object)"v3");
        Assert.assertEquals((long)2L, (long)this.server.getCacheManager(SingleNodeJdbcStoreIT.mixedMBeans.managerName).getCache(SingleNodeJdbcStoreIT.mixedMBeans.cacheName).getNumberOfEntries());
        Assert.assertEquals((long)1L, (long)SingleNodeJdbcStoreIT.mixedDB.stringTable.getAllRows().size());
        Assert.assertTrue((!SingleNodeJdbcStoreIT.mixedDB.bucketTable.exists() || SingleNodeJdbcStoreIT.mixedDB.bucketTable.getAllRows().isEmpty() ? 1 : 0) != 0);
    }

    public void testRestartMixedStoreAfter(boolean killed) throws Exception {
        Assert.assertEquals((long)0L, (long)this.server.getCacheManager(SingleNodeJdbcStoreIT.mixedMBeans.managerName).getCache(SingleNodeJdbcStoreIT.mixedMBeans.cacheName).getNumberOfEntries());
        Assert.assertTrue((boolean)SingleNodeJdbcStoreIT.mixedDB.bucketTable.getAllRows().isEmpty());
        Assert.assertNotNull((Object)SingleNodeJdbcStoreIT.mixedDB.stringTable.getValueByKey(this.getStoredKey(mixedCache, "k1")));
        if (killed) {
            Assert.assertEquals((long)1L, (long)SingleNodeJdbcStoreIT.mixedDB.stringTable.getAllRows().size());
            Assert.assertEquals((Object)"v1", (Object)mixedCache.get((Object)"k1"));
            Assert.assertNull((Object)SingleNodeJdbcStoreIT.mixedDB.stringTable.getValueByKey(this.getStoredKey(mixedCache, "k1")));
            Assert.assertNull((Object)mixedCache.get((Object)"k2"));
            Assert.assertNull((Object)mixedCache.get((Object)"k3"));
        } else {
            Assert.assertEquals((long)3L, (long)SingleNodeJdbcStoreIT.mixedDB.stringTable.getAllRows().size());
            Assert.assertEquals((Object)"v1", (Object)mixedCache.get((Object)"k1"));
            Assert.assertEquals((Object)"v2", (Object)mixedCache.get((Object)"k2"));
            Assert.assertEquals((Object)"v3", (Object)mixedCache.get((Object)"k3"));
            Assert.assertNull((Object)SingleNodeJdbcStoreIT.mixedDB.stringTable.getValueByKey(this.getStoredKey(mixedCache, "k3")));
        }
    }

    public void testRestartStringStoreWPBefore() throws Exception {
        this.assertCleanCacheAndStoreHotrod(stringWPCache, SingleNodeJdbcStoreIT.stringWPDB.stringTable);
        stringWPCache.put((Object)"k1", (Object)"v1");
        stringWPCache.put((Object)"k2", (Object)"v2");
        Assert.assertNotNull((Object)SingleNodeJdbcStoreIT.stringWPDB.stringTable.getValueByKey(this.getStoredKey(stringWPCache, "k1")));
        Assert.assertNotNull((Object)SingleNodeJdbcStoreIT.stringWPDB.stringTable.getValueByKey(this.getStoredKey(stringWPCache, "k2")));
    }

    public void testRestartStringStoreWPAfter() throws Exception {
        ITestUtils.eventually(new ITestUtils.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return 2L == SingleNodeJdbcStoreIT.this.server.getCacheManager(SingleNodeJdbcStoreIT.stringWPMBeans.managerName).getCache(SingleNodeJdbcStoreIT.stringWPMBeans.cacheName).getNumberOfEntries();
            }
        }, 10000L);
        Assert.assertEquals((Object)"v1", (Object)stringWPCache.get((Object)"k1"));
        Assert.assertEquals((Object)"v2", (Object)stringWPCache.get((Object)"k2"));
        stringWPCache.remove((Object)"k1");
        Assert.assertNull((Object)SingleNodeJdbcStoreIT.stringWPDB.stringTable.getValueByKey(this.getStoredKey(stringWPCache, "k1")));
        Assert.assertNotNull((Object)SingleNodeJdbcStoreIT.stringWPDB.stringTable.getValueByKey(this.getStoredKey(stringWPCache, "k2")));
    }

    public void testRestartBinaryStoreWPBefore() throws Exception {
        String key1 = "key1";
        String key2 = "myBestPersonalKeyWhichHasNeverBeenBetter";
        this.assertCleanCacheAndStoreHotrod(binaryWPCache, SingleNodeJdbcStoreIT.binaryWPDB.bucketTable);
        binaryWPCache.put((Object)key1, (Object)"v1");
        binaryWPCache.put((Object)key2, (Object)"v2");
        byte[] k1Stored = ITestUtils.getRealKeyStored(key1, binaryWPCache);
        byte[] k2Stored = ITestUtils.getRealKeyStored(key2, binaryWPCache);
        SingleNodeJdbcStoreIT.binaryWPDB.bucketTable.waitForTableCreation();
        Assert.assertEquals((long)2L, (long)SingleNodeJdbcStoreIT.binaryWPDB.bucketTable.getAllRows().size());
        Assert.assertNotNull((Object)SingleNodeJdbcStoreIT.binaryWPDB.bucketTable.getBucketByKey(k1Stored));
        Assert.assertNotNull((Object)SingleNodeJdbcStoreIT.binaryWPDB.bucketTable.getBucketByKey(k2Stored));
    }

    public void testRestartBinaryStoreWPAfter() throws Exception {
        String key1 = "key1";
        String key2 = "myBestPersonalKeyWhichHasNeverBeenBetter";
        byte[] k1Stored = ITestUtils.getRealKeyStored(key1, binaryWPCache);
        byte[] k2Stored = ITestUtils.getRealKeyStored(key2, binaryWPCache);
        ITestUtils.eventually(new ITestUtils.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return 2L == SingleNodeJdbcStoreIT.this.server.getCacheManager(SingleNodeJdbcStoreIT.binaryWPMBeans.managerName).getCache(SingleNodeJdbcStoreIT.binaryWPMBeans.cacheName).getNumberOfEntries();
            }
        }, 10000L);
        Assert.assertEquals((Object)"v1", (Object)binaryWPCache.get((Object)key1));
        Assert.assertEquals((Object)"v2", (Object)binaryWPCache.get((Object)key2));
        Assert.assertEquals((long)2L, (long)SingleNodeJdbcStoreIT.binaryWPDB.bucketTable.getAllRows().size());
        Assert.assertNotNull((Object)SingleNodeJdbcStoreIT.binaryWPDB.bucketTable.getBucketByKey(k1Stored));
        Assert.assertNotNull((Object)SingleNodeJdbcStoreIT.binaryWPDB.bucketTable.getBucketByKey(k2Stored));
    }

    public void testRestartMixedStoreWPBefore() throws Exception {
        this.assertCleanCacheAndStoreHotrod(mixedWPCache, SingleNodeJdbcStoreIT.mixedWPDB.bucketTable);
        this.assertCleanCacheAndStoreHotrod(mixedWPCache, SingleNodeJdbcStoreIT.mixedWPDB.stringTable);
        mixedWPCache.put((Object)"k1", (Object)"v1");
        mixedWPCache.put((Object)"k2", (Object)"v2");
        Assert.assertEquals((long)2L, (long)SingleNodeJdbcStoreIT.mixedWPDB.stringTable.getAllRows().size());
        Assert.assertTrue((!SingleNodeJdbcStoreIT.mixedWPDB.bucketTable.exists() || SingleNodeJdbcStoreIT.mixedWPDB.bucketTable.getAllRows().isEmpty() ? 1 : 0) != 0);
    }

    public void testRestartMixedStoreWPAfter() throws Exception {
        ITestUtils.eventually(new ITestUtils.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return 2L == SingleNodeJdbcStoreIT.this.server.getCacheManager(SingleNodeJdbcStoreIT.mixedWPMBeans.managerName).getCache(SingleNodeJdbcStoreIT.mixedWPMBeans.cacheName).getNumberOfEntries();
            }
        }, 10000L);
        Assert.assertEquals((long)2L, (long)SingleNodeJdbcStoreIT.mixedWPDB.stringTable.getAllRows().size());
        Assert.assertEquals((Object)"v1", (Object)mixedWPCache.get((Object)"k1"));
        Assert.assertEquals((Object)"v2", (Object)mixedWPCache.get((Object)"k2"));
        mixedWPCache.remove((Object)"k2");
        Assert.assertNull((Object)SingleNodeJdbcStoreIT.mixedWPDB.stringTable.getValueByKey(this.getStoredKey(mixedWPCache, "k2")));
    }

    public void assertCleanCacheAndStoreHotrod(RemoteCache cache, final DBServer.TableManipulation table) throws Exception {
        cache.clear();
        if (table.exists() && !table.getAllRows().isEmpty()) {
            table.deleteAllRows();
            ITestUtils.eventually(new ITestUtils.Condition(){

                @Override
                public boolean isSatisfied() throws Exception {
                    return table.getAllRows().isEmpty();
                }
            }, 10000L);
        }
    }

    public String getStoredKey(RemoteCache cache, String key) throws IOException, InterruptedException {
        String base64encoded = "9" + Base64.encodeBytes((byte[])cache.getRemoteCacheManager().getMarshaller().objectToByteBuffer((Object)key));
        byte[] a = new byte[]{-17, -69, -65};
        byte[] b = base64encoded.getBytes();
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return new String(c);
    }

    public RemoteCache<Object, Object> createCache(RemoteInfinispanMBeans mbeans) {
        return rcmFactory.createCache(mbeans);
    }
}

