/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.cs.jdbc.multinode;

import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.server.test.category.CacheStore;
import org.infinispan.server.test.cs.jdbc.AbstractJdbcStoreMultinodeIT;
import org.infinispan.server.test.util.ITestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={CacheStore.class})
public class StringBasedStoreMultinodeIT
extends AbstractJdbcStoreMultinodeIT {
    private final String CONFIG_FETCH_STATE_1 = "testsuite/jdbc-string-multinode-fetch-state1.xml";
    private final String CONFIG_FETCH_STATE_2 = "testsuite/jdbc-string-multinode-fetch-state2.xml";
    private final String CONFIG_SINGLETON_1 = "testsuite/jdbc-string-multinode-singleton1.xml";
    private final String CONFIG_SINGLETON_2 = "testsuite/jdbc-string-multinode-singleton2.xml";
    private static final String MANAGER_NAME = "clustered";
    private final String CACHE_NAME = "memcachedCache";
    private final String TABLE_NAME_PREFIX1 = "STRING_MULTINODEx";
    private final String TABLE_NAME_PREFIX2 = "STRING_MULTINODEy";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @WithRunningServer(value={@RunningServer(name="jdbc-cachestore-1", config="testsuite/jdbc-string-multinode-fetch-state1.xml")})
    public void testFetchState() throws Exception {
        try {
            this.mc1 = ITestUtils.createMemcachedClient(this.server1);
            this.assertCleanCacheAndStore1();
            this.mc1.set("k1", "v1");
            this.mc1.set("k2", "v2");
            this.mc1.set("k3", "v3");
            Assert.assertNotNull((Object)StringBasedStoreMultinodeIT.dbServer1.stringTable.getValueByKey("k1"));
            ITestUtils.startContainer(this.controller, "jdbc-cachestore-2", "testsuite/jdbc-string-multinode-fetch-state2.xml");
            this.mc2 = ITestUtils.createMemcachedClient(this.server2);
            Assert.assertTrue((0L < this.server2.getCacheManager(MANAGER_NAME).getCache("memcachedCache").getNumberOfEntries() ? 1 : 0) != 0);
            Assert.assertNull((Object)StringBasedStoreMultinodeIT.dbServer2.stringTable.getValueByKey("k1"));
            Assert.assertEquals((Object)"v1", (Object)this.mc2.get("k1"));
            Assert.assertEquals((Object)"v2", (Object)this.mc2.get("k2"));
            Assert.assertNull((Object)StringBasedStoreMultinodeIT.dbServer2.stringTable.getValueByKey("k1"));
            Assert.assertNull((Object)StringBasedStoreMultinodeIT.dbServer2.stringTable.getValueByKey("k2"));
            this.assertCleanCacheAndStore2();
        }
        finally {
            this.controller.stop("jdbc-cachestore-2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @WithRunningServer(value={@RunningServer(name="jdbc-cachestore-1", config="testsuite/jdbc-string-multinode-singleton1.xml")})
    public void testSingleton() throws Exception {
        try {
            this.mc1 = ITestUtils.createMemcachedClient(this.server1);
            this.assertCleanCacheAndStore1();
            this.mc1.set("k1", "v1");
            this.mc1.set("k2", "v2");
            Assert.assertEquals((long)2L, (long)StringBasedStoreMultinodeIT.dbServer1.stringTable.getAllRows().size());
            Assert.assertNotNull((Object)StringBasedStoreMultinodeIT.dbServer1.stringTable.getValueByKey("k1"));
            Assert.assertNotNull((Object)StringBasedStoreMultinodeIT.dbServer1.stringTable.getValueByKey("k2"));
            ITestUtils.startContainer(this.controller, "jdbc-cachestore-2", "testsuite/jdbc-string-multinode-singleton2.xml");
            Assert.assertEquals((long)2L, (long)this.server2.getCacheManager(MANAGER_NAME).getCache("memcachedCache").getNumberOfEntries());
            Assert.assertTrue((boolean)StringBasedStoreMultinodeIT.dbServer2.stringTable.getAllRows().isEmpty());
            this.mc2 = ITestUtils.createMemcachedClient(this.server2);
            this.mc2.set("k3", "v3");
            Assert.assertEquals((long)3L, (long)this.server1.getCacheManager(MANAGER_NAME).getCache("memcachedCache").getNumberOfEntries());
            Assert.assertEquals((long)3L, (long)this.server2.getCacheManager(MANAGER_NAME).getCache("memcachedCache").getNumberOfEntries());
            Assert.assertTrue((boolean)StringBasedStoreMultinodeIT.dbServer2.stringTable.getAllRows().isEmpty());
            Assert.assertEquals((long)3L, (long)StringBasedStoreMultinodeIT.dbServer1.stringTable.getAllRows().size());
            this.assertCleanCacheAndStore2();
        }
        finally {
            this.controller.stop("jdbc-cachestore-2");
        }
    }

    private void assertCleanCacheAndStore1() throws Exception {
        this.mc1.delete("k1");
        this.mc1.delete("k2");
        Assert.assertEquals((long)0L, (long)this.server1.getCacheManager(MANAGER_NAME).getCache("memcachedCache").getNumberOfEntries());
        if (StringBasedStoreMultinodeIT.dbServer1.stringTable.exists() && !StringBasedStoreMultinodeIT.dbServer1.stringTable.getAllRows().isEmpty()) {
            StringBasedStoreMultinodeIT.dbServer1.stringTable.deleteAllRows();
            ITestUtils.eventually(new ITestUtils.Condition(){

                @Override
                public boolean isSatisfied() throws Exception {
                    return dbServer1.stringTable.getAllRows().isEmpty();
                }
            }, 10000L);
        }
        Assert.assertNull((Object)StringBasedStoreMultinodeIT.dbServer1.stringTable.getValueByKey("k1"));
        Assert.assertNull((Object)StringBasedStoreMultinodeIT.dbServer1.stringTable.getValueByKey("k2"));
    }

    private void assertCleanCacheAndStore2() throws Exception {
        this.mc2.delete("k1");
        this.mc2.delete("k2");
        this.mc2.delete("k3");
    }

    @Override
    protected void dBServers() {
        StringBasedStoreMultinodeIT.dbServer1.connectionUrl = System.getProperty("connection.url");
        StringBasedStoreMultinodeIT.dbServer1.username = System.getProperty("username");
        StringBasedStoreMultinodeIT.dbServer1.password = System.getProperty("password");
        StringBasedStoreMultinodeIT.dbServer1.bucketTableName = null;
        StringBasedStoreMultinodeIT.dbServer1.stringTableName = "STRING_MULTINODEx_memcachedCache";
        StringBasedStoreMultinodeIT.dbServer2.connectionUrl = System.getProperty("connection.url.other");
        StringBasedStoreMultinodeIT.dbServer2.username = System.getProperty("username.other");
        StringBasedStoreMultinodeIT.dbServer2.password = System.getProperty("password.other");
        StringBasedStoreMultinodeIT.dbServer2.bucketTableName = null;
        StringBasedStoreMultinodeIT.dbServer2.stringTableName = "STRING_MULTINODEy_memcachedCache";
    }

    @Override
    protected String managerName() {
        return MANAGER_NAME;
    }

    @Override
    protected String cacheName() {
        return "memcachedCache";
    }
}

