/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.cs.leveldb;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.model.RemoteInfinispanCache;
import org.infinispan.arquillian.model.RemoteInfinispanCacheManager;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.commons.marshall.AbstractMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.server.test.category.CacheStore;
import org.infinispan.server.test.util.ITestUtils;
import org.infinispan.test.TestingUtil;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.impl.Iq80DBFactory;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={CacheStore.class})
public class LevelDBCacheStoreIT {
    @InfinispanResource(value="leveldb")
    RemoteInfinispanServer server;
    @ArquillianResource
    ContainerController controller;
    public static final String CONTAINER = "leveldb";
    private static File dataDir = new File(ITestUtils.SERVER_DATA_DIR + File.separator + "leveldbtestcache");
    private static File expiredDir = new File(ITestUtils.SERVER_DATA_DIR + File.separator + "leveldb-expiredtestcache");
    private final TestMarshaller clientMarshaller = new TestMarshaller();

    private void removeDataFilesIfExists() {
        if (dataDir.exists()) {
            TestingUtil.recursiveFileRemove((File)dataDir);
        }
        if (expiredDir.exists()) {
            TestingUtil.recursiveFileRemove((File)expiredDir);
        }
    }

    @Test
    public void testDataSurvivesRestart() throws Exception {
        this.removeDataFilesIfExists();
        this.controller.start(CONTAINER);
        RemoteInfinispanCacheManager managerJmx = this.server.getCacheManager("local");
        RemoteInfinispanCache cacheJmx = managerJmx.getCache("testcache");
        RemoteCache cache = this.createManager().getCache();
        cache.clear();
        Assert.assertEquals((long)0L, (long)cacheJmx.getNumberOfEntries());
        cache.put((Object)"key1", (Object)"1");
        cache.put((Object)"key2", (Object)"2");
        cache.put((Object)"key3", (Object)"3");
        Assert.assertEquals((Object)"1", (Object)cache.get((Object)"key1"));
        Assert.assertEquals((Object)"2", (Object)cache.get((Object)"key2"));
        Assert.assertEquals((Object)"3", (Object)cache.get((Object)"key3"));
        System.out.println("Stored via Hot Rod:");
        Assert.assertTrue((boolean)dataDir.exists());
        Assert.assertTrue((boolean)dataDir.isDirectory());
        Assert.assertTrue((boolean)expiredDir.exists());
        Assert.assertTrue((boolean)expiredDir.isDirectory());
        this.controller.stop(CONTAINER);
        this.controller.start(CONTAINER);
        Assert.assertEquals((Object)"1", (Object)cache.get((Object)"key1"));
        Assert.assertEquals((Object)"2", (Object)cache.get((Object)"key2"));
        Assert.assertEquals((Object)"3", (Object)cache.get((Object)"key3"));
        this.controller.stop(CONTAINER);
    }

    @Test
    public void testDataRetrievableViaLevelDbApi() throws Exception {
        this.removeDataFilesIfExists();
        this.controller.start(CONTAINER);
        RemoteInfinispanCacheManager managerJmx = this.server.getCacheManager("local");
        RemoteInfinispanCache cacheJmx = managerJmx.getCache("testcache");
        RemoteCache cache = this.createManager().getCache();
        cache.clear();
        Assert.assertEquals((long)0L, (long)cacheJmx.getNumberOfEntries());
        cache.put((Object)"key1", (Object)"1");
        Assert.assertEquals((Object)"1", (Object)cache.get((Object)"key1"));
        System.out.println("Stored via Hot Rod:");
        Assert.assertTrue((boolean)dataDir.exists());
        Assert.assertTrue((boolean)dataDir.isDirectory());
        Assert.assertTrue((boolean)expiredDir.exists());
        Assert.assertTrue((boolean)expiredDir.isDirectory());
        this.controller.stop(CONTAINER);
        DB db = Iq80DBFactory.factory.open(dataDir, new Options());
        System.out.println("LevelDB file " + dataDir.getAbsolutePath() + " contents:");
        for (Map.Entry entry : db) {
            System.out.println("key \"" + Hex.encodeHexString((byte[])((byte[])entry.getKey())) + "\": value \"" + Hex.encodeHexString((byte[])((byte[])entry.getValue())) + "\"");
            Assert.assertNotNull(entry.getValue());
        }
    }

    private RemoteCacheManager createManager() {
        ConfigurationBuilder cfgBuild = ITestUtils.createConfigBuilder(this.server.getHotrodEndpoint().getInetAddress().getHostName(), this.server.getHotrodEndpoint().getPort());
        cfgBuild.marshaller((Marshaller)this.clientMarshaller);
        return new RemoteCacheManager(cfgBuild.build());
    }

    private static class TestMarshaller
    extends AbstractMarshaller {
        private TestMarshaller() {
        }

        public Object objectFromByteBuffer(byte[] buf, int offset, int length) throws IOException, ClassNotFoundException {
            byte[] bytes = new byte[length];
            System.arraycopy(buf, offset, bytes, 0, length);
            return new String(bytes);
        }

        public boolean isMarshallable(Object o) throws Exception {
            return o instanceof String;
        }

        protected ByteBuffer objectToBuffer(Object o, int estimatedSize) throws IOException, InterruptedException {
            if (o instanceof String) {
                String str = (String)o;
                byte[] bytes = str.getBytes();
                return new ByteBufferImpl(bytes, 0, bytes.length);
            }
            throw new IllegalArgumentException("type not marshallable");
        }
    }
}

