/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.query;

import java.util.List;
import javax.management.ObjectName;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.Search;
import org.infinispan.protostream.sampledomain.User;
import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.server.test.category.Queries;
import org.infinispan.server.test.query.RemoteQueryBaseIT;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@Category(value={Queries.class})
@RunWith(value=Arquillian.class)
public class ManualIndexingIT
extends RemoteQueryBaseIT {
    private static final String CACHE_CONTAINER_NAME = "clustered";
    private static final String CACHE_NAME = "localtestcache_manual";
    @InfinispanResource(value="remote-query")
    protected RemoteInfinispanServer server;

    public ManualIndexingIT() {
        super(CACHE_CONTAINER_NAME, CACHE_NAME);
    }

    @Override
    public RemoteInfinispanServer getServer() {
        return this.server;
    }

    @Test
    public void testManualIndexing() throws Exception {
        QueryBuilder qb = Search.getQueryFactory((RemoteCache)this.remoteCache).from(User.class).having("name").eq((Object)"Tom").toBuilder();
        User user = new User();
        user.setId(1);
        user.setName("Tom");
        user.setSurname("Cat");
        user.setGender(User.Gender.MALE);
        this.remoteCache.put((Object)1, (Object)user);
        Assert.assertEquals((long)0L, (long)qb.build().list().size());
        ObjectName massIndexerName = new ObjectName("jboss.infinispan:type=Query,manager=" + ObjectName.quote(CACHE_CONTAINER_NAME) + ",cache=" + ObjectName.quote(CACHE_NAME) + ",component=MassIndexer");
        this.jmxConnectionProvider.getConnection().invoke(massIndexerName, "start", null, null);
        List list = qb.build().list();
        Assert.assertEquals((long)1L, (long)list.size());
        User foundUser = (User)list.get(0);
        Assert.assertEquals((long)1L, (long)foundUser.getId());
        Assert.assertEquals((Object)"Tom", (Object)foundUser.getName());
        Assert.assertEquals((Object)"Cat", (Object)foundUser.getSurname());
        Assert.assertEquals((Object)User.Gender.MALE, (Object)foundUser.getGender());
    }
}

