/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.query;

import java.io.IOException;
import java.io.InputStream;
import javax.management.ObjectName;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.utils.MBeanServerConnectionProvider;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.sampledomain.User;
import org.infinispan.protostream.sampledomain.marshallers.MarshallerRegistration;
import org.infinispan.server.test.util.ITestUtils;
import org.infinispan.server.test.util.RemoteCacheManagerFactory;
import org.junit.After;
import org.junit.Before;

public abstract class RemoteQueryBaseIT {
    protected final String cacheContainerName;
    protected final String cacheName;
    protected RemoteCacheManager remoteCacheManager;
    protected RemoteCache<Integer, User> remoteCache;
    protected MBeanServerConnectionProvider jmxConnectionProvider;
    protected RemoteCacheManagerFactory rcmFactory;

    protected RemoteQueryBaseIT(String cacheContainerName, String cacheName) {
        this.cacheContainerName = cacheContainerName;
        this.cacheName = cacheName;
    }

    protected abstract RemoteInfinispanServer getServer();

    @Before
    public void setUp() throws Exception {
        this.jmxConnectionProvider = new MBeanServerConnectionProvider(this.getServer().getHotrodEndpoint().getInetAddress().getHostName(), 9990);
        this.rcmFactory = new RemoteCacheManagerFactory();
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host(this.getServer().getHotrodEndpoint().getInetAddress().getHostName()).port(this.getServer().getHotrodEndpoint().getPort()).marshaller((Marshaller)new ProtoStreamMarshaller());
        this.remoteCacheManager = this.rcmFactory.createManager(clientBuilder);
        this.remoteCache = this.remoteCacheManager.getCache(this.cacheName);
        String mbean = "jboss.infinispan:type=RemoteQuery,name=" + ObjectName.quote(this.cacheContainerName) + ",component=ProtobufMetadataManager";
        String[] fileNames = new String[]{"bank.proto", "indexing.proto", "descriptor.proto"};
        String[] fileContents = new String[]{this.read("/sample_bank_account/bank.proto"), this.read("/infinispan/indexing.proto"), this.read("/google/protobuf/descriptor.proto")};
        ITestUtils.invokeOperation(this.jmxConnectionProvider, mbean, "registerProtofiles", new Object[]{fileNames, fileContents}, new String[]{String[].class.getName(), String[].class.getName()});
        MarshallerRegistration.registerMarshallers((SerializationContext)ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.remoteCacheManager));
    }

    @After
    public void tearDown() {
        if (this.remoteCache != null) {
            this.remoteCache.clear();
        }
        if (this.rcmFactory != null) {
            this.rcmFactory.stopManagers();
        }
        this.rcmFactory = null;
    }

    private String read(String resourcePath) throws IOException {
        return Util.read((InputStream)this.getClass().getResourceAsStream(resourcePath));
    }
}

