/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.LinkedList;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.infinispan.commons.util.Util;

public class ProtofileRegistrar {
    public static void main(String[] args) {
        if (args.length != 3) {
            System.err.println("There are 3 parameters required:\n1) path to one or more protofiles, comma separated \n2) server host\n3) server JMX port");
            System.exit(1);
        }
        String PROTOFILES_PATH = args[0];
        String SERVER_HOST = args[1];
        int JMX_PORT = Integer.parseInt(args[2]);
        ProtofileRegistrar registrar = new ProtofileRegistrar();
        try {
            registrar.registerProtofile(PROTOFILES_PATH, SERVER_HOST, JMX_PORT);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void registerProtofile(String protofilesPath, String host, int jmxPort) throws Exception {
        JMXConnector jmxConnector = JMXConnectorFactory.connect(new JMXServiceURL("service:jmx:http-remoting-jmx://" + host + ":" + jmxPort));
        MBeanServerConnection jmxConnection = jmxConnector.getMBeanServerConnection();
        ObjectName objName = new ObjectName("jboss.infinispan:type=RemoteQuery,name=" + ObjectName.quote("local") + ",component=ProtobufMetadataManager");
        LinkedList<String> fileNames = new LinkedList<String>();
        LinkedList<String> fileContents = new LinkedList<String>();
        for (String protofile : protofilesPath.split(",")) {
            String descriptor = this.readClasspathResource(protofile);
            String name = Paths.get(protofile, new String[0]).getFileName().toString();
            fileNames.add(name);
            fileContents.add(descriptor);
        }
        String[] names = fileNames.toArray(new String[fileNames.size()]);
        String[] contents = fileContents.toArray(new String[fileContents.size()]);
        jmxConnection.invoke(objName, "registerProtofiles", new Object[]{names, contents}, new String[]{String[].class.getName(), String[].class.getName()});
        System.out.printf("Successfully registered protofile(s) %s at %s/%d\n", protofilesPath, host, jmxPort);
    }

    private String readClasspathResource(String c) throws IOException {
        InputStream is = this.getClass().getResourceAsStream(c);
        return Util.read((InputStream)is);
    }
}

