/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.util.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.infinispan.commons.equivalence.ByteArrayEquivalence;
import org.infinispan.server.test.util.ITestUtils;
import org.infinispan.server.test.util.jdbc.SimpleConnectionFactory;

public class DBServer {
    public static final long TIMEOUT = 15000L;
    public String connectionUrl;
    public String username;
    public String password;
    public String bucketTableName;
    public String stringTableName;
    public TableManipulation bucketTable;
    public TableManipulation stringTable;

    public static DBServer create() {
        return new DBServer();
    }

    public DBServer() {
    }

    public DBServer(String bucketTableName, String stringTableName, String idColumnName, String dataColumnName) {
        this.connectionUrl = System.getProperty("connection.url");
        this.username = System.getProperty("username");
        this.password = System.getProperty("password");
        this.bucketTableName = bucketTableName;
        this.stringTableName = stringTableName;
        String driver = System.getProperty("driver.class");
        if (bucketTableName != null) {
            this.bucketTable = new TableManipulation(driver, this.connectionUrl, this.username, this.password, bucketTableName, idColumnName, dataColumnName);
        }
        if (stringTableName != null) {
            this.stringTable = new TableManipulation(driver, this.connectionUrl, this.username, this.password, stringTableName, idColumnName, dataColumnName);
        }
    }

    public static class TableManipulation {
        private final long RETRY_TIME = 1L;
        private final SimpleConnectionFactory factory;
        private final String idColumnName;
        private final String dataColumnName;
        private String tableName;
        private final String connectionUrl;
        private final String username;
        private final String password;
        private String identifierQuoteString;
        private final String getRowByKeySql;
        private final String getAllRowsSql;
        private final String deleteAllRowsSql;
        private final String dropTableSql;

        public TableManipulation(String driverClass, String connectionUrl, String username, String password, String tableName, String idColumnName, String dataColumnName) {
            this.idColumnName = idColumnName;
            this.dataColumnName = dataColumnName;
            this.tableName = tableName;
            this.connectionUrl = connectionUrl;
            this.username = username;
            this.password = password;
            this.tableName = this.getIdentifierQuoteString() + this.tableName.replaceAll("[^\\p{Alnum}]", "_") + this.getIdentifierQuoteString();
            this.getRowByKeySql = connectionUrl.contains("sybase") ? "SELECT " + idColumnName + ", " + dataColumnName + " FROM " + this.tableName + " WHERE " + idColumnName + " = convert(VARCHAR(255),?)" : (connectionUrl.contains("postgre") || connectionUrl.contains("edb") ? "SELECT " + idColumnName + ", " + dataColumnName + " FROM " + this.tableName + " WHERE " + idColumnName + " = cast(? as VARCHAR(255))" : "SELECT " + idColumnName + ", " + dataColumnName + " FROM " + this.tableName + " WHERE " + idColumnName + " = ?");
            this.getAllRowsSql = "SELECT " + dataColumnName + "," + idColumnName + " FROM " + this.tableName;
            this.deleteAllRowsSql = "DELETE from " + this.tableName;
            this.dropTableSql = "DROP TABLE " + this.tableName;
            this.factory = new SimpleConnectionFactory(connectionUrl, username, password);
            this.factory.start(driverClass);
        }

        public TableManipulation(String driverClass, DBServer DBServer2, String tableName, String idColumnName, String dataColumnName) {
            this(driverClass, DBServer2.connectionUrl, DBServer2.username, DBServer2.password, tableName, idColumnName, dataColumnName);
        }

        private String getIdentifierQuoteString() {
            if (this.identifierQuoteString == null) {
                this.identifierQuoteString = this.connectionUrl.contains("mysql") ? "`" : "\"";
            }
            return this.identifierQuoteString;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValueByKeyAwait(String key) throws Exception {
            Connection connection = this.factory.getConnection();
            final PreparedStatement ps = connection.prepareStatement(this.getRowByKeySql);
            ps.setString(1, key);
            Object toReturn = null;
            try {
                toReturn = this.withAwait(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        ResultSet rs = ps.executeQuery();
                        Object result = null;
                        if (rs.next()) {
                            result = rs.getObject(TableManipulation.this.dataColumnName);
                        }
                        return result;
                    }
                });
            }
            finally {
                this.factory.releaseConnection(connection);
            }
            return toReturn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValueByKey(String key) throws Exception {
            Connection connection = this.factory.getConnection();
            Object result = null;
            try {
                PreparedStatement ps = connection.prepareStatement(this.getRowByKeySql);
                ps.setString(1, key);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    result = rs.getObject(this.dataColumnName);
                }
            }
            finally {
                this.factory.releaseConnection(connection);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getBucketByKey(Object key) throws Exception {
            int keyHash = ByteArrayEquivalence.INSTANCE.hashCode(key) & 0xFFFFFC00;
            Connection connection = this.factory.getConnection();
            PreparedStatement ps = connection.prepareStatement(this.getRowByKeySql);
            Object result = null;
            ps.setString(1, String.valueOf(keyHash));
            try {
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    result = rs.getObject(this.dataColumnName);
                }
            }
            finally {
                this.factory.releaseConnection(connection);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getBucketByKeyAwait(Object key) throws Exception {
            int keyHash = ByteArrayEquivalence.INSTANCE.hashCode(key) & 0xFFFFFC00;
            Connection connection = this.factory.getConnection();
            final PreparedStatement ps = connection.prepareStatement(this.getRowByKeySql);
            Object result = null;
            ps.setString(1, String.valueOf(keyHash));
            try {
                ResultSet rs = this.withAwait(new Callable<ResultSet>(){

                    @Override
                    public ResultSet call() throws Exception {
                        return ps.executeQuery();
                    }
                });
                if (rs.next()) {
                    result = rs.getObject(this.dataColumnName);
                }
            }
            finally {
                this.factory.releaseConnection(connection);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<String> getAllRows() throws Exception {
            Connection connection = this.factory.getConnection();
            Statement s = connection.createStatement();
            ArrayList<String> rows = new ArrayList<String>();
            try {
                ResultSet rs = s.executeQuery(this.getAllRowsSql);
                while (rs.next()) {
                    rows.add(rs.toString());
                }
            }
            finally {
                this.factory.releaseConnection(connection);
            }
            return rows;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<String> getAllKeys() throws Exception {
            Connection connection = this.factory.getConnection();
            Statement s = connection.createStatement();
            ArrayList<String> keys = new ArrayList<String>();
            try {
                ResultSet rs = s.executeQuery(this.getAllRowsSql);
                while (rs.next()) {
                    keys.add(rs.getObject(this.idColumnName).toString());
                }
            }
            finally {
                this.factory.releaseConnection(connection);
            }
            return keys;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteAllRows() throws Exception {
            Connection connection = this.factory.getConnection();
            Statement s = connection.createStatement();
            try {
                s.executeUpdate(this.deleteAllRowsSql);
            }
            finally {
                this.factory.releaseConnection(connection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<String> getTableNames() throws Exception {
            ArrayList<String> tables = new ArrayList<String>();
            Connection connection = this.factory.getConnection();
            try {
                DatabaseMetaData dbm = connection.getMetaData();
                String[] types = new String[]{"TABLE"};
                ResultSet rs = dbm.getTables(null, null, "%", types);
                while (rs.next()) {
                    String table = rs.getString("TABLE_NAME");
                    tables.add(table);
                }
            }
            finally {
                this.factory.releaseConnection(connection);
            }
            return tables;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dropTable() throws Exception {
            Connection connection = this.factory.getConnection();
            Statement s = connection.createStatement();
            try {
                s.executeUpdate(this.dropTableSql);
            }
            finally {
                this.factory.releaseConnection(connection);
            }
        }

        public boolean exists() throws Exception {
            List<String> tables = this.getTableNames();
            return tables.contains(this.tableName.substring(1, this.tableName.length() - 1));
        }

        public void waitForTableCreation() {
            Boolean result = this.withAwait(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    List<String> tables = TableManipulation.this.getTableNames();
                    if (TableManipulation.this.connectionUrl.contains("mysql")) {
                        return tables.contains(TableManipulation.this.tableName.substring(1, TableManipulation.this.tableName.length() - 1).toLowerCase()) ? Boolean.valueOf(true) : null;
                    }
                    return tables.contains(TableManipulation.this.tableName.substring(1, TableManipulation.this.tableName.length() - 1)) ? Boolean.valueOf(true) : null;
                }
            });
            if (result == null) {
                throw new RuntimeException("Table " + this.tableName + " was not created in " + 15000L + " ms");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getDBName() throws Exception {
            Connection connection = this.factory.getConnection();
            try {
                String dbProduct = connection.getMetaData().getDatabaseProductName();
                String result = "DB Product: " + dbProduct;
                String string = result = result + ", Driver Name:" + connection.getMetaData().getDriverName();
                return string;
            }
            finally {
                this.factory.releaseConnection(connection);
            }
        }

        public String getConnectionUrl() {
            return this.connectionUrl;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        private <T> T withAwait(Callable<T> c) {
            T result = null;
            long timeout = System.currentTimeMillis() + 15000L;
            while (result == null && System.currentTimeMillis() < timeout) {
                try {
                    result = c.call();
                }
                catch (Exception e) {
                    ITestUtils.sleepForSecs(1.0);
                }
            }
            return result;
        }
    }
}

