/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.util.osgi;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.features.FeaturesService;
import org.infinispan.server.test.util.osgi.CommandExecutionException;
import org.infinispan.server.test.util.osgi.ServiceLocator;
import org.junit.Assert;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.ProbeBuilder;
import org.ops4j.pax.exam.TestProbeBuilder;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.options.MavenArtifactProvisionOption;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class KarafTestSupport {
    public static final Long DEFAULT_TIMEOUT = 30000L;
    public static final Long SYSTEM_TIMEOUT = 30000L;
    public static final Long DEFAULT_WAIT = 10000L;
    public static final Long PROVISION_TIMEOUT = 300000L;
    public static final Long COMMAND_TIMEOUT = 70000L;
    protected ExecutorService executor = Executors.newCachedThreadPool();
    @Inject
    protected BundleContext bundleContext;

    protected Bundle installBundle(String groupId, String artifactId) throws Exception {
        MavenArtifactProvisionOption mvnUrl = CoreOptions.mavenBundle((String)groupId, (String)artifactId).versionAsInProject();
        return this.bundleContext.installBundle(mvnUrl.getURL());
    }

    protected Bundle getInstalledBundle(String symbolicName) {
        for (Bundle b : this.bundleContext.getBundles()) {
            if (!b.getSymbolicName().equals(symbolicName)) continue;
            return b;
        }
        for (Bundle b : this.bundleContext.getBundles()) {
            System.err.println("Bundle: " + b.getSymbolicName());
        }
        throw new RuntimeException("Bundle " + symbolicName + " does not exist");
    }

    public static Option copySystemProperty(String propertyName) {
        return KarafDistributionOption.editConfigurationFilePut((String)"etc/system.properties", (String)propertyName, (String)(System.getProperty(propertyName) != null ? System.getProperty(propertyName) : ""));
    }

    protected static MavenArtifactProvisionOption mavenBundle(String groupId, String artifactId) {
        return CoreOptions.mavenBundle((String)groupId, (String)artifactId).versionAsInProject();
    }

    protected static MavenArtifactProvisionOption mavenBundle(String groupId, String artifactId, String version) {
        return CoreOptions.mavenBundle((String)groupId, (String)artifactId).version(version);
    }

    protected String executeCommand(String command) {
        return this.executeCommands(COMMAND_TIMEOUT, false, command);
    }

    protected String executeCommands(String ... commands) {
        return this.executeCommands(COMMAND_TIMEOUT, false, commands);
    }

    protected String executeCommand(String command, long timeout, boolean silent) {
        return this.executeCommands(timeout, silent, command);
    }

    protected String executeCommands(long timeout, final boolean silent, final String ... commands) {
        String response = null;
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        final PrintStream printStream = new PrintStream(byteArrayOutputStream);
        CommandProcessor commandProcessor = ServiceLocator.getOsgiService(CommandProcessor.class);
        final CommandSession commandSession = commandProcessor.createSession(System.in, printStream, printStream);
        commandSession.put("APPLICATION", (Object)System.getProperty("karaf.name", "root"));
        commandSession.put("USER", (Object)"karaf");
        FutureTask<String> commandFuture = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                for (String command : commands) {
                    boolean keepRunning = true;
                    if (!silent) {
                        System.out.println(command);
                        System.out.flush();
                    }
                    while (!Thread.currentThread().isInterrupted() && keepRunning) {
                        try {
                            commandSession.execute((CharSequence)command);
                            keepRunning = false;
                        }
                        catch (Exception e) {
                            if (KarafTestSupport.retryException(e)) {
                                keepRunning = true;
                                KarafTestSupport.sleep(1000L);
                                continue;
                            }
                            throw new CommandExecutionException(e);
                        }
                    }
                }
                printStream.flush();
                return byteArrayOutputStream.toString();
            }
        });
        try {
            this.executor.submit(commandFuture);
            response = commandFuture.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw CommandExecutionException.launderThrowable(e.getCause());
        }
        catch (Exception e) {
            throw CommandExecutionException.launderThrowable(e);
        }
        return response;
    }

    private static boolean retryException(Exception e) {
        return e.getClass().getName().equals("org.apache.felix.gogo.runtime.CommandNotFoundException");
    }

    private static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void installAndCheckFeature(String feature, String featureUrl) throws Exception {
        System.err.println(this.executeCommand("features:addUrl " + featureUrl));
        System.err.println(this.executeCommand("features:install " + feature));
        FeaturesService featuresService = ServiceLocator.getOsgiService(FeaturesService.class);
        System.err.println(this.executeCommand("osgi:list -t 0"));
        Assert.assertTrue((String)("Expected " + feature + " feature to be installed."), (boolean)featuresService.isInstalled(featuresService.getFeature(feature)));
    }

    public void unInstallAndCheckFeature(String feature) throws Exception {
        System.err.println(this.executeCommand("features:uninstall " + feature));
        FeaturesService featuresService = ServiceLocator.getOsgiService(FeaturesService.class);
        System.err.println(this.executeCommand("osgi:list -t 0"));
        Assert.assertFalse((String)("Expected " + feature + " feature to be installed."), (boolean)featuresService.isInstalled(featuresService.getFeature(feature)));
    }

    @ProbeBuilder
    public TestProbeBuilder probeConfiguration(TestProbeBuilder probe) {
        probe.setHeader("DynamicImport-Package", "*,org.apache.felix.service.*;status=provisional");
        return probe;
    }
}

