/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.jgroups.subsystem;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.infinispan.server.commons.msc.ServiceContainerHelper;
import org.infinispan.server.jgroups.spi.ChannelFactory;
import org.infinispan.server.jgroups.spi.service.ProtocolStackServiceName;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jgroups.JChannel;
import org.jgroups.stack.ProtocolStack;

public class ExportNativeConfiguration
extends AbstractRuntimeOnlyHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        String stackName = context.getCurrentAddressValue();
        ServiceRegistry registry = context.getServiceRegistry(false);
        ServiceName serviceName = ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName(stackName);
        try {
            ServiceController controller = ServiceContainerHelper.getService((ServiceRegistry)registry, (ServiceName)serviceName);
            ServiceController.Mode mode = controller.getMode();
            controller.setMode(ServiceController.Mode.ACTIVE);
            try {
                ChannelFactory factory = (ChannelFactory)controller.awaitValue();
                try (JChannel channel = factory.createChannel(UUID.randomUUID().toString());){
                    List protocols = channel.getProtocolStack().getProtocols();
                    Collections.reverse(protocols);
                    ProtocolStack stack = new ProtocolStack();
                    stack.addProtocols(protocols);
                    context.getResult().set(stack.printProtocolSpecAsXML());
                    context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                }
            }
            finally {
                controller.setMode(mode);
            }
        }
        catch (Exception e) {
            throw new OperationFailedException(e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

