/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.jgroups.subsystem;

import org.infinispan.server.commons.service.InjectedValueDependency;
import org.infinispan.server.commons.service.ValueDependency;
import org.infinispan.server.jgroups.spi.SaslConfiguration;
import org.infinispan.server.jgroups.spi.service.ProtocolStackServiceName;
import org.infinispan.server.jgroups.subsystem.AbstractProtocolConfigurationBuilder;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class SaslConfigurationBuilder
extends AbstractProtocolConfigurationBuilder<SaslConfiguration>
implements SaslConfiguration {
    private String mech;
    private String clusterRole;
    private ValueDependency<SecurityRealm> securityRealm;

    public SaslConfigurationBuilder(String stackName) {
        super(stackName, "SASL");
    }

    @Override
    public ServiceName getServiceName() {
        return ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName(this.stackName).append(new String[]{"sasl"});
    }

    @Override
    public ServiceBuilder<SaslConfiguration> build(ServiceTarget target) {
        ServiceBuilder builder = super.build(target);
        if (this.securityRealm != null) {
            this.securityRealm.register(builder);
        }
        return builder;
    }

    public SaslConfigurationBuilder setMech(String mech) {
        this.mech = mech;
        return this;
    }

    public SaslConfigurationBuilder setSecurityRealm(String securityRealm) {
        this.securityRealm = new InjectedValueDependency(SecurityRealm.ServiceUtil.createServiceName((String)securityRealm), SecurityRealm.class);
        return this;
    }

    public SaslConfigurationBuilder setClusterRole(String clusterRole) {
        this.clusterRole = clusterRole;
        return this;
    }

    public SaslConfigurationBuilder addProperty(String name, String value) {
        super.addProperty(name, value);
        return this;
    }

    public SaslConfiguration getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    @Override
    public String getClusterRole() {
        return this.clusterRole;
    }

    @Override
    public SecurityRealm getSecurityRealm() {
        return this.securityRealm != null ? (SecurityRealm)this.securityRealm.getValue() : null;
    }

    @Override
    public String getMech() {
        return this.mech;
    }
}

