/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.jgroups.subsystem;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.server.commons.service.AsynchronousServiceBuilder;
import org.infinispan.server.commons.service.Builder;
import org.infinispan.server.jgroups.ProtocolDefaults;
import org.infinispan.server.jgroups.logging.JGroupsLogger;
import org.infinispan.server.jgroups.subsystem.JGroupsExtension;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.Value;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.conf.XmlConfigurator;

public class ProtocolDefaultsBuilder
implements Builder<ProtocolDefaults>,
Value<ProtocolDefaults>,
ProtocolDefaults {
    static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"datagrid-jgroups", "defaults"});
    private static final String DEFAULTS = "jgroups-defaults.xml";
    private final String resource;
    private final Map<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();

    private static ProtocolStackConfigurator load(String resource) throws IllegalStateException {
        URL url = ProtocolDefaultsBuilder.find(resource, JGroupsExtension.class.getClassLoader());
        JGroupsLogger.ROOT_LOGGER.debugf("Loading JGroups protocol defaults from %s", url.toString());
        try {
            return XmlConfigurator.getInstance((InputStream)url.openStream());
        }
        catch (IOException e) {
            throw new IllegalArgumentException(JGroupsLogger.ROOT_LOGGER.parserFailure(url));
        }
    }

    private static URL find(String resource, ClassLoader ... loaders) {
        for (ClassLoader loader : loaders) {
            URL url;
            if (loader == null || (url = loader.getResource(resource)) == null) continue;
            return url;
        }
        throw new IllegalArgumentException(JGroupsLogger.ROOT_LOGGER.notFound(resource));
    }

    public ProtocolDefaultsBuilder() {
        this(DEFAULTS);
    }

    public ProtocolDefaultsBuilder(String resource) {
        this.resource = resource;
    }

    public ServiceName getServiceName() {
        return SERVICE_NAME;
    }

    public ServiceBuilder<ProtocolDefaults> build(ServiceTarget target) {
        return new AsynchronousServiceBuilder(SERVICE_NAME, (Service)new ValueService((Value)this)).build(target);
    }

    public ProtocolDefaults getValue() {
        ProtocolStackConfigurator configurator = ProtocolDefaultsBuilder.load(this.resource);
        for (ProtocolConfiguration config : configurator.getProtocolStack()) {
            this.map.put(config.getProtocolName(), Collections.unmodifiableMap(config.getProperties()));
        }
        return this;
    }

    @Override
    public Map<String, String> getProperties(String protocol) {
        Map<String, String> properties = this.map.get(protocol);
        return properties != null ? Collections.unmodifiableMap(properties) : Collections.emptyMap();
    }
}

