/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.jgroups.subsystem;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import org.infinispan.server.commons.controller.Operations;
import org.infinispan.server.jgroups.subsystem.JGroupsExtension;
import org.infinispan.server.jgroups.subsystem.JGroupsSchema;
import org.infinispan.server.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.infinispan.server.jgroups.subsystem.ProtocolResourceDefinition;
import org.infinispan.server.jgroups.subsystem.StackResourceDefinition;
import org.infinispan.server.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.subsystem.test.AbstractSubsystemTest;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.dmr.ModelNode;

public class OperationTestCaseBase
extends AbstractSubsystemTest {
    static final String SUBSYSTEM_XML_FILE = JGroupsSchema.CURRENT.format("subsystem-%s-%d_%d.xml").replaceAll(":", "_");

    public OperationTestCaseBase() {
        super("datagrid-jgroups", (Extension)new JGroupsExtension());
    }

    protected static ModelNode getSubsystemReadOperation(String name) {
        return Operations.createReadAttributeOperation((PathAddress)OperationTestCaseBase.getSubsystemAddress(), (String)name);
    }

    protected static ModelNode getSubsystemWriteOperation(String name, String value) {
        return Operations.createWriteAttributeOperation((PathAddress)OperationTestCaseBase.getSubsystemAddress(), (String)name, (ModelNode)new ModelNode(value));
    }

    protected static ModelNode getProtocolStackAddOperation(String stackName) {
        return Util.createAddOperation((PathAddress)OperationTestCaseBase.getProtocolStackAddress(stackName));
    }

    protected static ModelNode getProtocolStackAddOperationWithParameters(String stackName) {
        ModelNode[] operations = new ModelNode[]{OperationTestCaseBase.getProtocolStackAddOperation(stackName), OperationTestCaseBase.getTransportAddOperation(stackName, "UDP"), OperationTestCaseBase.getProtocolAddOperation(stackName, "MPING"), OperationTestCaseBase.getProtocolAddOperation(stackName, "pbcast.FLUSH")};
        return Operations.createCompositeOperation((ModelNode[])operations);
    }

    protected static ModelNode getProtocolStackRemoveOperation(String stackName) {
        return Util.createRemoveOperation((PathAddress)OperationTestCaseBase.getProtocolStackAddress(stackName));
    }

    protected static ModelNode getTransportAddOperation(String stackName, String protocol) {
        return Util.createAddOperation((PathAddress)OperationTestCaseBase.getTransportAddress(stackName, protocol));
    }

    protected static ModelNode getTransportReadOperation(String stackName, String type, String name) {
        return Operations.createReadAttributeOperation((PathAddress)OperationTestCaseBase.getTransportAddress(stackName, type), (String)name);
    }

    protected static ModelNode getTransportWriteOperation(String stackName, String type, String name, String value) {
        return Operations.createWriteAttributeOperation((PathAddress)OperationTestCaseBase.getTransportAddress(stackName, type), (String)name, (ModelNode)new ModelNode(value));
    }

    protected static ModelNode getTransportGetPropertyOperation(String stackName, String type, String propertyName) {
        return Operations.createMapGetOperation((PathAddress)OperationTestCaseBase.getTransportAddress(stackName, type), (String)ProtocolResourceDefinition.PROPERTIES.getName(), (String)propertyName);
    }

    protected static ModelNode getTransportPutPropertyOperation(String stackName, String type, String propertyName, String propertyValue) {
        return Operations.createMapPutOperation((PathAddress)OperationTestCaseBase.getTransportAddress(stackName, type), (String)ProtocolResourceDefinition.PROPERTIES.getName(), (String)propertyName, (String)propertyValue);
    }

    protected static ModelNode getTransportRemovePropertyOperation(String stackName, String type, String propertyName) {
        return Operations.createMapRemoveOperation((PathAddress)OperationTestCaseBase.getTransportAddress(stackName, type), (String)ProtocolResourceDefinition.PROPERTIES.getName(), (String)propertyName);
    }

    protected static ModelNode getProtocolAddOperation(String stackName, String type) {
        return Util.createAddOperation((PathAddress)OperationTestCaseBase.getProtocolAddress(stackName, type));
    }

    protected static ModelNode getProtocolReadOperation(String stackName, String protocolName, String name) {
        return Operations.createReadAttributeOperation((PathAddress)OperationTestCaseBase.getProtocolAddress(stackName, protocolName), (String)name);
    }

    protected static ModelNode getProtocolWriteOperation(String stackName, String protocolName, String name, String value) {
        return Operations.createWriteAttributeOperation((PathAddress)OperationTestCaseBase.getProtocolAddress(stackName, protocolName), (String)name, (ModelNode)new ModelNode(value));
    }

    protected static ModelNode getProtocolGetPropertyOperation(String stackName, String protocolName, String propertyName) {
        return Operations.createMapGetOperation((PathAddress)OperationTestCaseBase.getProtocolAddress(stackName, protocolName), (String)ProtocolResourceDefinition.PROPERTIES.getName(), (String)propertyName);
    }

    protected static ModelNode getProtocolPutPropertyOperation(String stackName, String protocolName, String propertyName, String propertyValue) {
        return Operations.createMapPutOperation((PathAddress)OperationTestCaseBase.getProtocolAddress(stackName, protocolName), (String)ProtocolResourceDefinition.PROPERTIES.getName(), (String)propertyName, (String)propertyValue);
    }

    protected static ModelNode getProtocolRemovePropertyOperation(String stackName, String protocolName, String propertyName) {
        return Operations.createMapRemoveOperation((PathAddress)OperationTestCaseBase.getProtocolAddress(stackName, protocolName), (String)ProtocolResourceDefinition.PROPERTIES.getName(), (String)propertyName);
    }

    protected static PathAddress getSubsystemAddress() {
        return PathAddress.pathAddress((PathElement[])new PathElement[]{JGroupsSubsystemResourceDefinition.PATH});
    }

    protected static PathAddress getProtocolStackAddress(String stackName) {
        return OperationTestCaseBase.getSubsystemAddress().append(new PathElement[]{StackResourceDefinition.pathElement((String)stackName)});
    }

    protected static PathAddress getTransportAddress(String stackName, String type) {
        return OperationTestCaseBase.getProtocolStackAddress(stackName).append(new PathElement[]{TransportResourceDefinition.pathElement((String)type)});
    }

    protected static PathAddress getProtocolAddress(String stackName, String type) {
        return OperationTestCaseBase.getProtocolStackAddress(stackName).append(new PathElement[]{ProtocolResourceDefinition.pathElement((String)type)});
    }

    protected String getSubsystemXml() throws IOException {
        return this.readResource(SUBSYSTEM_XML_FILE);
    }

    protected KernelServices buildKernelServices() throws XMLStreamException, IOException, Exception {
        return this.createKernelServicesBuilder(AdditionalInitialization.MANAGEMENT).setSubsystemXml(this.getSubsystemXml()).build();
    }
}

