/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.testapps.chunk;

import com.google.common.base.MoreObjects;
import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.AbstractItemReader;
import jakarta.batch.api.chunk.ItemReader;
import jakarta.batch.operations.BatchRuntimeException;
import jakarta.batch.runtime.context.StepContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import org.jberet.testapps.chunk.ReaderWriterResult;

@Named
public class ClosingItemReader
extends AbstractItemReader
implements ItemReader {
    @Inject
    private StepContext stepContext;
    @Inject
    @BatchProperty
    private boolean failReaderAtOpen;
    @Inject
    @BatchProperty
    private int stopReadAt;
    @Inject
    @BatchProperty
    private int failReadAt;

    public void close() throws Exception {
        this.stepContext.setPersistentUserData((Serializable)this.getOrCreateReaderWriterResult().setReaderClosed(true));
    }

    public void open(Serializable checkpoint) throws Exception {
        if (this.failReaderAtOpen) {
            throw new BatchRuntimeException("Failed reader at open");
        }
        this.stepContext.setPersistentUserData((Serializable)this.getOrCreateReaderWriterResult().setReaderClosed(false));
    }

    public Serializable checkpointInfo() throws Exception {
        return this.stepContext.getPersistentUserData();
    }

    public Object readItem() throws Exception {
        ReaderWriterResult item = this.getOrCreateReaderWriterResult();
        int counter = item.incrementReadCount();
        this.stepContext.setPersistentUserData((Serializable)item);
        if (counter == this.stopReadAt) {
            return null;
        }
        if (counter == this.failReadAt) {
            throw new BatchRuntimeException("Failed reader at point " + this.failReadAt + ". Reader and writer should both be closed.");
        }
        return counter;
    }

    public String toString() {
        return MoreObjects.toStringHelper(((Object)((Object)this)).getClass()).add("failReaderAtOpen", this.failReaderAtOpen).add("stopReaderAt", this.stopReadAt).add("failReadAt", this.failReadAt).add("readerWriterItem", (Object)this.stepContext.getPersistentUserData()).toString();
    }

    private ReaderWriterResult getOrCreateReaderWriterResult() {
        ReaderWriterResult result = (ReaderWriterResult)this.stepContext.getPersistentUserData();
        if (result == null) {
            result = new ReaderWriterResult();
        }
        return result;
    }
}

