/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.testapps.chunk;

import com.google.common.base.MoreObjects;
import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.AbstractItemWriter;
import jakarta.batch.api.chunk.ItemWriter;
import jakarta.batch.operations.BatchRuntimeException;
import jakarta.batch.runtime.context.StepContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.List;
import org.jberet.testapps.chunk.ReaderWriterResult;

@Named
public class ClosingItemWriter
extends AbstractItemWriter
implements ItemWriter {
    @Inject
    private StepContext stepContext;
    @Inject
    @BatchProperty
    private boolean failWriterAtOpen;
    @Inject
    @BatchProperty
    private int failWriteAt;

    public void open(Serializable checkpoint) throws Exception {
        if (this.failWriterAtOpen) {
            throw new BatchRuntimeException("Failed writer at open");
        }
        this.stepContext.setPersistentUserData((Serializable)this.getOrCreateReaderWriterResult().setWriterClosed(false));
    }

    public void close() throws Exception {
        this.stepContext.setPersistentUserData((Serializable)this.getOrCreateReaderWriterResult().setWriterClosed(true));
    }

    public Serializable checkpointInfo() throws Exception {
        return this.stepContext.getPersistentUserData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeItems(List<Object> items) throws Exception {
        ReaderWriterResult item = this.getOrCreateReaderWriterResult();
        for (Object o : items) {
            try {
                if (item.incrementWriteCount() != this.failWriteAt) continue;
                throw new BatchRuntimeException("Failed writer at point " + this.failWriteAt + ". Reader and writer should both be closed.");
            }
            finally {
                this.stepContext.setPersistentUserData((Serializable)item);
            }
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(((Object)((Object)this)).getClass()).add("failWriterAtOpen", this.failWriterAtOpen).add("failWriteAt", this.failWriteAt).add("readerWriterItem", (Object)this.stepContext).toString();
    }

    private ReaderWriterResult getOrCreateReaderWriterResult() {
        ReaderWriterResult result = (ReaderWriterResult)this.stepContext.getPersistentUserData();
        if (result == null) {
            result = new ReaderWriterResult();
        }
        return result;
    }
}

