/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.testapps.chunkpartition;

import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.partition.PartitionMapper;
import jakarta.batch.api.partition.PartitionPlan;
import jakarta.batch.api.partition.PartitionPlanImpl;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Properties;

@Named
public class ChunkPartitionMapper
implements PartitionMapper {
    private static final int partitionCount = 3;
    @Inject
    @BatchProperty(name="reader.fail.on.values")
    private String readerFailValues;
    @Inject
    @BatchProperty(name="override")
    private boolean override;

    public PartitionPlan mapPartitions() throws Exception {
        Properties[] partitionPropsArray = new Properties[]{this.createPropertiesForPartition("0", "9"), this.createPropertiesForPartition("10", "19"), this.createPropertiesForPartition("20", "29")};
        PartitionPlanImpl plan = new PartitionPlanImpl();
        plan.setPartitions(3);
        plan.setThreads(3);
        plan.setPartitionProperties(partitionPropsArray);
        if (this.override) {
            plan.setPartitionsOverride(true);
        }
        return plan;
    }

    private Properties createPropertiesForPartition(String start, String end) {
        Properties props = new Properties();
        props.setProperty("partition.start", start);
        props.setProperty("partition.end", end);
        if (this.readerFailValues != null) {
            props.setProperty("reader.fail.on.values", this.readerFailValues);
        }
        return props;
    }
}

