/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.testapps.chunkpartition;

import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.partition.PartitionAnalyzer;
import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.context.StepContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

@Named
public final class ChunkPartitionAnalyzer
implements PartitionAnalyzer {
    @Inject
    private StepContext stepContext;
    @Inject
    @BatchProperty(name="thread.count")
    private int threadCount;
    @Inject
    @BatchProperty(name="skip.thread.check")
    private boolean skipThreadCheck;
    private final Set<Long> childThreadIds = new HashSet<Long>();
    private int numOfCompletedPartitions;

    public void analyzeCollectorData(Serializable data) throws Exception {
        this.childThreadIds.add((Long)data);
    }

    public void analyzeStatus(BatchStatus batchStatus, String exitStatus) throws Exception {
        ++this.numOfCompletedPartitions;
        if (this.numOfCompletedPartitions == 3 && !this.skipThreadCheck) {
            if (this.childThreadIds.size() <= this.threadCount) {
                this.stepContext.setExitStatus(String.format("PASS: Max allowable thread count %s, actual threads %s", this.threadCount, this.childThreadIds.size()));
            } else {
                this.stepContext.setExitStatus(String.format("FAIL: Expecting max thread count %s, but got %s", this.threadCount, this.childThreadIds.size()));
            }
        }
    }
}

