/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.testapps.common;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.batch.operations.JobOperator;
import javax.batch.runtime.BatchRuntime;
import javax.batch.runtime.StepExecution;
import org.jberet.runtime.JobExecutionImpl;

public abstract class AbstractIT {
    protected long jobTimeout = Long.getLong("org.jberet.job.execution.timeout.seconds", 300L);
    protected Properties params = new Properties();
    protected JobOperator jobOperator = BatchRuntime.getJobOperator();
    protected long jobExecutionId;
    protected JobExecutionImpl jobExecution;
    protected List<StepExecution> stepExecutions;
    protected StepExecution stepExecution0;

    protected void startJob(String jobXml) {
        this.jobExecutionId = this.jobOperator.start(jobXml, this.params);
        this.jobExecution = (JobExecutionImpl)this.jobOperator.getJobExecution(this.jobExecutionId);
    }

    protected void awaitTermination(JobExecutionImpl ... exes) throws InterruptedException {
        JobExecutionImpl exe = exes.length == 0 ? this.jobExecution : exes[0];
        exe.awaitTermination(this.jobTimeout, TimeUnit.SECONDS);
        this.stepExecutions = this.jobOperator.getStepExecutions(this.jobExecutionId);
        this.stepExecution0 = this.stepExecutions.get(0);
    }

    protected void startJobAndWait(String jobXml) throws Exception {
        this.startJob(jobXml);
        this.awaitTermination(new JobExecutionImpl[0]);
    }

    protected void restartAndWait(long ... oldJobExecutionIds) throws InterruptedException {
        long restartId = oldJobExecutionIds.length == 0 ? this.jobExecutionId : oldJobExecutionIds[0];
        this.jobExecutionId = this.jobOperator.restart(restartId, this.params);
        this.jobExecution = (JobExecutionImpl)this.jobOperator.getJobExecution(this.jobExecutionId);
        this.awaitTermination(new JobExecutionImpl[0]);
    }
}

