/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.testapps.common;

import java.util.List;
import javax.batch.api.chunk.ItemWriter;
import javax.batch.runtime.Metric;
import javax.batch.runtime.StepExecution;
import javax.inject.Named;
import org.jberet.runtime.context.StepContextImpl;
import org.jberet.runtime.metric.MetricImpl;
import org.jberet.testapps.common.IntegerArrayReaderWriterBase;

@Named(value="integerArrayWriter")
public final class IntegerArrayWriter
extends IntegerArrayReaderWriterBase
implements ItemWriter {
    public void writeItems(List<Object> items) throws Exception {
        if (items == null) {
            return;
        }
        if (MetricImpl.getMetric((StepExecution)((StepContextImpl)this.stepContext).getStepExecution(), (Metric.MetricType)Metric.MetricType.WRITE_COUNT) + (long)items.size() >= (long)this.writerFailAt.intValue() && this.writerFailAt >= 0) {
            throw new ArithmeticException("Failing at writer.fail.at point " + this.writerFailAt);
        }
        if (this.writerSleepTime > 0L) {
            Thread.sleep(this.writerSleepTime);
        }
        for (Object o : items) {
            this.data[this.cursor] = (Integer)o;
            ++this.cursor;
        }
        System.out.printf("Wrote items: %s%n", String.valueOf(items));
    }

    @Override
    protected void initData() {
        super.initData();
        this.cursor = this.partitionStart;
        System.out.printf("Partition start = %s, end = %s in %s%n", this.partitionStart, this.partitionEnd, this);
    }
}

