/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.testapps.common;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.batch.operations.JobOperator;
import javax.batch.runtime.BatchRuntime;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.StepExecution;
import org.jberet.runtime.JobExecutionImpl;
import org.jberet.runtime.StepExecutionImpl;

public abstract class AbstractIT {
    protected long jobTimeout;
    protected Properties params = new Properties();
    protected JobOperator jobOperator = BatchRuntime.getJobOperator();
    protected long jobExecutionId;
    protected JobExecutionImpl jobExecution;
    protected List<StepExecution> stepExecutions;
    protected StepExecutionImpl stepExecution0;

    protected long getJobTimeoutSeconds() {
        return this.jobTimeout;
    }

    protected void startJob(String jobXml) {
        this.jobExecutionId = this.jobOperator.start(jobXml, this.params);
        this.jobExecution = (JobExecutionImpl)this.jobOperator.getJobExecution(this.jobExecutionId);
    }

    protected void awaitTermination(JobExecutionImpl ... exes) throws InterruptedException {
        JobExecutionImpl exe = exes.length == 0 ? this.jobExecution : exes[0];
        exe.awaitTermination(this.getJobTimeoutSeconds(), TimeUnit.SECONDS);
        this.stepExecutions = this.jobOperator.getStepExecutions(this.jobExecutionId);
        this.stepExecution0 = (StepExecutionImpl)this.stepExecutions.get(0);
    }

    protected void startJobAndWait(String jobXml) throws Exception {
        this.startJob(jobXml);
        this.awaitTermination(new JobExecutionImpl[0]);
    }

    protected void restartAndWait(long ... oldJobExecutionIds) throws InterruptedException {
        long restartId = oldJobExecutionIds.length == 0 ? this.jobExecutionId : oldJobExecutionIds[0];
        this.jobExecutionId = this.jobOperator.restart(restartId, this.params);
        this.jobExecution = (JobExecutionImpl)this.jobOperator.getJobExecution(this.jobExecutionId);
        this.awaitTermination(new JobExecutionImpl[0]);
    }

    protected long getOriginalJobExecutionId(String jobName) {
        List jobInstances = this.jobOperator.getJobInstances(jobName, 0, 1);
        JobInstance jobInstance = (JobInstance)jobInstances.get(0);
        List jobExecutions = this.jobOperator.getJobExecutions(jobInstance);
        JobExecution originalJobExecution = (JobExecution)jobExecutions.get(jobExecutions.size() - 1);
        return originalJobExecution.getExecutionId();
    }
}

