/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.testapps.common;

import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.Metric;
import javax.batch.runtime.StepExecution;
import org.jberet.job.model.Job;
import org.jberet.operations.JobOperatorImpl;
import org.jberet.runtime.JobExecutionImpl;
import org.jberet.runtime.StepExecutionImpl;
import org.jberet.spi.JobOperatorContext;
import org.junit.Assert;
import org.junit.Before;

public abstract class AbstractIT {
    protected static final String infinispanRepositoryJobXml = "org.jberet.test.infinispanRepository";
    private static Locale originalLocale;
    protected long jobTimeout;
    protected Properties params = new Properties();
    protected long jobExecutionId;
    protected JobExecutionImpl jobExecution;
    protected List<StepExecution> stepExecutions;
    protected StepExecutionImpl stepExecution0;
    protected JobOperatorImpl jobOperator;

    @Before
    public void before() throws Exception {
        if (this.jobOperator == null) {
            this.jobOperator = (JobOperatorImpl)JobOperatorContext.getJobOperatorContext().getJobOperator();
        }
    }

    protected long getJobTimeoutSeconds() {
        return this.jobTimeout;
    }

    protected void startJob(String jobXml) {
        this.jobExecutionId = this.jobOperator.start(jobXml, this.params);
        this.jobExecution = (JobExecutionImpl)this.jobOperator.getJobExecution(this.jobExecutionId);
    }

    protected void startJob(Job job) {
        this.jobExecutionId = this.jobOperator.start(job, this.params);
        this.jobExecution = (JobExecutionImpl)this.jobOperator.getJobExecution(this.jobExecutionId);
    }

    protected void awaitTermination(JobExecutionImpl ... exes) throws InterruptedException {
        JobExecutionImpl exe = exes.length == 0 ? this.jobExecution : exes[0];
        exe.awaitTermination(this.getJobTimeoutSeconds(), TimeUnit.SECONDS);
        this.stepExecutions = this.jobOperator.getStepExecutions(exe.getExecutionId());
        if (!this.stepExecutions.isEmpty()) {
            this.stepExecution0 = (StepExecutionImpl)this.stepExecutions.get(0);
        }
    }

    protected void startJobAndWait(String jobXml) throws Exception {
        this.startJob(jobXml);
        this.awaitTermination(new JobExecutionImpl[0]);
    }

    protected void startJobAndWait(Job job) throws Exception {
        this.startJob(job);
        this.awaitTermination(new JobExecutionImpl[0]);
    }

    protected void restartAndWait(long ... oldJobExecutionIds) throws InterruptedException {
        long restartId = oldJobExecutionIds.length == 0 ? this.jobExecutionId : oldJobExecutionIds[0];
        this.jobExecutionId = this.jobOperator.restart(restartId, this.params);
        this.jobExecution = (JobExecutionImpl)this.jobOperator.getJobExecution(this.jobExecutionId);
        this.awaitTermination(new JobExecutionImpl[0]);
    }

    protected long getOriginalJobExecutionId(String jobName) {
        List jobInstances = this.jobOperator.getJobInstances(jobName, 0, 1);
        JobInstance jobInstance = (JobInstance)jobInstances.get(0);
        List jobExecutions = this.jobOperator.getJobExecutions(jobInstance);
        JobExecution originalJobExecution = (JobExecution)jobExecutions.get(jobExecutions.size() - 1);
        return originalJobExecution.getExecutionId();
    }

    protected static void switchToUSLocale() {
        originalLocale = Locale.getDefault();
        Locale.setDefault(Locale.US);
    }

    protected static void restoreDefaultLocale() {
        Locale.setDefault(originalLocale);
    }

    protected void verifyMetric(Metric.MetricType metricType, long value) {
        Metric[] metrics;
        boolean metricFound = false;
        for (Metric m : metrics = this.stepExecution0.getMetrics()) {
            if (m.getType() != metricType) continue;
            metricFound = true;
            Assert.assertEquals((long)value, (long)m.getValue());
        }
        if (!metricFound) {
            throw new IllegalStateException("Unmatched MetricType " + metricType);
        }
    }

    protected void assertNoSuchJobExecution(long i) {
        try {
            JobExecution j = this.jobOperator.getJobExecution(i);
            Assert.fail((String)("Expecting NoSuchJobExecutionException, but got " + j));
        }
        catch (NoSuchJobExecutionException e) {
            System.out.printf("Got expected %s%n", new Object[]{e});
        }
    }
}

