/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.testapps.common;

import java.io.Serializable;
import java.util.Arrays;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemReader;
import javax.inject.Inject;
import javax.inject.Named;
import org.jberet.testapps.common.IntegerArrayReaderWriterProcessorBase;

@Named(value="integerArrayReader")
public class IntegerArrayReader
extends IntegerArrayReaderWriterProcessorBase
implements ItemReader {
    @Inject
    @BatchProperty(name="data.count")
    protected Integer dataCount;
    protected Integer[] data;
    protected int cursor;

    public Object readItem() throws Exception {
        if (this.cursor > this.partitionEnd || this.cursor < this.partitionStart) {
            return null;
        }
        Integer result = this.data[this.cursor];
        ++this.cursor;
        if (this.failOnValues != null && Arrays.binarySearch((Object[])this.failOnValues, result) >= 0 && (this.repeatFailure || !this.failedValues.contains(result))) {
            this.failedValues.add(result);
            throw new ArithmeticException("Failing on value " + Arrays.toString((Object[])this.failOnValues));
        }
        return result;
    }

    protected void initData() {
        if (this.dataCount == null) {
            throw new IllegalStateException("data.count property is not injected.");
        }
        this.data = new Integer[this.dataCount.intValue()];
        if (this.partitionEnd == null) {
            this.partitionEnd = this.dataCount - 1;
        }
        for (int i = 0; i < this.dataCount; ++i) {
            this.data[i] = i;
        }
        this.cursor = this.partitionStart;
        System.out.printf("Partition start = %s, end = %s in %s%n", this.partitionStart, this.partitionEnd, this);
    }

    public void open(Serializable checkpoint) throws Exception {
        if (this.data == null) {
            this.initData();
        }
        this.cursor = checkpoint == null ? this.partitionStart : (Integer)checkpoint;
    }

    public Serializable checkpointInfo() throws Exception {
        return Integer.valueOf(this.cursor);
    }
}

