/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.testapps.common;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.batch.api.BatchProperty;
import javax.batch.api.Batchlet;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class SleepBatchlet
implements Batchlet {
    @Inject
    @BatchProperty
    private long sleepMillis;
    @Inject
    @BatchProperty
    private int sleepCount;
    private AtomicBoolean stopRequested = new AtomicBoolean(false);

    public String process() throws Exception {
        if (this.sleepMillis == 0L) {
            return "NO SLEEP";
        }
        if (this.sleepCount == 0) {
            this.sleepCount = 1;
        }
        long duration = 0L;
        for (int i = 0; i < this.sleepCount && !this.stopRequested.get(); ++i) {
            Thread.sleep(this.sleepMillis);
            duration += this.sleepMillis;
        }
        System.out.printf("SleepBatchlet slept for %s milliseconds%n", duration);
        return "SLEPT " + duration;
    }

    public void stop() throws Exception {
        this.stopRequested.set(true);
    }
}

