/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.testapps.common;

import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.ItemWriter;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jberet.testapps.common.IntegerArrayReaderWriterProcessorBase;

@Named(value="integerArrayWriter")
public class IntegerArrayWriter
extends IntegerArrayReaderWriterProcessorBase
implements ItemWriter {
    @Inject
    @BatchProperty(name="writer.sleep.time")
    protected long writerSleepTime;

    public void writeItems(List<Object> items) throws Exception {
        if (items == null) {
            return;
        }
        if (this.failOnValues != null) {
            Object matchingValue = null;
            for (Object e : items) {
                if (Arrays.binarySearch((Object[])this.failOnValues, e) < 0) continue;
                matchingValue = e;
                break;
            }
            if (matchingValue != null && (this.repeatFailure || !this.failedValues.contains(matchingValue))) {
                this.failedValues.add((Integer)matchingValue);
                System.out.printf("About to throw ArithmeticException on value %s%n", matchingValue);
                throw new ArithmeticException("integerArrayWriter failing on value " + String.valueOf(matchingValue));
            }
        }
        if (this.writerSleepTime > 0L) {
            System.out.printf("writerSleepTime: %s millis%n", this.writerSleepTime);
            Thread.sleep(this.writerSleepTime);
        }
        System.out.printf("Wrote Chunk (%s Items): %s%n", items.size(), String.valueOf(items));
        ArrayList<List<Object>> recorded = (ArrayList<List<Object>>)this.stepContext.getPersistentUserData();
        if (recorded == null) {
            recorded = new ArrayList<List<Object>>();
        }
        recorded.add(items);
        this.stepContext.setPersistentUserData(recorded);
    }

    public void open(Serializable checkpoint) throws Exception {
    }

    public Serializable checkpointInfo() throws Exception {
        return null;
    }
}

