/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.testapps.common;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.batch.runtime.context.JobContext;
import jakarta.batch.runtime.context.StepContext;
import jakarta.inject.Inject;

public abstract class PostConstructPreDestroyBase {
    @Inject
    protected JobContext jobContext;
    @Inject
    protected StepContext stepContext;
    private boolean allowAddToJobExitStatus;

    @PostConstruct
    private void ps() {
        System.out.printf("PostConstructPreDestroyBase PostConstruct of %s%n", this);
        String p = this.jobContext.getProperties().getProperty("add.to.job.exit.status");
        this.allowAddToJobExitStatus = Boolean.parseBoolean(p);
        this.addToJobExitStatus("PostConstructPreDestroyBase.ps");
    }

    @PreDestroy
    private void pd() {
        System.out.printf("PostConstructPreDestroyBase PreDestroy of %s%n", this);
        this.addToJobExitStatus("PostConstructPreDestroyBase.pd");
    }

    protected void addToJobExitStatus(String s) {
        if (this.allowAddToJobExitStatus) {
            String jes = this.jobContext.getExitStatus();
            if (jes == null) {
                this.jobContext.setExitStatus(s);
            } else {
                this.jobContext.setExitStatus(jes + " " + s);
            }
        }
    }
}

