/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.testapps.cdiscopes.jobscoped;

import jakarta.batch.api.partition.AbstractPartitionAnalyzer;
import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.context.StepContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.jberet.testapps.cdiscopes.commons.FooFieldTarget;
import org.jberet.testapps.cdiscopes.commons.FooMethodTarget;
import org.jberet.testapps.cdiscopes.jobscoped.Foo;

@Named
public class JobScopePartitionAnalyzer
extends AbstractPartitionAnalyzer {
    @Inject
    private Foo fooTypeTarget;
    @Inject
    @Named(value="jobScopedMethod")
    private FooMethodTarget fooMethodTarget;
    @Inject
    @Named(value="jobScopedField")
    private FooFieldTarget fooFieldTarget;
    @Inject
    private StepContext stepContext;
    private static final int numberOfPartitions = 2;
    private int numberOfPartitionsFinished;

    public void analyzeStatus(BatchStatus batchStatus, String exitStatus) throws Exception {
        String stepName;
        if (++this.numberOfPartitionsFinished == 2 && ((stepName = this.stepContext.getStepName()).equals("jobScopedPartitioned.step2") || stepName.equals("jobScoped2Partitioned.step2"))) {
            int fooTypeSize = this.fooTypeTarget.getStepNames().size();
            int fooMethodSize = this.fooMethodTarget.getStepNames().size();
            int fooFieldSize = this.fooFieldTarget.getStepNames().size();
            int expectedSize = 4;
            if (fooTypeSize != 4 || fooMethodSize != 4 || fooFieldSize != 4) {
                throw new IllegalStateException(String.format("Expecting %s elements, but got fooTypeTarget %s, fooMethodType %s, fooFieldTarget %s", 4, fooTypeSize, fooMethodSize, fooFieldSize));
            }
            String exitStatus1 = String.join((CharSequence)" ", this.fooTypeTarget.getStepNames());
            String exitStatus2 = String.join((CharSequence)" ", this.fooMethodTarget.getStepNames());
            String exitStatus3 = String.join((CharSequence)" ", this.fooFieldTarget.getStepNames());
            this.stepContext.setExitStatus(String.join((CharSequence)" ", exitStatus1, exitStatus2, exitStatus3));
        }
    }
}

