/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.testapps.cdiscopes.partitionscoped;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.batch.api.partition.PartitionAnalyzer;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.context.StepContext;
import javax.inject.Inject;
import javax.inject.Named;
import org.jberet.testapps.cdiscopes.partitionscoped.Foo;
import org.jberet.testapps.cdiscopes.partitionscoped.JobScopedFoo;
import org.jberet.testapps.cdiscopes.partitionscoped.StepScopedFoo;

@Named
public class PartitionScopePartitionAnalyzer
implements PartitionAnalyzer {
    @Inject
    private Foo foo;
    @Inject
    private JobScopedFoo jobScopedFoo;
    @Inject
    private StepScopedFoo stepScopedFoo;
    @Inject
    private StepContext stepContext;
    static final int numberOfPartitions = 3;
    private int numberOfPartitionsFinished;
    private final Set<Serializable> collectedData = new HashSet<Serializable>();
    static final Set<String> expectedData = new HashSet<String>();

    public void analyzeCollectorData(Serializable data) throws Exception {
        if (data != null) {
            this.collectedData.add(data);
        }
    }

    public void analyzeStatus(BatchStatus batchStatus, String exitStatus) throws Exception {
        if (++this.numberOfPartitionsFinished == 3) {
            System.out.printf("In %s, jobScopedFoo: %s, stepScopedFoo: %s%n", this, this.jobScopedFoo, this.stepScopedFoo);
            if (expectedData.equals(this.collectedData)) {
                this.stepContext.setExitStatus(this.collectedData.toString());
            } else {
                throw new IllegalStateException("Expecting collected data: " + expectedData + ", but is " + this.collectedData);
            }
        }
    }

    static {
        expectedData.add(Arrays.asList("partitionScopedPartitioned.step1.A", "partitionScopedPartitioned.step1.A").toString());
        expectedData.add(Arrays.asList("partitionScopedPartitioned.step1.B", "partitionScopedPartitioned.step1.B").toString());
        expectedData.add(Arrays.asList("partitionScopedPartitioned.step1.C", "partitionScopedPartitioned.step1.C").toString());
    }
}

