/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.testapps.postconstruct;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.listener.StepListener;
import jakarta.batch.operations.BatchRuntimeException;
import jakarta.batch.runtime.BatchStatus;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Date;
import org.jberet.runtime.AbstractStepExecution;
import org.jberet.runtime.context.StepContextImpl;
import org.jberet.testapps.common.PostConstructPreDestroyBase;

@Named
public class StepListener1
extends PostConstructPreDestroyBase
implements StepListener {
    @Inject
    @BatchProperty(name="os.name")
    private String osName;

    public void beforeStep() throws Exception {
        this.addToJobExitStatus("StepListener1.beforeStep");
    }

    public void afterStep() throws Exception {
        this.addToJobExitStatus("StepListener1.afterStep");
        StepContextImpl stepContextImpl = (StepContextImpl)this.stepContext;
        AbstractStepExecution stepExecution = stepContextImpl.getStepExecution();
        BatchStatus batchStatus = this.stepContext.getBatchStatus();
        Date endTime = stepExecution.getEndTime();
        System.out.printf("%nStepListener1.afterStep, batchStatus=%s, endTime=%s%n%n", batchStatus, endTime);
        if (batchStatus != BatchStatus.COMPLETED) {
            throw new BatchRuntimeException("Expecting BatchStatus.COMPLETED in StepListener1.afterStep(), but got " + batchStatus);
        }
        if (endTime == null) {
            throw new BatchRuntimeException("Expecting a valid end time in StepListener1.afterStep(), but got " + endTime);
        }
    }

    @PostConstruct
    public void ps() {
        System.out.printf("StepListener1 PostConstruct of %s%n", new Object[]{this});
        if (this.osName == null) {
            throw new BatchRuntimeException("osNmae field has not been initialized when checking from PostConstruct method.");
        }
        this.addToJobExitStatus("StepListener1.ps");
    }

    @PreDestroy
    public void pd() {
        System.out.printf("StepListener1 PreDestroy of %s%n", new Object[]{this});
        this.addToJobExitStatus("StepListener1.pd");
    }
}

