/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authentication.impl.loader.support;

import android.content.Context;
import android.util.Log;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.jboss.aerogear.android.Callback;
import org.jboss.aerogear.android.authentication.AuthenticationModule;
import org.jboss.aerogear.android.authentication.impl.loader.support.AbstractSupportAuthenticationLoader;
import org.jboss.aerogear.android.http.HeaderAndBody;

public class SupportEnrollLoader
extends AbstractSupportAuthenticationLoader {
    private static final String TAG = SupportEnrollLoader.class.getSimpleName();
    private HeaderAndBody result = null;
    private final Map<String, String> params;

    public SupportEnrollLoader(Context context, Callback callback, AuthenticationModule module, Map<String, String> params) {
        super(context, module, callback);
        this.params = params;
    }

    public HeaderAndBody loadInBackground() {
        final CountDownLatch latch = new CountDownLatch(1);
        this.module.enroll(this.params, new Callback<HeaderAndBody>(){

            public void onSuccess(HeaderAndBody data) {
                SupportEnrollLoader.this.result = data;
                latch.countDown();
            }

            public void onFailure(Exception e) {
                SupportEnrollLoader.super.setException(e);
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
        }
        return this.result;
    }

    protected void onStartLoading() {
        if (this.result == null) {
            this.forceLoad();
        } else {
            this.deliverResult(this.result);
        }
    }
}

